<?php

/**
 * Gravity Flow Folders Step
 *
 *
 * @package     GravityFlow
 * @subpackage  Classes/Step
 * @copyright   Copyright (c) 2015-2018, Steven Henty S.L.
 * @license     http://opensource.org/licenses/gpl-3.0.php GNU Public License
 * @since       1.5.1
 */

if ( class_exists( 'Gravity_Flow_Step' ) ) {

	abstract class Gravity_Flow_Step_Folders extends Gravity_Flow_Step {
		protected $_step_type;

		/**
		 * Returns the label for the step.
		 *
		 *
		 * @since 1.5.1
		 *
		 * @return string
		 */
		public function get_label() {
			return $this->_step_type;
		}

		/**
		 * Returns the url/icon for the step.
		 *
		 * @since 1.5.1
		 *
		 * @return string
		 */
		public function get_icon_url() {
			return '<i class="fa fa fa-folder-o" style="color:darkgreen"></i>';
		}

		/**
		 * Returns the folders setting field
		 *
		 * @since 1.8
		 *
		 * @return array
		 */		
		public function get_folder_setting_field() {
			$folders = gravity_flow_folders()->get_folders();

			$folder_choices = array();
			foreach ( $folders as $folder ) {
				$label = $folder->get_name();

				$folder_choices[] = array(
					'label' => $label,
					'name'  => $folder->get_meta_key(),
				);
			}

			$field = array();
			if ( ! empty( $folder_choices ) ) {
				$field = array(
					'name'     => 'folders',
					'required' => true,
					'label'    => esc_html__( 'Folders', 'gravityflowfolders' ),
					'type'     => 'checkbox',
					'choices'  => $folder_choices,
				);
			} else {
				$html     = esc_html__( "You don't have any folders set up.", 'gravityflow' );
				$field    = array(
					'name'  => 'no_folders',
					'label' => esc_html__( 'Folders', 'gravityflowfolders' ),
					'type'  => 'html',
					'html'  => $html,
				);
			}

			return $field;
		}

		/**
		 * Returns the settings for this step.
		 *
		 * @since 1.5.1
		 *
		 * @return array
		 */
		public function get_settings() {
			$fields = array(
				self::get_folder_setting_field()
			);

			return array(
				'title'  => $this->get_label(),
				'fields' => $fields,
			);
		}

		/**
		 * Returns all the folders.
		 *
		 * @since 1.5.1
		 *
		 * @return Gravity_Flow_Folder[]
		 */
		public function get_folders() {
			return gravity_flow_folders()->get_folders();
		}

		/**
		 * Processes the step.
		 *
		 * @since 1.5.1
		 *
		 * @return bool
		 */
		function process() {
			return true;
		}
	}
}
