<?php
/**
 * SportsPress countries
 *
 * The SportsPress countries class stores continent/country data.
 *
 * @class       SP_Countries
 * @version   2.7.9
 * @package     SportsPress/Classes
 * @category    Class
 * @author      ThemeBoy
 */
class SP_Countries {

	/** @var array Array of continents */
	public $continents;

	/** @var array Array of countries */
	public $countries;

	/** @var array Array of legacy 2-letter codes converted to 3-letter codes */
	public $legacy;

	/**
	 * Constructor for the countries class - defines all continents and countries.
	 *
	 * @access public
	 * @return void
	 */
	public function __construct() {
		$continents = array(
			__( 'Africa', 'sportspress' )        => array(
				'alg',
				'ang',
				'bdi',
				'ben',
				'bfa',
				'bot',
				'cgo',
				'cha',
				'civ',
				'cmr',
				'cod',
				'com',
				'cpv',
				'cta',
				'dji',
				'egy',
				'eqg',
				'eri',
				'esh',
				'eth',
				'gab',
				'gam',
				'gha',
				'gnb',
				'gui',
				'ken',
				'lbr',
				'lby',
				'les',
				'mad',
				'mar',
				'mli',
				'moz',
				'mri',
				'mtn',
				'nam',
				'nga',
				'nig',
				'reu',
				'rsa',
				'rwa',
				'sdn',
				'sen',
				'sey',
				'sle',
				'som',
				'ssd',
				'stp',
				'swz',
				'tan',
				'tog',
				'tun',
				'uga',
				'zam',
				'zim',
			),
			__( 'Asia', 'sportspress' )          => array(
				'afg',
				'arm',
				'aze',
				'ban',
				'bhr',
				'bhu',
				'bru',
				'cam',
				'chn',
				'cyp',
				'geo',
				'hkg',
				'ind',
				'irn',
				'irq',
				'isr',
				'jor',
				'jpn',
				'kaz',
				'kgz',
				'kor',
				'ksa',
				'kuw',
				'lao',
				'lib',
				'mac',
				'mas',
				'mdv',
				'mng',
				'mya',
				'nep',
				'oma',
				'pak',
				'phi',
				'ple',
				'prk',
				'qat',
				'sin',
				'sri',
				'syr',
				'tha',
				'tjk',
				'tkm',
				'tpe',
				'uae',
				'uzb',
				'vie',
				'yem',
			),
			__( 'Europe', 'sportspress' )        => array(
				'alb',
				'and',
				'aut',
				'bel',
				'bih',
				'blr',
				'bul',
				'cro',
				'cze',
				'den',
				'end',
				'eng',
				'esp',
				'est',
				'fin',
				'fra',
				'fro',
				'gbr',
				'ger',
				'gib',
				'gre',
				'hun',
				'irl',
				'isl',
				'ita',
				'kos',
				'lie',
				'ltu',
				'lux',
				'lva',
				'mco',
				'mda',
				'mkd',
				'mlt',
				'mne',
				'mwi',
				'ned',
				'nir',
				'nor',
				'pol',
				'por',
				'rou',
				'rus',
				'sco',
				'smr',
				'srb',
				'svk',
				'svn',
				'sui',
				'swe',
				'swz',
				'tur',
				'ukr',
				'vat',
				'wal',
			),
			__( 'North America', 'sportspress' ) => array(
				'atg',
				'aia',
				'aru',
				'bah',
				'ber',
				'blz',
				'brb',
				'can',
				'cay',
				'crc',
				'cub',
				'cuw',
				'dma',
				'dom',
				'glp',
				'grl',
				'grn',
				'gua',
				'hai',
				'hon',
				'jam',
				'lca',
				'mex',
				'mtq',
				'msr',
				'nca',
				'pan',
				'pur',
				'skn',
				'slv',
				'sxm',
				'tca',
				'usa',
				'vgb',
				'vin',
				'vir',
				'wif',
			),
			__( 'Oceania', 'sportspress' )       => array(
				'asa',
				'aus',
				'cok',
				'fij',
				'fsm',
				'gum',
				'idn',
				'kir',
				'mhl',
				'ncl',
				'nru',
				'nzl',
				'plw',
				'png',
				'pyf',
				'sam',
				'sol',
				'tah',
				'tga',
				'tls',
				'tuv',
				'van',
			),
			__( 'South America', 'sportspress' ) => array(
				'arg',
				'bol',
				'bra',
				'chi',
				'col',
				'ecu',
				'guf',
				'guy',
				'par',
				'per',
				'sur',
				'tri',
				'uru',
				'ven',
			),
		);

		$this->countries = apply_filters(
			'sportspress_countries',
			array(
				'afg' => esc_attr__( 'Afghanistan', 'sportspress' ),
				'aia' => esc_attr__( 'Anguilla', 'sportspress' ),
				'alb' => esc_attr__( 'Albania', 'sportspress' ),
				'alg' => esc_attr__( 'Algeria', 'sportspress' ),
				'and' => esc_attr__( 'Andorra', 'sportspress' ),
				'ang' => esc_attr__( 'Angola', 'sportspress' ),
				'arg' => esc_attr__( 'Argentina', 'sportspress' ),
				'arm' => esc_attr__( 'Armenia', 'sportspress' ),
				'aru' => esc_attr__( 'Aruba', 'sportspress' ),
				'asa' => esc_attr__( 'American Samoa', 'sportspress' ),
				'atg' => esc_attr__( 'Antigua and Barbuda', 'sportspress' ),
				'aus' => esc_attr__( 'Australia', 'sportspress' ),
				'aut' => esc_attr__( 'Austria', 'sportspress' ),
				'aze' => esc_attr__( 'Azerbaijan', 'sportspress' ),
				'bah' => esc_attr__( 'Bahamas', 'sportspress' ),
				'ban' => esc_attr__( 'Bangladesh', 'sportspress' ),
				'bdi' => esc_attr__( 'Burundi', 'sportspress' ),
				'bel' => esc_attr__( 'Belgium', 'sportspress' ),
				'ben' => esc_attr__( 'Benin', 'sportspress' ),
				'ber' => esc_attr__( 'Bermuda', 'sportspress' ),
				'bfa' => esc_attr__( 'Burkina Faso', 'sportspress' ),
				'bhr' => esc_attr__( 'Bahrain', 'sportspress' ),
				'bhu' => esc_attr__( 'Bhutan', 'sportspress' ),
				'bih' => esc_attr__( 'Bosnia and Herzegovina', 'sportspress' ),
				'blr' => esc_attr__( 'Belarus', 'sportspress' ),
				'blz' => esc_attr__( 'Belize', 'sportspress' ),
				'bol' => esc_attr__( 'Bolivia', 'sportspress' ),
				'bot' => esc_attr__( 'Botswana', 'sportspress' ),
				'bra' => esc_attr__( 'Brazil', 'sportspress' ),
				'brb' => esc_attr__( 'Barbados', 'sportspress' ),
				'bru' => esc_attr__( 'Brunei', 'sportspress' ),
				'bul' => esc_attr__( 'Bulgaria', 'sportspress' ),
				'cam' => esc_attr__( 'Cambodia', 'sportspress' ),
				'can' => esc_attr__( 'Canada', 'sportspress' ),
				'cay' => esc_attr__( 'Cayman Islands', 'sportspress' ),
				'cgo' => esc_attr__( 'Republic of the Congo', 'sportspress' ),
				'cha' => esc_attr__( 'Chad', 'sportspress' ),
				'chi' => esc_attr__( 'Chile', 'sportspress' ),
				'chn' => esc_attr__( 'China', 'sportspress' ),
				'civ' => esc_attr__( 'Ivory Coast', 'sportspress' ),
				'cmr' => esc_attr__( 'Cameroon', 'sportspress' ),
				'cod' => esc_attr__( 'Democratic Republic of the Congo', 'sportspress' ),
				'cok' => esc_attr__( 'Cook Islands', 'sportspress' ),
				'col' => esc_attr__( 'Colombia', 'sportspress' ),
				'com' => esc_attr__( 'Comoros', 'sportspress' ),
				'cpv' => esc_attr__( 'Cape Verde', 'sportspress' ),
				'crc' => esc_attr__( 'Costa Rica', 'sportspress' ),
				'cro' => esc_attr__( 'Croatia', 'sportspress' ),
				'cta' => esc_attr__( 'Central African Republic', 'sportspress' ),
				'cub' => esc_attr__( 'Cuba', 'sportspress' ),
				'cuw' => esc_attr__( 'Curacao', 'sportspress' ),
				'cyp' => esc_attr__( 'Cyprus', 'sportspress' ),
				'cze' => esc_attr__( 'Czechia', 'sportspress' ),
				'den' => esc_attr__( 'Denmark', 'sportspress' ),
				'dji' => esc_attr__( 'Djibouti', 'sportspress' ),
				'dma' => esc_attr__( 'Dominica', 'sportspress' ),
				'dom' => esc_attr__( 'Dominican Republic', 'sportspress' ),
				'ecu' => esc_attr__( 'Ecuador', 'sportspress' ),
				'egy' => esc_attr__( 'Egypt', 'sportspress' ),
				'eng' => esc_attr__( 'England', 'sportspress' ),
				'eqg' => esc_attr__( 'Equatorial Guinea', 'sportspress' ),
				'eri' => esc_attr__( 'Eritrea', 'sportspress' ),
				'esh' => esc_attr__( 'Western Sahara', 'sportspress' ),
				'esp' => esc_attr__( 'Spain', 'sportspress' ),
				'est' => esc_attr__( 'Estonia', 'sportspress' ),
				'eth' => esc_attr__( 'Ethiopia', 'sportspress' ),
				'fij' => esc_attr__( 'Fiji', 'sportspress' ),
				'fin' => esc_attr__( 'Finland', 'sportspress' ),
				'fra' => esc_attr__( 'France', 'sportspress' ),
				'fro' => esc_attr__( 'Faroe Islands', 'sportspress' ),
				'guf' => esc_attr__( 'French Guiana', 'sportspress' ),
				'pyf' => esc_attr__( 'French Polynesia', 'sportspress' ),
				'fsm' => esc_attr__( 'Micronesia', 'sportspress' ),
				'gab' => esc_attr__( 'Gabon', 'sportspress' ),
				'gam' => esc_attr__( 'Gambia', 'sportspress' ),
				'gbr' => esc_attr__( 'United Kingdom', 'sportspress' ),
				'geo' => esc_attr__( 'Georgia', 'sportspress' ),
				'ger' => esc_attr__( 'Germany', 'sportspress' ),
				'gha' => esc_attr__( 'Ghana', 'sportspress' ),
				'gib' => esc_attr__( 'Gibraltar', 'sportspress' ),
				'glp' => esc_attr__( 'Guadeloupe', 'sportspress' ),
				'gnb' => esc_attr__( 'Guinea-Bissau', 'sportspress' ),
				'gre' => esc_attr__( 'Greece', 'sportspress' ),
				'grl' => esc_attr__( 'Greenland', 'sportspress' ),
				'grn' => esc_attr__( 'Grenada', 'sportspress' ),
				'gua' => esc_attr__( 'Guatemala', 'sportspress' ),
				'gui' => esc_attr__( 'Guinea', 'sportspress' ),
				'gum' => esc_attr__( 'Guam', 'sportspress' ),
				'guy' => esc_attr__( 'Guyana', 'sportspress' ),
				'hai' => esc_attr__( 'Haiti', 'sportspress' ),
				'hkg' => esc_attr__( 'Hong Kong', 'sportspress' ),
				'hon' => esc_attr__( 'Honduras', 'sportspress' ),
				'hun' => esc_attr__( 'Hungary', 'sportspress' ),
				'idn' => esc_attr__( 'Indonesia', 'sportspress' ),
				'ind' => esc_attr__( 'India', 'sportspress' ),
				'irl' => esc_attr__( 'Ireland', 'sportspress' ),
				'irn' => esc_attr__( 'Iran', 'sportspress' ),
				'irq' => esc_attr__( 'Iraq', 'sportspress' ),
				'isl' => esc_attr__( 'Iceland', 'sportspress' ),
				'isr' => esc_attr__( 'Israel', 'sportspress' ),
				'ita' => esc_attr__( 'Italy', 'sportspress' ),
				'jam' => esc_attr__( 'Jamaica', 'sportspress' ),
				'jor' => esc_attr__( 'Jordan', 'sportspress' ),
				'jpn' => esc_attr__( 'Japan', 'sportspress' ),
				'kaz' => esc_attr__( 'Kazakhstan', 'sportspress' ),
				'ken' => esc_attr__( 'Kenya', 'sportspress' ),
				'kos' => esc_attr__( 'Kosovo', 'sportspress' ),
				'kgz' => esc_attr__( 'Kyrgyzstan', 'sportspress' ),
				'kir' => esc_attr__( 'Kiribati', 'sportspress' ),
				'mtq' => esc_attr__( 'Martinique', 'sportspress' ),
				'kor' => esc_attr__( 'South Korea', 'sportspress' ),
				'ksa' => esc_attr__( 'Saudi Arabia', 'sportspress' ),
				'kuw' => esc_attr__( 'Kuwait', 'sportspress' ),
				'lao' => esc_attr__( 'Laos', 'sportspress' ),
				'lbr' => esc_attr__( 'Liberia', 'sportspress' ),
				'lby' => esc_attr__( 'Libya', 'sportspress' ),
				'lca' => esc_attr__( 'Saint Lucia', 'sportspress' ),
				'les' => esc_attr__( 'Lesotho', 'sportspress' ),
				'lib' => esc_attr__( 'Lebanon', 'sportspress' ),
				'lie' => esc_attr__( 'Liechtenstein', 'sportspress' ),
				'ltu' => esc_attr__( 'Lithuania', 'sportspress' ),
				'lux' => esc_attr__( 'Luxembourg', 'sportspress' ),
				'lva' => esc_attr__( 'Latvia', 'sportspress' ),
				'mac' => esc_attr__( 'Macau', 'sportspress' ),
				'mad' => esc_attr__( 'Madagascar', 'sportspress' ),
				'mar' => esc_attr__( 'Morocco', 'sportspress' ),
				'mas' => esc_attr__( 'Malaysia', 'sportspress' ),
				'mco' => esc_attr__( 'Monaco', 'sportspress' ),
				'mda' => esc_attr__( 'Moldova', 'sportspress' ),
				'mdv' => esc_attr__( 'Maldives', 'sportspress' ),
				'mex' => esc_attr__( 'Mexico', 'sportspress' ),
				'mhl' => esc_attr__( 'Marshall Islands', 'sportspress' ),
				'mkd' => esc_attr__( 'North Macedonia', 'sportspress' ),
				'mli' => esc_attr__( 'Mali', 'sportspress' ),
				'mlt' => esc_attr__( 'Malta', 'sportspress' ),
				'mne' => esc_attr__( 'Montenegro', 'sportspress' ),
				'mng' => esc_attr__( 'Mongolia', 'sportspress' ),
				'moz' => esc_attr__( 'Mozambique', 'sportspress' ),
				'mri' => esc_attr__( 'Mauritius', 'sportspress' ),
				'msr' => esc_attr__( 'Montserrat', 'sportspress' ),
				'mtn' => esc_attr__( 'Mauritania', 'sportspress' ),
				'mwi' => esc_attr__( 'Malawi', 'sportspress' ),
				'mya' => esc_attr__( 'Myanmar', 'sportspress' ),
				'nam' => esc_attr__( 'Namibia', 'sportspress' ),
				'nca' => esc_attr__( 'Nicaragua', 'sportspress' ),
				'ncl' => esc_attr__( 'New Caledonia', 'sportspress' ),
				'ned' => esc_attr__( 'Netherlands', 'sportspress' ),
				'nep' => esc_attr__( 'Nepal', 'sportspress' ),
				'nga' => esc_attr__( 'Nigeria', 'sportspress' ),
				'nig' => esc_attr__( 'Niger', 'sportspress' ),
				'nir' => esc_attr__( 'Northern Ireland', 'sportspress' ),
				'nor' => esc_attr__( 'Norway', 'sportspress' ),
				'nru' => esc_attr__( 'Nauru', 'sportspress' ),
				'nzl' => esc_attr__( 'New Zealand', 'sportspress' ),
				'oma' => esc_attr__( 'Oman', 'sportspress' ),
				'pak' => esc_attr__( 'Pakistan', 'sportspress' ),
				'pan' => esc_attr__( 'Panama', 'sportspress' ),
				'par' => esc_attr__( 'Paraguay', 'sportspress' ),
				'per' => esc_attr__( 'Peru', 'sportspress' ),
				'phi' => esc_attr__( 'Philippines', 'sportspress' ),
				'ple' => esc_attr__( 'Palestine', 'sportspress' ),
				'plw' => esc_attr__( 'Palau', 'sportspress' ),
				'png' => esc_attr__( 'Papua New Guinea', 'sportspress' ),
				'pol' => esc_attr__( 'Poland', 'sportspress' ),
				'por' => esc_attr__( 'Portugal', 'sportspress' ),
				'prk' => esc_attr__( 'North Korea', 'sportspress' ),
				'pur' => esc_attr__( 'Puerto Rico', 'sportspress' ),
				'qat' => esc_attr__( 'Qatar', 'sportspress' ),
				'rou' => esc_attr__( 'Romania', 'sportspress' ),
				'rsa' => esc_attr__( 'South Africa', 'sportspress' ),
				'reu' => esc_attr__( 'Reunion', 'sportspress' ),
				'rus' => esc_attr__( 'Russia', 'sportspress' ),
				'rwa' => esc_attr__( 'Rwanda', 'sportspress' ),
				'sam' => esc_attr__( 'Samoa', 'sportspress' ),
				'sco' => esc_attr__( 'Scotland', 'sportspress' ),
				'sdn' => esc_attr__( 'Sudan', 'sportspress' ),
				'sen' => esc_attr__( 'Senegal', 'sportspress' ),
				'sey' => esc_attr__( 'Seychelles', 'sportspress' ),
				'sin' => esc_attr__( 'Singapore', 'sportspress' ),
				'skn' => esc_attr__( 'Saint Kitts and Nevis', 'sportspress' ),
				'sle' => esc_attr__( 'Sierra Leone', 'sportspress' ),
				'slv' => esc_attr__( 'El Salvador', 'sportspress' ),
				'smr' => esc_attr__( 'San Marino', 'sportspress' ),
				'sol' => esc_attr__( 'Solomon Islands', 'sportspress' ),
				'som' => esc_attr__( 'Somalia', 'sportspress' ),
				'srb' => esc_attr__( 'Serbia', 'sportspress' ),
				'sri' => esc_attr__( 'Sri Lanka', 'sportspress' ),
				'ssd' => esc_attr__( 'South Sudan', 'sportspress' ),
				'stp' => esc_attr__( 'Sao Tome and Principe', 'sportspress' ),
				'sui' => esc_attr__( 'Switzerland', 'sportspress' ),
				'sur' => esc_attr__( 'Suriname', 'sportspress' ),
				'svk' => esc_attr__( 'Slovakia', 'sportspress' ),
				'svn' => esc_attr__( 'Slovenia', 'sportspress' ),
				'swe' => esc_attr__( 'Sweden', 'sportspress' ),
				'swz' => esc_attr__( 'Eswatini', 'sportspress' ),
				'sxm' => esc_attr__( 'Sint Maarten', 'sportspress' ),
				'syr' => esc_attr__( 'Syria', 'sportspress' ),
				'tah' => esc_attr__( 'Tahiti', 'sportspress' ),
				'tan' => esc_attr__( 'Tanzania', 'sportspress' ),
				'tca' => esc_attr__( 'Turks and Caicos Islands', 'sportspress' ),
				'tga' => esc_attr__( 'Tonga', 'sportspress' ),
				'tha' => esc_attr__( 'Thailand', 'sportspress' ),
				'tjk' => esc_attr__( 'Tajikistan', 'sportspress' ),
				'tkm' => esc_attr__( 'Turkmenistan', 'sportspress' ),
				'tls' => esc_attr__( 'East Timor', 'sportspress' ),
				'tog' => esc_attr__( 'Togo', 'sportspress' ),
				'tpe' => esc_attr__( 'Taiwan', 'sportspress' ),
				'tri' => esc_attr__( 'Trinidad and Tobago', 'sportspress' ),
				'tun' => esc_attr__( 'Tunisia', 'sportspress' ),
				'tur' => esc_attr__( 'Turkey', 'sportspress' ),
				'tuv' => esc_attr__( 'Tuvalu', 'sportspress' ),
				'uae' => esc_attr__( 'United Arab Emirates', 'sportspress' ),
				'uga' => esc_attr__( 'Uganda', 'sportspress' ),
				'ukr' => esc_attr__( 'Ukraine', 'sportspress' ),
				'uru' => esc_attr__( 'Uruguay', 'sportspress' ),
				'usa' => esc_attr__( 'United States', 'sportspress' ),
				'uzb' => esc_attr__( 'Uzbekistan', 'sportspress' ),
				'van' => esc_attr__( 'Vanuatu', 'sportspress' ),
				'vat' => esc_attr__( 'Vatican City', 'sportspress' ),
				'ven' => esc_attr__( 'Venezuela', 'sportspress' ),
				'vgb' => esc_attr__( 'British Virgin Islands', 'sportspress' ),
				'vie' => esc_attr__( 'Vietnam', 'sportspress' ),
				'vin' => esc_attr__( 'Saint Vincent and the Grenadines', 'sportspress' ),
				'vir' => esc_attr__( 'US Virgin Islands', 'sportspress' ),
				'wal' => esc_attr__( 'Wales', 'sportspress' ),
				'wif' => esc_attr__( 'West Indies', 'sportspress' ),
				'yem' => esc_attr__( 'Yemen', 'sportspress' ),
				'zam' => esc_attr__( 'Zambia', 'sportspress' ),
				'zim' => esc_attr__( 'Zimbabwe', 'sportspress' ),
			)
		);

		$this->legacy = array(
			'ad' => 'and',
			'ae' => 'uae',
			'af' => 'afg',
			'ag' => 'atg',
			'al' => 'alb',
			'am' => 'arm',
			'ao' => 'ang',
			'ar' => 'arg',
			'at' => 'aut',
			'au' => 'aus',
			'az' => 'aze',
			'ba' => 'bih',
			'bb' => 'brb',
			'bd' => 'ban',
			'be' => 'bel',
			'bf' => 'bfa',
			'bg' => 'bul',
			'bh' => 'bhr',
			'bi' => 'bdi',
			'bj' => 'ben',
			'bn' => 'bru',
			'bo' => 'bol',
			'br' => 'bra',
			'bs' => 'bah',
			'bt' => 'bhu',
			'bw' => 'bot',
			'by' => 'blr',
			'bz' => 'blz',
			'ca' => 'can',
			'cd' => 'cod',
			'cf' => 'cta',
			'cg' => 'cgo',
			'ch' => 'swz',
			'ci' => 'civ',
			'cl' => 'chi',
			'cm' => 'cmr',
			'cn' => 'chn',
			'co' => 'col',
			'cr' => 'crc',
			'cu' => 'cub',
			'cv' => 'cpv',
			'cy' => 'cyp',
			'cz' => 'cze',
			'de' => 'ger',
			'dj' => 'dji',
			'dk' => 'den',
			'dm' => 'dma',
			'do' => 'dom',
			'dz' => 'alg',
			'ec' => 'ecu',
			'ee' => 'est',
			'eg' => 'egy',
			'eh' => 'esh',
			'el' => 'gre',
			'en' => 'end',
			'er' => 'eri',
			'es' => 'esp',
			'et' => 'eth',
			'fi' => 'fin',
			'fj' => 'fij',
			'fm' => 'fsm',
			'fr' => 'fra',
			'ga' => 'gab',
			'gb' => 'gbr',
			'gd' => 'grn',
			'ge' => 'geo',
			'gh' => 'gha',
			'gm' => 'gam',
			'gn' => 'gui',
			'gq' => 'eqg',
			'gr' => 'gre',
			'gt' => 'gua',
			'gw' => 'gnb',
			'gy' => 'guy',
			'hk' => 'hkg',
			'hn' => 'hon',
			'hr' => 'cro',
			'ht' => 'hai',
			'hu' => 'hun',
			'id' => 'idn',
			'ie' => 'irl',
			'il' => 'isr',
			'in' => 'ind',
			'iq' => 'irq',
			'ir' => 'irn',
			'is' => 'isl',
			'it' => 'ita',
			'jm' => 'jam',
			'jo' => 'jor',
			'jp' => 'jpn',
			'ke' => 'ken',
			'kg' => 'kgz',
			'kh' => 'cam',
			'ki' => 'kir',
			'km' => 'com',
			'kn' => 'skn',
			'kp' => 'prk',
			'kr' => 'kor',
			'kw' => 'kuw',
			'kz' => 'kaz',
			'la' => 'lao',
			'lb' => 'lib',
			'lc' => 'lca',
			'li' => 'lie',
			'lk' => 'sri',
			'lr' => 'lbr',
			'ls' => 'les',
			'lt' => 'ltu',
			'lu' => 'lux',
			'lv' => 'lva',
			'ly' => 'lby',
			'ma' => 'mar',
			'mc' => 'mco',
			'md' => 'mda',
			'me' => 'mne',
			'mg' => 'mad',
			'mh' => 'mhl',
			'mk' => 'mkd',
			'ml' => 'mli',
			'mm' => 'mya',
			'mn' => 'mng',
			'mo' => 'mac',
			'mr' => 'mtn',
			'mt' => 'mlt',
			'mu' => 'mri',
			'mv' => 'mdv',
			'mw' => 'mwi',
			'mx' => 'mex',
			'my' => 'mas',
			'mz' => 'moz',
			'na' => 'nam',
			'nb' => 'nir',
			'ne' => 'nig',
			'ng' => 'nga',
			'ni' => 'nca',
			'nl' => 'ned',
			'no' => 'nor',
			'np' => 'nep',
			'nr' => 'nru',
			'nz' => 'nzl',
			'om' => 'oma',
			'pa' => 'pan',
			'pe' => 'per',
			'pg' => 'png',
			'ph' => 'phi',
			'pk' => 'pak',
			'pl' => 'pol',
			'pr' => 'pur',
			'ps' => 'ple',
			'pt' => 'por',
			'pw' => 'plw',
			'py' => 'par',
			'qa' => 'qat',
			'ro' => 'rou',
			'rs' => 'srb',
			'ru' => 'rus',
			'rw' => 'rwa',
			'sa' => 'ksa',
			'sb' => 'sol',
			'sc' => 'sey',
			'sd' => 'sdn',
			'se' => 'swe',
			'sf' => 'sco',
			'sg' => 'sin',
			'si' => 'svn',
			'sk' => 'svk',
			'sl' => 'sle',
			'sm' => 'smr',
			'sn' => 'sen',
			'so' => 'som',
			'sr' => 'sur',
			'st' => 'stp',
			'sv' => 'slv',
			'sy' => 'syr',
			'sz' => 'swz',
			'td' => 'cha',
			'tg' => 'tog',
			'th' => 'tha',
			'tj' => 'tjk',
			'tl' => 'tls',
			'tm' => 'tkm',
			'tn' => 'tun',
			'to' => 'tga',
			'tr' => 'tur',
			'tt' => 'tri',
			'tv' => 'tuv',
			'tw' => 'tpw',
			'tz' => 'tan',
			'ua' => 'ukr',
			'uk' => 'gbr',
			'ug' => 'uga',
			'us' => 'usa',
			'uy' => 'uru',
			'uz' => 'uzb',
			'va' => 'vat',
			'vc' => 'vin',
			've' => 'ven',
			'vn' => 'vie',
			'vu' => 'van',
			'wl' => 'wal',
			'ws' => 'sam',
			'ye' => 'yem',
			'za' => 'rsa',
			'zm' => 'zam',
			'zw' => 'zim',
		);

		foreach ( $continents as $continent => $codes ) :
			$countries = array_intersect_key( $this->countries, array_flip( $codes ) );
			asort( $countries );
			$continents[ $continent ] = $countries;
		endforeach;

		$this->continents = apply_filters( 'sportspress_continents', $continents );
	}

	/**
	 * Get the base country.
	 *
	 * @access public
	 * @return string
	 */
	public function get_base_country() {
		$default = get_option( 'sportspress_default_country' );
		$country = ( ( $pos = strrpos( $default, ':' ) ) === false ) ? $default : substr( $default, 0, $pos );

		return apply_filters( 'sportspress_countries_base_country', $country );
	}


	/**
	 * Outputs the list of continents and countries for use in dropdown boxes.
	 *
	 * @access public
	 * @param string $selected_country (default: '')
	 * @param bool   $escape (default: false)
	 * @return void
	 */
	public function country_dropdown_options( $selected_country = '', $escape = false ) {
		if ( $this->continents ) {
			foreach ( $this->continents as $continent => $countries ) :
				?>
				<optgroup label="<?php echo esc_attr( $continent ); ?>">
					<?php foreach ( $countries as $code => $country ) : ?>
						<option value="<?php echo esc_attr( $code ); ?>" <?php selected( $selected_country, $code ); ?>><?php echo esc_html( $country ); ?></option>
					<?php endforeach; ?>
				</optgroup>
				<?php
		endforeach;
		}
	}
}
