/*! © JetSloth — SPDX-License-Identifier: GPL-2.0-or-later */

var gfttAdmin = gfttAdmin || {};

(function($){
	'use strict';

	var GF_EDITOR_VERSION = gfttAdmin.GF_EDITOR_VERSION = ( tooltipsVars.is_gf_min_2_5 !== "" ) ? 2 : 1;
	var GF_MARKUP_VERSION = gfttAdmin.GF_MARKUP_VERSION = GF_EDITOR_VERSION;

	var gfttIcon = '<i class="gftt-icon"></i>';
	var previewUpdateDelay

	gfttAdmin.getField = function( field ) {
		field = field || GetSelectedField();
		return $('#field_'+field.id);
	};

	gfttAdmin.getSettingsElement = function() {
		var fieldSettingsSelector = '#field_settings_container';// GF 2.5+
		var field = GetSelectedField();
		fieldSettingsSelector += ( field.type === "quiz" ) ? ', #gquiz_gfield_settings_choices_container' : ', #gfield_settings_choices_container'
		return $(fieldSettingsSelector);
	};

	gfttAdmin.getChoicesSettingsElement = function() {
		var fieldSettingsSelector = ( GF_EDITOR_VERSION === 1 ) ? '#field_settings' : '#choices-ui-flyout';
		return $(fieldSettingsSelector)
	};

	gfttAdmin.getChoicesToggleElement = function() {
		return gfttAdmin.getChoicesSettingsElement().find('input.gftt_choices_toggle')
	};

	gfttAdmin.getGppaChoicesToggleElement = function() {
		return gfttAdmin.getSettingsElement().find('input.gftt_gppa_choices_toggle')
	};

	gfttAdmin.isGppaChoicesEnabled = function(field) {
		field = field || GetSelectedField();
		return ( rgar(field, 'gppa-choices-enabled') === true );
	};

	gfttAdmin.updateChoicesPreview = function( field ) {
		if ( !field && typeof GetSelectedField === 'undefined' ) {
			return;
		}
		field = field || GetSelectedField();
		if ( !field || field.type === "list" || !field.choices || !field.choices.length ) {
			return
		}
		var enabled = gfttAdmin.isChoicesTooltipsEnabled(field);
		var $field = gfttAdmin.getField(field);

		var isImageChoicesOrColorPickerEnabled = ( (typeof imageChoicesAdmin !== 'undefined' && imageChoicesAdmin.isImageChoicesEnabled(field)) || (typeof colorPickerAdmin !== 'undefined' && colorPickerAdmin.isColorPickerEnabled(field)) );

		var isGppaChoices = gfttAdmin.isGppaChoicesEnabled();
		var hasGppaTooltips = ( enabled && isGppaChoices );

		$.each(field.choices, function(i, choice){

			var tooltipValue = (choice.hasOwnProperty('jbTooltipContent')) ? choice.jbTooltipContent : '';

			var $choice = $field.find('.ginput_container .gchoice:eq(' + i + ')');
			var $label = $choice.find('label');
			var $icon = $choice.find('.gftt-icon');
			var $targetWrap = isImageChoicesOrColorPickerEnabled ? $choice : $label;

			var hasTooltip = ( enabled && ( tooltipValue !== '' || hasGppaTooltips ) );
			$choice.toggleClass('has-tooltip', hasTooltip);

			if ( hasTooltip ) {
				if ( !$icon.length ) {
					// if no icon, add a new one
					$targetWrap.append( gfttIcon );
				}
				else if ( !$targetWrap.find('.gftt-icon').length ) {
					// else if icon is not within the correct wrapper, move it
					$icon.detach().appendTo( $targetWrap );
				}
			}
			else if ( (!enabled || tooltipValue === '') && $icon.length ) {
				$icon.remove();
			}
		});
	};

	gfttAdmin.updateFieldPreview = function( field ) {
		field = field || GetSelectedField();

		var hasTooltip = ( field.hasOwnProperty('jbTooltipContent') && field.jbTooltipContent !== "" );
		var $label = $('#field_' + field.id + ' .gfield_label');
		var $icon = $label.find('.gftt-icon');

		if ( hasTooltip && !$icon.length ) {
			$label.append( gfttIcon );
		}
		else if ( !hasTooltip && $icon.length ) {
			$icon.remove();
		}
	};

	gfttAdmin.onToggleChoicesTooltips = function( enable ) {
		var gppaChoicesEnabled = gfttAdmin.isGppaChoicesEnabled();
		var $toggle = gppaChoicesEnabled ? gfttAdmin.getGppaChoicesToggleElement() : gfttAdmin.getChoicesToggleElement();
		if ( !$toggle.length ) {
			return
		}

		if (enable === undefined) {
			enable = $toggle.is(':checked');
		}

		SetFieldProperty('gftt_choicesEnabled', enable);

		$toggle.prop('checked', enable);

		if ( gppaChoicesEnabled ) {
			gfttAdmin.getSettingsElement().toggleClass('gf-tooltips-choices-enabled', enable);
		}
		else {
			gfttAdmin.getChoicesSettingsElement().toggleClass('gf-tooltips-choices-enabled', enable);
		}

		clearTimeout(previewUpdateDelay);
		previewUpdateDelay = setTimeout(function(){
			gfttAdmin.updateChoicesPreview();
		}, 100);
	};

	gfttAdmin.toggleChoicesTooltips = function( enable ) {
		var gppaChoicesEnabled = gfttAdmin.isGppaChoicesEnabled();
		var $toggle = gppaChoicesEnabled ? gfttAdmin.getGppaChoicesToggleElement() : gfttAdmin.getChoicesToggleElement();
		if ( !$toggle.length ) {
			return
		}

		if ( enable === undefined ) {
			enable = $toggle.is(':checked');
		}
		gfttAdmin.onToggleChoicesTooltips( enable );
	};

	gfttAdmin.isChoicesTooltipsEnabled = function( field ) {
		field = field || GetSelectedField();
		return ( field && field.type !== "list" && field.hasOwnProperty('gftt_choicesEnabled') ) ? field.gftt_choicesEnabled : false
	};

	gfttAdmin.fieldSupportsChoicesTooltips = function( field ) {
		field = field || GetSelectedField();
		if ( !field || field.type === "select" || field.type === "list" || ( field.inputType && field.inputType !== "radio" && field.inputType !== "checkbox" ) ) {
			return false;
		}
		return true;
	};


	$(document).bind('gform_load_field_settings', function (event, field, form) {

		if ( !gfttAdmin.fieldSupportsChoicesTooltips( field ) ) {
			gfttAdmin.getChoicesSettingsElement().find('.gftt-choices-toggle').hide();
			gfttAdmin.getSettingsElement().find('.gftt-gppa-choices-toggle').hide();
			SetFieldProperty('gftt_choicesEnabled', false);
		}
		else {
			gfttAdmin.getChoicesSettingsElement().find('.gftt-choices-toggle').show();
			if ( gfttAdmin.isGppaChoicesEnabled(field) ) {
				gfttAdmin.getSettingsElement().find('.gftt-gppa-choices-toggle').show();
			}
		}

		GF_MARKUP_VERSION = (form.hasOwnProperty('markupVersion') && form.markupVersion !== '') ? form.markupVersion : 1;

		if ( typeof field.jbTooltipContent === 'undefined' ) {
			field.jbTooltipContent = '';
		}
		$( '#gftt-tooltip' ).val( field.jbTooltipContent );

		var enabled = gfttAdmin.isChoicesTooltipsEnabled(field);
		gfttAdmin.onToggleChoicesTooltips( enabled );
	});

	gform.addFilter('gform_append_field_choice_option', function(optionHTML, field, choiceIndex){

		if ( field.type === "select" || field.type === "list" || ( field.inputType && field.inputType !== "radio" && field.inputType !== "checkbox" ) ) {
			if ( optionHTML.indexOf('gf-tooltips-choice-content') !== -1 ) {
				var $option = $("<div>" + optionHTML + "</div>");
				$option.find('.gf-tooltips-choice-content').remove();
				optionHTML = $option.html();
			}
			return optionHTML;
		}

		var choicesContainerID = ( field.type === 'quiz' ) ? 'gquiz_gfield_settings_choices_container' : 'gfield_settings_choices_container';
		$('#' + choicesContainerID).addClass('gf-tooltips-choices-settings');

		if ( optionHTML.indexOf('gf-tooltips-choice-content') === -1 ) {
			optionHTML += '<textarea class="field-choice-input field-choice-text gform-input gf-tooltips-choice-content" placeholder="Tooltip Content"></textarea>';
		}

		return optionHTML;
	});


	gform.addAction('gform_after_refresh_field_preview', function(fieldID){
		var field = GetFieldById(fieldID);

		clearTimeout(previewUpdateDelay);
		previewUpdateDelay = setTimeout(function(){
			gfttAdmin.updateChoicesPreview( field );
		}, 100);
	});

	gform.addAction('gform_load_field_choices', function(fields){
		//var field = fields[0]
		var field = GetSelectedField();
		if ( field.type === "select" || field.type === "list" || ( field.inputType && field.inputType !== "radio" && field.inputType !== "checkbox" ) ) {
			return;
		}

		var choicesContainerID = ( field.type === 'quiz' ) ? 'gquiz_gfield_settings_choices_container' : 'gfield_settings_choices_container';
		$('#' + choicesContainerID + '.gf-tooltips-choices-settings .field-choice-row').each(function(){
			var $row = $(this);
			if ( $row.find('.gf-tooltips-choice-content ~ .gf_insert_field_choice').length ) {
				$row.find('.gf-tooltips-choice-content').detach().appendTo( $row );
			}
			else if ( !$row.find('.gf-tooltips-choice-content').length ) {
				$row.append( $('<textarea class="field-choice-input field-choice-text gform-input gf-tooltips-choice-content" placeholder="Tooltip Content"></textarea>') );
			}
		});

		$.each(field.choices, function(i, choice){
			if ( typeof choice.jbTooltipContent === 'undefined' ) {
				field.choices[i].jbTooltipContent = '';
			}
			var $input = gfttAdmin.getChoicesSettingsElement().find('.gf-tooltips-choice-content:eq(' + i + ')');
			if ( $input.length ) {
				$input.val( field.choices[i].jbTooltipContent );
			}
		});

	});


	$( document ).ready( function() {

		if ( typeof form !== 'undefined' && form.hasOwnProperty('markupVersion') ) {
			GF_MARKUP_VERSION = (form.markupVersion !== '') ? form.markupVersion : 1;
		}

		// FORM EDITOR
		$( document ).on('change', '#gftt-tooltip', function() {
			var $self = $( this );
			window.SetFieldProperty( 'jbTooltipContent', $self.val() );
			gfttAdmin.updateFieldPreview();
		});

		$( document ).on('change', '.gf-tooltips-choice-content', function() {
			var $self = $(this);
			var index = gfttAdmin.getChoicesSettingsElement().find('.gf-tooltips-choice-content').index( $self );
			var field = GetSelectedField();
			field.choices[index].jbTooltipContent = $self.val();

			clearTimeout(previewUpdateDelay);
			previewUpdateDelay = setTimeout(function(){
				gfttAdmin.updateChoicesPreview();
			}, 100);
		});

		// gppa
		$( document ).on('change', '#gppa-choices-enabled', function() {
			gfttAdmin.getSettingsElement().find('.gftt-gppa-choices-toggle').toggle( $(this).is(':checked') );
		});

		// SETTINGS
		var $overrideField = (GF_EDITOR_VERSION === 1) ? $('#gaddon-setting-row-gf_tooltips_override_global') : $('#gform_setting_gf_tooltips_override_global');
		var isFormSettings = ($overrideField.length);
		var $iconSettingsInputs = (GF_EDITOR_VERSION === 1) ? $( '#gaddon-setting-row-ttIcon input[type=radio]' ) : $( '#gform_setting_ttIcon input[type=radio]' );

		if ( $iconSettingsInputs.length ) {
			// We're on a settings page

			$( '.gftt-number' ).attr( { type : 'number', min : 10, max : 30 } ).after( '<span> px</span>' );
			$( '.gftt-width' ).attr( { type : 'number', min : 100, max : 1000 } ).after( '<span> px</span>' );
			$( '.gftt-color-picker' ).wpColorPicker();

			$iconSettingsInputs.each( function( i, v ) {
				$( this ).next().addClass( 'gftt-icon-' + ( i + 1 ) ).html( '' ).show();
			});

			if ( !isFormSettings && !$("input[name$=\"_ttIcon\"]:checked").val() ) {
				$( '#ttIcon0' ).prop( 'checked', true );
			}

			if ($overrideField.length) {

				if (GF_EDITOR_VERSION === 1) {
					$overrideField.find('th').hide();
				}

				$overrideField.find('input:checkbox').on('change', function(){

					var isChecked = $(this).is(':checked');
					var $section = ( GF_EDITOR_VERSION === 1 ) ? $('.gaddon-section:not(.gaddon-first-section)').find('.gaddon-section-title, [id^="gaddon-setting-row"]') : $('#gform-settings .gform-settings-panel:not(:first-child)');
					$section.toggle(isChecked);
					if (!isChecked) {
						$section.find('input[type="text"]').val('');
						$section.find('input[type="number"]').val('');
						$section.find('input[type="radio"]:checked').prop('checked', false);
						$section.find('select option:selected').prop('selected', false);
						$section.find('select').val('');
						$('.wp-picker-clear').trigger('click');
					}

				}).trigger('change');
			}

		}

	});

})(jQuery);
