<div
    :class="[container_class, is_bordered ? 'wpuf-border wpuf-border-gray-300 wpuf-shadow-sm' : '']"
    class="wpuf-dropdown wpuf-dropdown-bottom wpuf-dropdown-end wpuf-relative wpuf-rounded-[6px]">
    <div
        tabindex="0"
        role="button"
        @click="is_open = !is_open"
        :class="placeholder_class"
        class="wpuf-flex wpuf-justify-between wpuf-items-center wpuf-text-gray-700 wpuf-px-2 wpuf-py-1">
        {{ selected }}
        <i
            v-if="show_icon"
            :class="is_open ? 'fa fa-angle-up' : 'fa fa-angle-down'"
            class="form-switcher-arrow wpuf-ml-2"></i>
    </div>
    <ul tabindex="0"
        v-if="is_open"
        :class="dropdown_class"
        class="wpuf-absolute wpuf-dropdown-content wpuf-menu !wpuf-p-0 wpuf-rounded-md wpuf-z-[1] wpuf-w-52 wpuf-shadow wpuf-bg-white wpuf-left-0 !wpuf-top-8">
        <li v-for="option in options" :class="dropdown_item_class">
            <a
                @click="selectOption(option.value); is_open = false; $emit('change', option.value)"
                :class="dropdown_link_class"
                class="wpuf-block wpuf-rounded-none wpuf-font-medium wpuf-text-left wpuf-px-4 wpuf-py-2 !wpuf-text-sm wpuf-text-gray-700 hover:wpuf-bg-gray-100 hover:wpuf-text-gray-900 focus:wpuf-shadow-none focus:wpuf-outline-none">
                {{ option.label }}
            </a>
        </li>
    </ul>
</div>
