<div class="wpuf-submit-button-conditional-logic-container">
    <div class="wpuf-my-4 wpuf-input-container">
        <div class="wpuf-flex wpuf-items-center">
            <label class="wpuf-flex wpuf-text-sm wpuf-text-gray-700 wpuf-my-2">
                {{ label }}
                <help-text :text="'Choose whether to apply conditions for submit button visibility'"></help-text>
            </label>
        </div>
        <div>
            <label style="margin-right: 2rem;">
                <input
                    type="radio"
                    name="wpuf_settings[submit_button_cond][condition_status]"
                    value="yes"
                    v-model="condition_status"
                    class="wpuf-submit-conditional-logic !wpuf-mr-2 wpuf-radio !wpuf-shadow-none checked:!wpuf-shadow-none focus:checked:!wpuf-shadow-primary !wpuf-border-gray-300 checked:!wpuf-border-primary checked:!wpuf-bg-primary before:checked:!wpuf-bg-white hover:checked:!wpuf-bg-primary focus:!wpuf-ring-transparent focus:checked:!wpuf-ring-transparent hover:checked:!wpuf-ring-transparent focus:checked:!wpuf-bg-primary focus:checked:!wpuf-shadow-none focus:wpuf-shadow-primary">
                <?php _e( 'Yes', 'wpuf-pro' ); ?>
            </label>
            <label>
                <input
                    type="radio"
                    name="wpuf_settings[submit_button_cond][condition_status]"
                    value="no"
                    v-model="condition_status"
                    class="wpuf-submit-conditional-logic !wpuf-mr-2 wpuf-radio !wpuf-shadow-none checked:!wpuf-shadow-none focus:checked:!wpuf-shadow-primary !wpuf-border-gray-300 checked:!wpuf-border-primary checked:!wpuf-bg-primary before:checked:!wpuf-bg-white hover:checked:!wpuf-bg-primary focus:!wpuf-ring-transparent focus:checked:!wpuf-ring-transparent hover:checked:!wpuf-ring-transparent focus:checked:!wpuf-bg-primary focus:checked:!wpuf-shadow-none focus:wpuf-shadow-primary">
                <?php _e( 'No', 'wpuf-pro' ); ?>
            </label>
        </div>
    </div>

    <div v-if="condition_status === 'yes'" class="wpuf-conditional-logic-settings wpuf-my-4">
        <p class="wpuf-text-sm wpuf-leading-6 wpuf-mb-4">
            <span class="wpuf-mb-3 wpuf-block">
                <?php
                printf(
                    __( 'Show submit button when%s%s%sof these rules are met%s', 'wpuf-pro' ),
                    '</span>',
                    '<select v-model="cond_logic" name="wpuf_settings[submit_button_cond][cond_logic]" class="wpuf-py-[10px] wpuf-px-[14px] wpuf-font-medium wpuf-w-1/3 wpuf-no-selectize">
                        <option v-for="option in rule_options" :value="option.value" :key="option.value">{{ option.label }}</option>
                    </select>',
                    '<span class="wpuf-ml-3">',
                    '</span>'
                );
                ?>
        </p>

        <div class="wpuf-conditional-logic-rules">
            <div v-for="(condition, index) in conditions" :key="condition.id" class="wpuf-conditional-rule wpuf-grid wpuf-grid-cols-4 wpuf-gap-4 wpuf-mb-4">
                <!-- Field Selection -->
                <div class="cond-field">
                    <select
                        v-model="condition.name"
                        :name="`wpuf_settings[submit_button_cond][conditions][${index}][name]`"
                        class="wpuf-w-full wpuf-py-2 wpuf-px-3 wpuf-border wpuf-border-gray-300 wpuf-rounded-md focus:wpuf-outline-none focus:wpuf-ring-2 focus:wpuf-ring-primary focus:wpuf-border-transparent wpuf-no-selectize">
                        <option value=""><?php esc_html_e( '- Select Field -', 'wpuf-pro' ); ?></option>
                        <option
                            v-for="field in conditional_fields"
                            :value="field.name"
                            :key="field.name">
                            {{ field.label }}
                        </option>
                    </select>
                </div>

                <!-- Operator Selection -->
                <div class="cond-operator">
                    <select
                        v-model="condition.operator"
                        :name="`wpuf_settings[submit_button_cond][conditions][${index}][operator]`"
                        class="wpuf-w-full wpuf-py-2 wpuf-px-3 wpuf-border wpuf-border-gray-300 wpuf-rounded-md focus:wpuf-outline-none focus:wpuf-ring-2 focus:wpuf-ring-primary focus:wpuf-border-transparent wpuf-no-selectize">
                        <option
                            v-for="operator in get_cond_operators(condition.name)"
                            :value="operator.value"
                            :key="operator.value">
                            {{ operator.label }}
                        </option>
                    </select>
                </div>

                <!-- Value Selection -->
                <div class="cond-option wpuf-relative">
                    <!-- Text Input -->
                    <input
                        v-if="show_textfield(condition.name)"
                        v-model="condition.option"
                        :name="`wpuf_settings[submit_button_cond][conditions][${index}][option]`"
                        type="text"
                        :disabled="is_disabled(condition.operator)"
                        class="wpuf-w-full wpuf-py-2 wpuf-px-3 wpuf-border wpuf-border-gray-300 wpuf-rounded-md focus:wpuf-outline-none focus:wpuf-ring-2 focus:wpuf-ring-primary focus:wpuf-border-transparent disabled:wpuf-bg-gray-100 disabled:wpuf-cursor-not-allowed">

                    <!-- Dropdown Selection -->
                    <select
                        v-if="show_dropdown(condition.name)"
                        v-model="condition.option"
                        :name="`wpuf_settings[submit_button_cond][conditions][${index}][option]`"
                        :disabled="is_disabled(condition.operator)"
                        class="wpuf-w-full wpuf-py-2 wpuf-px-3 wpuf-border wpuf-border-gray-300 wpuf-rounded-md focus:wpuf-outline-none focus:wpuf-ring-2 focus:wpuf-ring-primary focus:wpuf-border-transparent disabled:wpuf-bg-gray-100 disabled:wpuf-cursor-not-allowed wpuf-no-selectize">
                        <option value=""><?php esc_html_e( '- Select Option -', 'wpuf-pro' ); ?></option>
                        <option
                            v-for="option in get_cond_options(condition.name)"
                            :value="option.value"
                            :key="option.value">
                            {{ option.label }}
                        </option>
                    </select>
                </div>

                <!-- Action Buttons -->
                <div>
                    <button
                        type="button"
                        @click="add_condition"
                        class="wpuf-p-1 wpuf-text-green-600 hover:wpuf-text-green-800 focus:wpuf-outline-none"
                        title="<?php esc_attr_e( 'Add Condition', 'wpuf-pro' ); ?>">
                        <svg class="wpuf-w-5 wpuf-h-5" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-11a1 1 0 10-2 0v2H7a1 1 0 100 2h2v2a1 1 0 102 0v-2h2a1 1 0 100-2h-2V7z" clip-rule="evenodd"></path>
                        </svg>
                    </button>
                    <button
                        v-if="conditions.length > 1"
                        type="button"
                        @click="delete_condition(index)"
                        class="wpuf-p-1 wpuf-text-red-600 hover:wpuf-text-red-800 focus:wpuf-outline-none"
                        title="<?php esc_attr_e( 'Remove Condition', 'wpuf-pro' ); ?>">
                        <svg class="wpuf-w-5 wpuf-h-5" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM7 9a1 1 0 000 2h6a1 1 0 100-2H7z" clip-rule="evenodd"></path>
                        </svg>
                    </button>
                </div>
            </div>
        </div>

        <div class="description wpuf-text-sm wpuf-text-gray-600 wpuf-mt-2">
            <?php _e( 'Submit button will be shown/hidden based on the above conditions.', 'wpuf-pro' ); ?>
        </div>
        
        <!-- Hidden inputs for form submission when conditions are enabled -->
        <input type="hidden" name="wpuf_settings[submit_button_cond][condition_status]" :value="condition_status">
        <input type="hidden" name="wpuf_settings[submit_button_cond][cond_logic]" :value="cond_logic">
        <template v-for="(condition, index) in conditions">
            <input type="hidden" :name="`wpuf_settings[submit_button_cond][conditions][${index}][name]`" :value="condition.name">
            <input type="hidden" :name="`wpuf_settings[submit_button_cond][conditions][${index}][operator]`" :value="condition.operator">
            <input type="hidden" :name="`wpuf_settings[submit_button_cond][conditions][${index}][option]`" :value="condition.option">
            <input type="hidden" :name="`wpuf_settings[submit_button_cond][conditions][${index}][input_type]`" :value="condition.input_type">
        </template>
    </div>

    <!-- Hidden inputs for form submission when conditions are disabled -->
    <div v-else>
        <input type="hidden" name="wpuf_settings[submit_button_cond][condition_status]" :value="condition_status">
        <input type="hidden" name="wpuf_settings[submit_button_cond][cond_logic]" value="any">
        <input type="hidden" name="wpuf_settings[submit_button_cond][conditions][0][name]" value="">
        <input type="hidden" name="wpuf_settings[submit_button_cond][conditions][0][operator]" value="=">
        <input type="hidden" name="wpuf_settings[submit_button_cond][conditions][0][option]" value="">
        <input type="hidden" name="wpuf_settings[submit_button_cond][conditions][0][input_type]" value="">
    </div>
</div>
