;(function($) {
    'use strict';

    /**
     * Only proceed if current page is a 'Profile Forms' form builder page
     */
    if (!$('#wpuf-form-builder.wpuf-form-builder-profile').length) {
        return;
    }

    window.wpuf_forms_mixin_root = {
        data: function () {
            return {
                validation_error_msg: wpuf_form_builder.i18n.email_needed,
            };
        },

        methods: {
            // wpuf_profile must have 'user_email'
            // field template
            validate_form_before_submit: function () {
                var is_valid = false;

                _.each(this.form_fields, function (form_field) {
                    if (_.indexOf(['user_email'], form_field.template) >= 0) {
                        is_valid = true;
                        return;
                    }

                    // check in column field
                    if (form_field.template === 'column_field' ) {
                        var innerColumnFields = form_field.inner_fields;

                        for (const columnFields in innerColumnFields) {
                            if (innerColumnFields.hasOwnProperty(columnFields)) {
                                var columnFieldIndex = 0;

                                while (columnFieldIndex < innerColumnFields[columnFields].length) {
                                    if (_.indexOf(['user_email'], innerColumnFields[columnFields][columnFieldIndex].template) >= 0) {
                                        is_valid = true;
                                        return;
                                    }
                                    columnFieldIndex++;
                                }
                            }
                        }
                    }
                });

                return is_valid;
            }
        }
    };

    window.wpuf_forms_mixin_builder_stage = {
        data: function () {
            return {
                label_type: 'left',
                post_form_settings: {
                    submit_text: '',
                    draft_post: false
                }
            };
        },

        mounted: function () {
            var self = this;

            $('[name="wpuf_settings[label_position]"]').on('change', function () {
                self.label_type = $(this).val();
            });

            $('[name="wpuf_settings[label_position]"]').trigger('change');
        }
    };

    var SettingsTab = {
        init: function() {

            $('#wpuf-metabox-settings-registration').on('change', 'select[name="wpuf_settings[reg_redirect_to]"]', this.settingsRedirect);
            $('#wpuf-metabox-settings-update').on('change', 'select[name="wpuf_settings[edit_reg_redirect_to]"]', this.settingsRedirect);
            $('#wpuf-metabox-settings-profile').on('change', 'select[name="wpuf_settings[profile_redirect_to]"]', this.settingsRedirect);
            $('#wpuf-metabox-settings-update').on('change', 'select[name="wpuf_settings[edit_profile_redirect_to]"]', this.settingsRedirect);
            $('select[name="wpuf_settings[reg_redirect_to]"]').change();
            $('select[name="wpuf_settings[edit_reg_redirect_to]"]').change();
            $('select[name="wpuf_settings[profile_redirect_to]"]').change();
            $('select[name="wpuf_settings[edit_profile_redirect_to]"]').change();
        },


        settingsRedirect: function(e) {
            e.preventDefault();

            var $self = $(this),
                $table = $self.closest('table'),
                value = $self.val();

            switch( value ) {
                case 'post':
                    $table.find('tr.wpuf-page-id, tr.wpuf-url, tr.wpuf-same-page').hide();
                    break;

                case 'page':
                    $table.find('tr.wpuf-page-id').show();
                    $table.find('tr.wpuf-same-page').hide();
                    $table.find('tr.wpuf-url').hide();
                    break;

                case 'url':
                    $table.find('tr.wpuf-page-id').hide();
                    $table.find('tr.wpuf-same-page').hide();
                    $table.find('tr.wpuf-url').show();
                    break;

                case 'same':
                    $table.find('tr.wpuf-page-id').hide();
                    $table.find('tr.wpuf-url').hide();
                    $table.find('tr.wpuf-same-page').show();
                    break;
            }
        },

    };

    // on DOM ready
    $(function() {
        SettingsTab.init();

        // load only registration form settings related dependencies
        if (wpuf_form_builder.form_type === 'wpuf_profile') {
            const dependencies = {
                // Fields and their show/hide conditions
                fields: {
                    message: {
                        type: 'textarea',
                        dependsOn: [{
                            field: 'reg_redirect_to',
                            value: 'same'
                        }],
                    },
                    reg_page_id: {
                        type: 'select',
                        dependsOn: [{
                            field: 'reg_redirect_to',
                            value: 'page'
                        }],
                    },
                    registration_url: {
                        type: 'text',
                        dependsOn: [{
                            field: 'reg_redirect_to',
                            value: 'url'
                        }],
                    },
                    update_message: {
                        type: 'textarea',
                        dependsOn: [{
                            field: 'profile_redirect_to',
                            value: 'same'
                        }],
                    },
                    profile_page_id: {
                        type: 'select',
                        dependsOn: [{
                            field: 'profile_redirect_to',
                            value: 'page'
                        }],
                    },
                    profile_url: {
                        type: 'text',
                        dependsOn: [{
                            field: 'profile_redirect_to',
                            value: 'url'
                        }],
                    },
                    email_verification: {
                        type: 'radio',
                        dependsOn: [{
                            field: 'user_notification',
                            value: true
                        }],
                    },
                    verification_subject: {
                        type: 'text',
                        dependsOn: [
                            {
                                field: 'user_notification',
                                value: true
                            },
                            {
                                field: 'email_verification',
                                value: 'email_verification'
                            }
                        ],
                    },
                    ['wpuf_verification_body_' + wpuf_form_builder.post.ID]: {
                        type: 'rich-text',
                        dependsOn: [
                            {
                                field: 'user_notification',
                                value: true
                            },
                            {
                                field: 'email_verification',
                                value: 'email_verification'
                            }
                        ],
                    },
                    welcome_email_subject: {
                        type: 'text',
                        dependsOn: [
                            {
                                field: 'user_notification',
                                value: true
                            },
                            {
                                field: 'welcome_email',
                                value: 'welcome_email'
                            }
                        ],
                    },
                    ['wpuf_welcome_email_body_' + wpuf_form_builder.post.ID]: {
                        type: 'text',
                        dependsOn: [
                            {
                                field: 'user_notification',
                                value: true
                            },
                            {
                                field: 'welcome_email',
                                value: 'welcome_email'
                            }
                        ],
                    },
                    admin_email_subject: {
                        type: 'text',
                        dependsOn: [{
                            field: 'admin_notification',
                            value: true
                        }],
                    },
                    admin_email_body: {
                        type: 'textarea',
                        dependsOn: [{
                            field: 'admin_notification',
                            value: true
                        }],
                    },
                    multistep_progressbar_type: {
                        dependsOn: [{
                            field: 'enable_multistep',
                            value: true
                        }],
                    },
                    ms_ac_txt_color: {
                        dependsOn: [{
                            field: 'enable_multistep',
                            value: true
                        }],
                    },
                    ms_active_bgcolor: {
                        dependsOn: [{
                            field: 'enable_multistep',
                            value: true
                        }],
                    },
                    ms_bgcolor: {
                        dependsOn: [{
                            field: 'enable_multistep',
                            value: true
                        }],
                    }
                }
            };

            new window.FormDependencyHandler(dependencies);

            const user_status = '#wpuf-form-builder input#user_status';

            wpuf_toggle_user_status( user_status );

            $( user_status ).on( 'change', function () {
                wpuf_toggle_user_status( user_status );
            } );
        }
    });

    function wpuf_toggle_user_status( user_status ) {
        if ($( user_status ).is( ':checked' )) {
            $( '#wpuf-form-builder input#wpuf_user_status' ).val( 'pending' );
        } else {
            $( '#wpuf-form-builder input#wpuf_user_status' ).val( 'approved' );
        }
    }

})(jQuery);
