<?php

defined( 'ABSPATH' ) || exit;

return [
    'AF' => [ // Afghanistan states.
        'AF-BDS' => __( 'Badakhshan', 'wpuf-pro' ),
        'AF-BDG' => __( 'Badghis', 'wpuf-pro' ),
        'AF-BGL' => __( 'Baghlan', 'wpuf-pro' ),
        'AF-BAL' => __( 'Balkh', 'wpuf-pro' ),
        'AF-BAM' => __( 'Bamian', 'wpuf-pro' ),
        'AF-FRA' => __( 'Farah', 'wpuf-pro' ),
        'AF-FYB' => __( 'Faryab', 'wpuf-pro' ),
        'AF-GHA' => __( 'Ghazni', 'wpuf-pro' ),
        'AF-GHO' => __( 'Ghowr', 'wpuf-pro' ),
        'AF-HEL' => __( 'Helmand', 'wpuf-pro' ),
        'AF-HER' => __( 'Herat', 'wpuf-pro' ),
        'AF-JOW' => __( 'Jowzjan', 'wpuf-pro' ),
        'AF-KAB' => __( 'Kabol', 'wpuf-pro' ),
        'AF-KAN' => __( 'Kandahar', 'wpuf-pro' ),
        'AF-KAP' => __( 'Kapisa', 'wpuf-pro' ),
        'AF-KON' => __( 'Konar', 'wpuf-pro' ),
        'AF-KDZ' => __( 'Kondoz', 'wpuf-pro' ),
        'AF-LAG' => __( 'Laghman', 'wpuf-pro' ),
        'AF-LOW' => __( 'Lowgar', 'wpuf-pro' ),
        'AF-NAN' => __( 'Nangarhar', 'wpuf-pro' ),
        'AF-NIM' => __( 'Nimruz', 'wpuf-pro' ),
        'AF-ORU' => __( 'Oruzgan', 'wpuf-pro' ),
        'AF-PIA' => __( 'Paktia', 'wpuf-pro' ),
        'AF-PKA' => __( 'Paktika', 'wpuf-pro' ),
        'AF-PAR' => __( 'Parvan', 'wpuf-pro' ),
        'AF-SAM' => __( 'Samangan', 'wpuf-pro' ),
        'AF-SAR' => __( 'Sar-e Pol', 'wpuf-pro' ),
        'AF-TAK' => __( 'Takhar', 'wpuf-pro' ),
        'AF-VAR' => __( 'Vardak', 'wpuf-pro' ),
        'AF-ZAB' => __( 'Zabol', 'wpuf-pro' ),
    ],
    'AD' => [ // Andorra parishes.
        'AD-07' => __( 'Andorra la Vella', 'wpuf-pro' ),
        'AD-02' => __( 'Canillo', 'wpuf-pro' ),
        'AD-03' => __( 'Encamp', 'wpuf-pro' ),
        'AD-08' => __( 'Escaldes-Engordany', 'wpuf-pro' ),
        'AD-04' => __( 'La Massana', 'wpuf-pro' ),
        'AD-05' => __( 'Ordino', 'wpuf-pro' ),
        'AD-06' => __( 'Sant Julià de Lòria', 'wpuf-pro' ),
    ],
    'AM' => [ // Armenia provinces.
        'AM-AG' => __( 'Aragatsotn', 'wpuf-pro' ),
        'AM-AR' => __( 'Ararat', 'wpuf-pro' ),
        'AM-AV' => __( 'Armavir', 'wpuf-pro' ),
        'AM-GR' => __( 'Geghark\'unik\'', 'wpuf-pro' ),
        'AM-KT' => __( 'Kotayk\'', 'wpuf-pro' ),
        'AM-LO' => __( 'Lorri', 'wpuf-pro' ),
        'AM-SH' => __( 'Shirak', 'wpuf-pro' ),
        'AM-SU' => __( 'Syunik\'', 'wpuf-pro' ),
        'AM-TV' => __( 'Tavush', 'wpuf-pro' ),
        'AM-VD' => __( 'Vayots\' Dzor', 'wpuf-pro' ),
        'AM-ER' => __( 'Yerevan', 'wpuf-pro' ),
    ],
    'AO' => [ // Angola states.
        'BGO' => __( 'Bengo', 'wpuf-pro' ),
        'BLU' => __( 'Benguela', 'wpuf-pro' ),
        'BIE' => __( 'Bié', 'wpuf-pro' ),
        'CAB' => __( 'Cabinda', 'wpuf-pro' ),
        'CNN' => __( 'Cunene', 'wpuf-pro' ),
        'HUA' => __( 'Huambo', 'wpuf-pro' ),
        'HUI' => __( 'Huíla', 'wpuf-pro' ),
        'CCU' => __( 'Kuando Kubango', 'wpuf-pro' ),
        'CNO' => __( 'Kwanza-Norte', 'wpuf-pro' ),
        'CUS' => __( 'Kwanza-Sul', 'wpuf-pro' ),
        'LUA' => __( 'Luanda', 'wpuf-pro' ),
        'LNO' => __( 'Lunda-Norte', 'wpuf-pro' ),
        'LSU' => __( 'Lunda-Sul', 'wpuf-pro' ),
        'MAL' => __( 'Malanje', 'wpuf-pro' ),
        'MOX' => __( 'Moxico', 'wpuf-pro' ),
        'NAM' => __( 'Namibe', 'wpuf-pro' ),
        'UIG' => __( 'Uíge', 'wpuf-pro' ),
        'ZAI' => __( 'Zaire', 'wpuf-pro' ),
    ],
    'AR' => [ // Argentinian provinces.
        'C' => __( 'Ciudad Autónoma de Buenos Aires', 'wpuf-pro' ),
        'B' => __( 'Buenos Aires', 'wpuf-pro' ),
        'K' => __( 'Catamarca', 'wpuf-pro' ),
        'H' => __( 'Chaco', 'wpuf-pro' ),
        'U' => __( 'Chubut', 'wpuf-pro' ),
        'X' => __( 'Córdoba', 'wpuf-pro' ),
        'W' => __( 'Corrientes', 'wpuf-pro' ),
        'E' => __( 'Entre Ríos', 'wpuf-pro' ),
        'P' => __( 'Formosa', 'wpuf-pro' ),
        'Y' => __( 'Jujuy', 'wpuf-pro' ),
        'L' => __( 'La Pampa', 'wpuf-pro' ),
        'F' => __( 'La Rioja', 'wpuf-pro' ),
        'M' => __( 'Mendoza', 'wpuf-pro' ),
        'N' => __( 'Misiones', 'wpuf-pro' ),
        'Q' => __( 'Neuquén', 'wpuf-pro' ),
        'R' => __( 'Río Negro', 'wpuf-pro' ),
        'A' => __( 'Salta', 'wpuf-pro' ),
        'J' => __( 'San Juan', 'wpuf-pro' ),
        'D' => __( 'San Luis', 'wpuf-pro' ),
        'Z' => __( 'Santa Cruz', 'wpuf-pro' ),
        'S' => __( 'Santa Fe', 'wpuf-pro' ),
        'G' => __( 'Santiago del Estero', 'wpuf-pro' ),
        'V' => __( 'Tierra del Fuego', 'wpuf-pro' ),
        'T' => __( 'Tucumán', 'wpuf-pro' ),
    ],
    'AT' => [ // Austria states.
        'AT-1' => __( 'Burgenland', 'wpuf-pro' ),
        'AT-2' => __( 'Kärnten', 'wpuf-pro' ),
        'AT-3' => __( 'Niederösterreich', 'wpuf-pro' ),
        'AT-4' => __( 'Oberösterreich', 'wpuf-pro' ),
        'AT-5' => __( 'Salzburg', 'wpuf-pro' ),
        'AT-6' => __( 'Steiermark', 'wpuf-pro' ),
        'AT-7' => __( 'Tirol', 'wpuf-pro' ),
        'AT-8' => __( 'Vorarlberg', 'wpuf-pro' ),
        'AT-9' => __( 'Wien', 'wpuf-pro' ),
    ],
    'AU' => [ // Australian states.
        'ACT' => __( 'Australian Capital Territory', 'wpuf-pro' ),
        'NSW' => __( 'New South Wales', 'wpuf-pro' ),
        'NT'  => __( 'Northern Territory', 'wpuf-pro' ),
        'QLD' => __( 'Queensland', 'wpuf-pro' ),
        'SA'  => __( 'South Australia', 'wpuf-pro' ),
        'TAS' => __( 'Tasmania', 'wpuf-pro' ),
        'VIC' => __( 'Victoria', 'wpuf-pro' ),
        'WA'  => __( 'Western Australia', 'wpuf-pro' ),
    ],
    'AX' => [ // Aland Islands.
        'AX-AL' => __( 'Aland Islands', 'wpuf-pro' ),
    ],
    'BD' => [ // Bangladeshi states (districts).
        'BD-05' => __( 'Bagerhat', 'wpuf-pro' ),
        'BD-01' => __( 'Bandarban', 'wpuf-pro' ),
        'BD-02' => __( 'Barguna', 'wpuf-pro' ),
        'BD-06' => __( 'Barishal', 'wpuf-pro' ),
        'BD-07' => __( 'Bhola', 'wpuf-pro' ),
        'BD-03' => __( 'Bogura', 'wpuf-pro' ),
        'BD-04' => __( 'Brahmanbaria', 'wpuf-pro' ),
        'BD-09' => __( 'Chandpur', 'wpuf-pro' ),
        'BD-10' => __( 'Chattogram', 'wpuf-pro' ),
        'BD-12' => __( 'Chuadanga', 'wpuf-pro' ),
        'BD-11' => __( "Cox's Bazar", 'wpuf-pro' ),
        'BD-08' => __( 'Cumilla', 'wpuf-pro' ),
        'BD-13' => __( 'Dhaka', 'wpuf-pro' ),
        'BD-14' => __( 'Dinajpur', 'wpuf-pro' ),
        'BD-15' => __( 'Faridpur ', 'wpuf-pro' ),
        'BD-16' => __( 'Feni', 'wpuf-pro' ),
        'BD-19' => __( 'Gaibandha', 'wpuf-pro' ),
        'BD-18' => __( 'Gazipur', 'wpuf-pro' ),
        'BD-17' => __( 'Gopalganj', 'wpuf-pro' ),
        'BD-20' => __( 'Habiganj', 'wpuf-pro' ),
        'BD-21' => __( 'Jamalpur', 'wpuf-pro' ),
        'BD-22' => __( 'Jashore', 'wpuf-pro' ),
        'BD-25' => __( 'Jhalokati', 'wpuf-pro' ),
        'BD-23' => __( 'Jhenaidah', 'wpuf-pro' ),
        'BD-24' => __( 'Joypurhat', 'wpuf-pro' ),
        'BD-29' => __( 'Khagrachhari', 'wpuf-pro' ),
        'BD-27' => __( 'Khulna', 'wpuf-pro' ),
        'BD-26' => __( 'Kishoreganj', 'wpuf-pro' ),
        'BD-28' => __( 'Kurigram', 'wpuf-pro' ),
        'BD-30' => __( 'Kushtia', 'wpuf-pro' ),
        'BD-31' => __( 'Lakshmipur', 'wpuf-pro' ),
        'BD-32' => __( 'Lalmonirhat', 'wpuf-pro' ),
        'BD-36' => __( 'Madaripur', 'wpuf-pro' ),
        'BD-37' => __( 'Magura', 'wpuf-pro' ),
        'BD-33' => __( 'Manikganj ', 'wpuf-pro' ),
        'BD-39' => __( 'Meherpur', 'wpuf-pro' ),
        'BD-38' => __( 'Moulvibazar', 'wpuf-pro' ),
        'BD-35' => __( 'Munshiganj', 'wpuf-pro' ),
        'BD-34' => __( 'Mymensingh', 'wpuf-pro' ),
        'BD-48' => __( 'Naogaon', 'wpuf-pro' ),
        'BD-43' => __( 'Narail', 'wpuf-pro' ),
        'BD-40' => __( 'Narayanganj', 'wpuf-pro' ),
        'BD-42' => __( 'Narsingdi', 'wpuf-pro' ),
        'BD-44' => __( 'Natore', 'wpuf-pro' ),
        'BD-45' => __( 'Nawabganj', 'wpuf-pro' ),
        'BD-41' => __( 'Netrakona', 'wpuf-pro' ),
        'BD-46' => __( 'Nilphamari', 'wpuf-pro' ),
        'BD-47' => __( 'Noakhali', 'wpuf-pro' ),
        'BD-49' => __( 'Pabna', 'wpuf-pro' ),
        'BD-52' => __( 'Panchagarh', 'wpuf-pro' ),
        'BD-51' => __( 'Patuakhali', 'wpuf-pro' ),
        'BD-50' => __( 'Pirojpur', 'wpuf-pro' ),
        'BD-53' => __( 'Rajbari', 'wpuf-pro' ),
        'BD-54' => __( 'Rajshahi', 'wpuf-pro' ),
        'BD-56' => __( 'Rangamati', 'wpuf-pro' ),
        'BD-55' => __( 'Rangpur', 'wpuf-pro' ),
        'BD-58' => __( 'Satkhira', 'wpuf-pro' ),
        'BD-62' => __( 'Shariatpur', 'wpuf-pro' ),
        'BD-57' => __( 'Sherpur', 'wpuf-pro' ),
        'BD-59' => __( 'Sirajganj', 'wpuf-pro' ),
        'BD-61' => __( 'Sunamganj', 'wpuf-pro' ),
        'BD-60' => __( 'Sylhet', 'wpuf-pro' ),
        'BD-63' => __( 'Tangail', 'wpuf-pro' ),
        'BD-64' => __( 'Thakurgaon', 'wpuf-pro' ),
    ],
    'BE' => [ // Belgium provinces.
        'BE-VAN' => __( 'Antwerpen', 'wpuf-pro' ),
        'BE-WBR' => __( 'Brabant Wallon', 'wpuf-pro' ),
        'BE-BRU' => __( 'Brussels Capital Region', 'wpuf-pro' ),
        'BE-WHT' => __( 'Hainaut', 'wpuf-pro' ),
        'BE-WLG' => __( 'Liège', 'wpuf-pro' ),
        'BE-VLI' => __( 'Limburg', 'wpuf-pro' ),
        'BE-WLX' => __( 'Luxembourg', 'wpuf-pro' ),
        'BE-WNA' => __( 'Namur', 'wpuf-pro' ),
        'BE-VOV' => __( 'Oost-Vlaanderen', 'wpuf-pro' ),
        'BE-VBR' => __( 'Vlaams Brabant', 'wpuf-pro' ),
        'BE-VWV' => __( 'West-Vlaanderen', 'wpuf-pro' ),
    ],
    'BG' => [ // Bulgarian states.
        'BG-01' => __( 'Blagoevgrad', 'wpuf-pro' ),
        'BG-02' => __( 'Burgas', 'wpuf-pro' ),
        'BG-08' => __( 'Dobrich', 'wpuf-pro' ),
        'BG-07' => __( 'Gabrovo', 'wpuf-pro' ),
        'BG-26' => __( 'Haskovo', 'wpuf-pro' ),
        'BG-09' => __( 'Kardzhali', 'wpuf-pro' ),
        'BG-10' => __( 'Kyustendil', 'wpuf-pro' ),
        'BG-11' => __( 'Lovech', 'wpuf-pro' ),
        'BG-12' => __( 'Montana', 'wpuf-pro' ),
        'BG-13' => __( 'Pazardzhik', 'wpuf-pro' ),
        'BG-14' => __( 'Pernik', 'wpuf-pro' ),
        'BG-15' => __( 'Pleven', 'wpuf-pro' ),
        'BG-16' => __( 'Plovdiv', 'wpuf-pro' ),
        'BG-17' => __( 'Razgrad', 'wpuf-pro' ),
        'BG-18' => __( 'Ruse', 'wpuf-pro' ),
        'BG-27' => __( 'Shumen', 'wpuf-pro' ),
        'BG-19' => __( 'Silistra', 'wpuf-pro' ),
        'BG-20' => __( 'Sliven', 'wpuf-pro' ),
        'BG-21' => __( 'Smolyan', 'wpuf-pro' ),
        'BG-23' => __( 'Sofia', 'wpuf-pro' ),
        'BG-22' => __( 'Sofia-Grad', 'wpuf-pro' ),
        'BG-24' => __( 'Stara Zagora', 'wpuf-pro' ),
        'BG-25' => __( 'Targovishte', 'wpuf-pro' ),
        'BG-03' => __( 'Varna', 'wpuf-pro' ),
        'BG-04' => __( 'Veliko Tarnovo', 'wpuf-pro' ),
        'BG-05' => __( 'Vidin', 'wpuf-pro' ),
        'BG-06' => __( 'Vratsa', 'wpuf-pro' ),
        'BG-28' => __( 'Yambol', 'wpuf-pro' ),
    ],
    'BH' => [ // Bahrain districts.
        'BA' => __( 'Al Manamah', 'wpuf-pro' ),
        'JU' => __( 'Al Janubiyah', 'wpuf-pro' ),
        'HU' => __( 'Al Hidd', 'wpuf-pro' ),
        'JA' => __( 'Al Muharraq', 'wpuf-pro' ),
        'SA' => __( 'Al Shamaliyah', 'wpuf-pro' ),
    ],
    'BI' => [ // Burundi provinces.
        'BU' => __( 'Bujumbura Mairie', 'wpuf-pro' ),
        'BJ' => __( 'Bujumbura Rural', 'wpuf-pro' ),
        'BR' => __( 'Bururi', 'wpuf-pro' ),
        'CA' => __( 'Cibitoke', 'wpuf-pro' ),
        'GI' => __( 'Gitega', 'wpuf-pro' ),
        'KR' => __( 'Karuzi', 'wpuf-pro' ),
        'KI' => __( 'Kirundo', 'wpuf-pro' ),
        'MA' => __( 'Makamba', 'wpuf-pro' ),
        'MU' => __( 'Muramvya', 'wpuf-pro' ),
        'MW' => __( 'Mwaro', 'wpuf-pro' ),
        'NG' => __( 'Ngozi', 'wpuf-pro' ),
        'RT' => __( 'Rutana', 'wpuf-pro' ),
        'RY' => __( 'Ruyigi', 'wpuf-pro' ),
    ],
    'BJ' => [ // Benin states.
        'AL' => __( 'Alibori', 'wpuf-pro' ),
        'AK' => __( 'Atakora', 'wpuf-pro' ),
        'AQ' => __( 'Atlantique', 'wpuf-pro' ),
        'BO' => __( 'Borgou', 'wpuf-pro' ),
        'CO' => __( 'Collines', 'wpuf-pro' ),
        'KO' => __( 'Kouffo', 'wpuf-pro' ),
        'DO' => __( 'Donga', 'wpuf-pro' ),
        'LI' => __( 'Littoral', 'wpuf-pro' ),
        'MO' => __( 'Mono', 'wpuf-pro' ),
        'OU' => __( 'Ouémé', 'wpuf-pro' ),
        'PL' => __( 'Plateau', 'wpuf-pro' ),
        'ZO' => __( 'Zou', 'wpuf-pro' ),
    ],
    'BO' => [ // Bolivian states.
        'B' => __( 'Chuquisaca', 'wpuf-pro' ),
        'H' => __( 'Beni', 'wpuf-pro' ),
        'C' => __( 'Cochabamba', 'wpuf-pro' ),
        'L' => __( 'La Paz', 'wpuf-pro' ),
        'O' => __( 'Oruro', 'wpuf-pro' ),
        'N' => __( 'Pando', 'wpuf-pro' ),
        'P' => __( 'Potosí', 'wpuf-pro' ),
        'S' => __( 'Santa Cruz', 'wpuf-pro' ),
        'T' => __( 'Tarija', 'wpuf-pro' ),
    ],
    'BW' => [ // Botswana districts.
        'BW-CE' => __( 'Central', 'wpuf-pro' ),
        'BW-CH' => __( 'Chobe', 'wpuf-pro' ),
        'BW-FR' => __( 'Francistown', 'wpuf-pro' ),
        'BW-GA' => __( 'Gaborone', 'wpuf-pro' ),
        'BW-GH' => __( 'Ghanzi', 'wpuf-pro' ),
        'BW-KG' => __( 'Kgalagadi', 'wpuf-pro' ),
        'BW-KL' => __( 'Kgatleng', 'wpuf-pro' ),
        'BW-KW' => __( 'Kweneng', 'wpuf-pro' ),
        'BW-LO' => __( 'Lobatse', 'wpuf-pro' ),
        'BW-NG' => __( 'Ngamiland', 'wpuf-pro' ),
        'BW-NE' => __( 'North-East', 'wpuf-pro' ),
        'BW-SE' => __( 'Selebi-Pikwe', 'wpuf-pro' ),
        'BW-SO' => __( 'South-East', 'wpuf-pro' ),
        'BW-SU' => __( 'Southern', 'wpuf-pro' ),
    ],
    'BR' => [ // Brazillian states.
        'AC' => __( 'Acre', 'wpuf-pro' ),
        'AL' => __( 'Alagoas', 'wpuf-pro' ),
        'AP' => __( 'Amapá', 'wpuf-pro' ),
        'AM' => __( 'Amazonas', 'wpuf-pro' ),
        'BA' => __( 'Bahia', 'wpuf-pro' ),
        'CE' => __( 'Ceará', 'wpuf-pro' ),
        'DF' => __( 'Distrito Federal', 'wpuf-pro' ),
        'ES' => __( 'Espírito Santo', 'wpuf-pro' ),
        'GO' => __( 'Goiás', 'wpuf-pro' ),
        'MA' => __( 'Maranhão', 'wpuf-pro' ),
        'MT' => __( 'Mato Grosso', 'wpuf-pro' ),
        'MS' => __( 'Mato Grosso do Sul', 'wpuf-pro' ),
        'MG' => __( 'Minas Gerais', 'wpuf-pro' ),
        'PA' => __( 'Pará', 'wpuf-pro' ),
        'PB' => __( 'Paraíba', 'wpuf-pro' ),
        'PR' => __( 'Paraná', 'wpuf-pro' ),
        'PE' => __( 'Pernambuco', 'wpuf-pro' ),
        'PI' => __( 'Piauí', 'wpuf-pro' ),
        'RJ' => __( 'Rio de Janeiro', 'wpuf-pro' ),
        'RN' => __( 'Rio Grande do Norte', 'wpuf-pro' ),
        'RS' => __( 'Rio Grande do Sul', 'wpuf-pro' ),
        'RO' => __( 'Rondônia', 'wpuf-pro' ),
        'RR' => __( 'Roraima', 'wpuf-pro' ),
        'SC' => __( 'Santa Catarina', 'wpuf-pro' ),
        'SP' => __( 'São Paulo', 'wpuf-pro' ),
        'SE' => __( 'Sergipe', 'wpuf-pro' ),
        'TO' => __( 'Tocantins', 'wpuf-pro' ),
    ],
    'CA' => [ // Canadian states.
        'AB' => __( 'Alberta', 'wpuf-pro' ),
        'BC' => __( 'British Columbia', 'wpuf-pro' ),
        'MB' => __( 'Manitoba', 'wpuf-pro' ),
        'NB' => __( 'New Brunswick', 'wpuf-pro' ),
        'NL' => __( 'Newfoundland and Labrador', 'wpuf-pro' ),
        'NT' => __( 'Northwest Territories', 'wpuf-pro' ),
        'NS' => __( 'Nova Scotia', 'wpuf-pro' ),
        'NU' => __( 'Nunavut', 'wpuf-pro' ),
        'ON' => __( 'Ontario', 'wpuf-pro' ),
        'PE' => __( 'Prince Edward Island', 'wpuf-pro' ),
        'QC' => __( 'Quebec', 'wpuf-pro' ),
        'SK' => __( 'Saskatchewan', 'wpuf-pro' ),
        'YT' => __( 'Yukon Territory', 'wpuf-pro' ),
    ],
    'CH' => [ // Cantons of Switzerland.
        'AG' => __( 'Aargau', 'wpuf-pro' ),
        'AR' => __( 'Appenzell Ausserrhoden', 'wpuf-pro' ),
        'AI' => __( 'Appenzell Innerrhoden', 'wpuf-pro' ),
        'BL' => __( 'Basel-Landschaft', 'wpuf-pro' ),
        'BS' => __( 'Basel-Stadt', 'wpuf-pro' ),
        'BE' => __( 'Bern', 'wpuf-pro' ),
        'FR' => __( 'Fribourg', 'wpuf-pro' ),
        'GE' => __( 'Geneva', 'wpuf-pro' ),
        'GL' => __( 'Glarus', 'wpuf-pro' ),
        'GR' => __( 'Graubünden', 'wpuf-pro' ),
        'JU' => __( 'Jura', 'wpuf-pro' ),
        'LU' => __( 'Luzern', 'wpuf-pro' ),
        'NE' => __( 'Neuchâtel', 'wpuf-pro' ),
        'NW' => __( 'Nidwalden', 'wpuf-pro' ),
        'OW' => __( 'Obwalden', 'wpuf-pro' ),
        'SH' => __( 'Schaffhausen', 'wpuf-pro' ),
        'SZ' => __( 'Schwyz', 'wpuf-pro' ),
        'SO' => __( 'Solothurn', 'wpuf-pro' ),
        'SG' => __( 'St. Gallen', 'wpuf-pro' ),
        'TG' => __( 'Thurgau', 'wpuf-pro' ),
        'TI' => __( 'Ticino', 'wpuf-pro' ),
        'UR' => __( 'Uri', 'wpuf-pro' ),
        'VS' => __( 'Valais', 'wpuf-pro' ),
        'VD' => __( 'Vaud', 'wpuf-pro' ),
        'ZG' => __( 'Zug', 'wpuf-pro' ),
        'ZH' => __( 'Zürich', 'wpuf-pro' ),
    ],
    'CN' => [ // Chinese states.
        'CN1'  => __( 'Yunnan / 云南', 'wpuf-pro' ),
        'CN2'  => __( 'Beijing / 北京', 'wpuf-pro' ),
        'CN3'  => __( 'Tianjin / 天津', 'wpuf-pro' ),
        'CN4'  => __( 'Hebei / 河北', 'wpuf-pro' ),
        'CN5'  => __( 'Shanxi / 山西', 'wpuf-pro' ),
        'CN6'  => __( 'Inner Mongolia / 內蒙古', 'wpuf-pro' ),
        'CN7'  => __( 'Liaoning / 辽宁', 'wpuf-pro' ),
        'CN8'  => __( 'Jilin / 吉林', 'wpuf-pro' ),
        'CN9'  => __( 'Heilongjiang / 黑龙江', 'wpuf-pro' ),
        'CN10' => __( 'Shanghai / 上海', 'wpuf-pro' ),
        'CN11' => __( 'Jiangsu / 江苏', 'wpuf-pro' ),
        'CN12' => __( 'Zhejiang / 浙江', 'wpuf-pro' ),
        'CN13' => __( 'Anhui / 安徽', 'wpuf-pro' ),
        'CN14' => __( 'Fujian / 福建', 'wpuf-pro' ),
        'CN15' => __( 'Jiangxi / 江西', 'wpuf-pro' ),
        'CN16' => __( 'Shandong / 山东', 'wpuf-pro' ),
        'CN17' => __( 'Henan / 河南', 'wpuf-pro' ),
        'CN18' => __( 'Hubei / 湖北', 'wpuf-pro' ),
        'CN19' => __( 'Hunan / 湖南', 'wpuf-pro' ),
        'CN20' => __( 'Guangdong / 广东', 'wpuf-pro' ),
        'CN21' => __( 'Guangxi Zhuang / 广西壮族', 'wpuf-pro' ),
        'CN22' => __( 'Hainan / 海南', 'wpuf-pro' ),
        'CN23' => __( 'Chongqing / 重庆', 'wpuf-pro' ),
        'CN24' => __( 'Sichuan / 四川', 'wpuf-pro' ),
        'CN25' => __( 'Guizhou / 贵州', 'wpuf-pro' ),
        'CN26' => __( 'Shaanxi / 陕西', 'wpuf-pro' ),
        'CN27' => __( 'Gansu / 甘肃', 'wpuf-pro' ),
        'CN28' => __( 'Qinghai / 青海', 'wpuf-pro' ),
        'CN29' => __( 'Ningxia Hui / 宁夏', 'wpuf-pro' ),
        'CN30' => __( 'Macao / 澳门', 'wpuf-pro' ),
        'CN31' => __( 'Tibet / 西藏', 'wpuf-pro' ),
        'CN32' => __( 'Xinjiang / 新疆', 'wpuf-pro' ),
    ],
    'CZ' => [ // Czech districts.
        'CZ-PR' => __( 'Prague', 'wpuf-pro' ),
        'CZ-ST' => __( 'Středočeský kraj', 'wpuf-pro' ),
        'CZ-JC' => __( 'Jihočeský kraj', 'wpuf-pro' ),
        'CZ-PL' => __( 'Plzeňský kraj', 'wpuf-pro' ),
        'CZ-UL' => __( 'Ústecký kraj', 'wpuf-pro' ),
        'CZ-LI' => __( 'Liberecký kraj', 'wpuf-pro' ),
        'CZ-MO' => __( 'Moravskoslezský kraj', 'wpuf-pro' ),
        'CZ-OL' => __( 'Olomoucký kraj', 'wpuf-pro' ),
        'CZ-PA' => __( 'Pardubický kraj', 'wpuf-pro' ),
        'CZ-VY' => __( 'Vysočina', 'wpuf-pro' ),
        'CZ-ZL' => __( 'Zlínský kraj', 'wpuf-pro' ),
    ],
    'DE' => [ // German states.
        'DE-BW' => __( 'Baden-Württemberg', 'wpuf-pro' ),
        'DE-BY' => __( 'Bayern', 'wpuf-pro' ),
        'DE-BE' => __( 'Berlin', 'wpuf-pro' ),
        'DE-BB' => __( 'Brandenburg', 'wpuf-pro' ),
        'DE-HB' => __( 'Bremen', 'wpuf-pro' ),
        'DE-HH' => __( 'Hamburg', 'wpuf-pro' ),
        'DE-HE' => __( 'Hessen', 'wpuf-pro' ),
        'DE-MV' => __( 'Mecklenburg-Vorpommern', 'wpuf-pro' ),
        'DE-NI' => __( 'Niedersachsen', 'wpuf-pro' ),
        'DE-NW' => __( 'Nordrhein-Westfalen', 'wpuf-pro' ),
        'DE-RP' => __( 'Rheinland-Pfalz', 'wpuf-pro' ),
        'DE-SL' => __( 'Saarland', 'wpuf-pro' ),
        'DE-SH' => __( 'Schleswig-Holstein', 'wpuf-pro' ),
        'DE-ST' => __( 'Sachsen-Anhalt', 'wpuf-pro' ),
        'DE-SN' => __( 'Sachsen', 'wpuf-pro' ),
        'DE-TH' => __( 'Thüringen', 'wpuf-pro' ),
    ],
    'DZ' => [
        'DZ-01' => __( 'Adrar', 'wpuf-pro' ),
        'DZ-02' => __( 'Chlef', 'wpuf-pro' ),
        'DZ-03' => __( 'Laghouat', 'wpuf-pro' ),
        'DZ-04' => __( 'Oum El Bouaghi', 'wpuf-pro' ),
        'DZ-05' => __( 'Batna', 'wpuf-pro' ),
        'DZ-06' => __( 'Béjaïa', 'wpuf-pro' ),
        'DZ-07' => __( 'Biskra', 'wpuf-pro' ),
        'DZ-08' => __( 'Béchar', 'wpuf-pro' ),
        'DZ-09' => __( 'Blida', 'wpuf-pro' ),
        'DZ-10' => __( 'Bouira', 'wpuf-pro' ),
        'DZ-11' => __( 'Tamanghasset', 'wpuf-pro' ),
        'DZ-12' => __( 'Tébessa', 'wpuf-pro' ),
        'DZ-13' => __( 'Tlemcen', 'wpuf-pro' ),
        'DZ-14' => __( 'Tiaret', 'wpuf-pro' ),
        'DZ-15' => __( 'Tizi Ouzou', 'wpuf-pro' ),
        'DZ-16' => __( 'Algiers', 'wpuf-pro' ),
        'DZ-17' => __( 'Djelfa', 'wpuf-pro' ),
        'DZ-18' => __( 'Jijel', 'wpuf-pro' ),
        'DZ-19' => __( 'Sétif', 'wpuf-pro' ),
        'DZ-20' => __( 'Saïda', 'wpuf-pro' ),
        'DZ-21' => __( 'Skikda', 'wpuf-pro' ),
        'DZ-22' => __( 'Sidi Bel Abbès', 'wpuf-pro' ),
        'DZ-23' => __( 'Annaba', 'wpuf-pro' ),
        'DZ-24' => __( 'Guelma', 'wpuf-pro' ),
        'DZ-25' => __( 'Constantine', 'wpuf-pro' ),
        'DZ-26' => __( 'Médéa', 'wpuf-pro' ),
        'DZ-27' => __( 'Mostaganem', 'wpuf-pro' ),
        'DZ-28' => __( 'M’Sila', 'wpuf-pro' ),
        'DZ-29' => __( 'Mascara', 'wpuf-pro' ),
        'DZ-30' => __( 'Ouargla', 'wpuf-pro' ),
        'DZ-31' => __( 'Oran', 'wpuf-pro' ),
        'DZ-32' => __( 'El Bayadh', 'wpuf-pro' ),
        'DZ-33' => __( 'Illizi', 'wpuf-pro' ),
        'DZ-34' => __( 'Bordj Bou Arréridj', 'wpuf-pro' ),
        'DZ-35' => __( 'Boumerdès', 'wpuf-pro' ),
        'DZ-36' => __( 'El Tarf', 'wpuf-pro' ),
        'DZ-37' => __( 'Tindouf', 'wpuf-pro' ),
        'DZ-38' => __( 'Tissemsilt', 'wpuf-pro' ),
        'DZ-39' => __( 'El Oued', 'wpuf-pro' ),
        'DZ-40' => __( 'Khenchela', 'wpuf-pro' ),
        'DZ-41' => __( 'Souk Ahras', 'wpuf-pro' ),
        'DZ-42' => __( 'Tipasa', 'wpuf-pro' ),
        'DZ-43' => __( 'Mila', 'wpuf-pro' ),
        'DZ-44' => __( 'Aïn Defla', 'wpuf-pro' ),
        'DZ-45' => __( 'Naama', 'wpuf-pro' ),
        'DZ-46' => __( 'Aïn Témouchent', 'wpuf-pro' ),
        'DZ-47' => __( 'Ghardaïa', 'wpuf-pro' ),
        'DZ-48' => __( 'Relizane', 'wpuf-pro' ),
    ],
    'EE' => [ // Estonia counties.
        'EE-37' => __( 'Harjumaa (Tallinn)', 'wpuf-pro' ),
        'EE-39' => __( 'Hiiumaa (Kärdla)', 'wpuf-pro' ),
        'EE-44' => __( 'Ida-Virumaa (Jõhvi)', 'wpuf-pro' ),
        'EE-51' => __( 'Järvamaa (Paide)', 'wpuf-pro' ),
        'EE-49' => __( 'Jõgevamaa (Jõgeva)', 'wpuf-pro' ),
        'EE-59' => __( 'Lääne-Virumaa (Rakvere)', 'wpuf-pro' ),
        'EE-57' => __( 'Läänemaa (Haapsalu)', 'wpuf-pro' ),
        'EE-67' => __( 'Pärnumaa (Pärnu)', 'wpuf-pro' ),
        'EE-65' => __( 'Põlvamaa (Põlva)', 'wpuf-pro' ),
        'EE-70' => __( 'Raplamaa (Rapla)', 'wpuf-pro' ),
        'EE-74' => __( 'Saaremaa (Kuressaare)', 'wpuf-pro' ),
        'EE-78' => __( 'Tartumaa (Tartu)', 'wpuf-pro' ),
        'EE-82' => __( 'Valgamaa (Valga)', 'wpuf-pro' ),
        'EE-84' => __( 'Viljandimaa (Viljandi)', 'wpuf-pro' ),
        'EE-86' => __( 'Võrumaa (Võru)', 'wpuf-pro' ),
    ],
    'EG' => [ // Egypt states.
        'EGALX' => __( 'Alexandria', 'wpuf-pro' ),
        'EGASN' => __( 'Aswan', 'wpuf-pro' ),
        'EGAST' => __( 'Asyut', 'wpuf-pro' ),
        'EGBA'  => __( 'Red Sea', 'wpuf-pro' ),
        'EGBH'  => __( 'Beheira', 'wpuf-pro' ),
        'EGBNS' => __( 'Beni Suef', 'wpuf-pro' ),
        'EGC'   => __( 'Cairo', 'wpuf-pro' ),
        'EGDK'  => __( 'Dakahlia', 'wpuf-pro' ),
        'EGDT'  => __( 'Damietta', 'wpuf-pro' ),
        'EGFYM' => __( 'Faiyum', 'wpuf-pro' ),
        'EGGH'  => __( 'Gharbia', 'wpuf-pro' ),
        'EGGZ'  => __( 'Giza', 'wpuf-pro' ),
        'EGIS'  => __( 'Ismailia', 'wpuf-pro' ),
        'EGJS'  => __( 'South Sinai', 'wpuf-pro' ),
        'EGKB'  => __( 'Qalyubia', 'wpuf-pro' ),
        'EGKFS' => __( 'Kafr el-Sheikh', 'wpuf-pro' ),
        'EGKN'  => __( 'Qena', 'wpuf-pro' ),
        'EGLX'  => __( 'Luxor', 'wpuf-pro' ),
        'EGMN'  => __( 'Minya', 'wpuf-pro' ),
        'EGMNF' => __( 'Monufia', 'wpuf-pro' ),
        'EGMT'  => __( 'Matrouh', 'wpuf-pro' ),
        'EGPTS' => __( 'Port Said', 'wpuf-pro' ),
        'EGSHG' => __( 'Sohag', 'wpuf-pro' ),
        'EGSHR' => __( 'Al Sharqia', 'wpuf-pro' ),
        'EGSIN' => __( 'North Sinai', 'wpuf-pro' ),
        'EGSUZ' => __( 'Suez', 'wpuf-pro' ),
        'EGWAD' => __( 'New Valley', 'wpuf-pro' ),
    ],
    'ES' => [ // Spanish states.
        'C'  => __( 'A Coruña', 'wpuf-pro' ),
        'VI' => __( 'Araba/Álava', 'wpuf-pro' ),
        'AB' => __( 'Albacete', 'wpuf-pro' ),
        'A'  => __( 'Alicante', 'wpuf-pro' ),
        'AL' => __( 'Almería', 'wpuf-pro' ),
        'O'  => __( 'Asturias', 'wpuf-pro' ),
        'AV' => __( 'Ávila', 'wpuf-pro' ),
        'BA' => __( 'Badajoz', 'wpuf-pro' ),
        'PM' => __( 'Baleares', 'wpuf-pro' ),
        'B'  => __( 'Barcelona', 'wpuf-pro' ),
        'BU' => __( 'Burgos', 'wpuf-pro' ),
        'CC' => __( 'Cáceres', 'wpuf-pro' ),
        'CA' => __( 'Cádiz', 'wpuf-pro' ),
        'S'  => __( 'Cantabria', 'wpuf-pro' ),
        'CS' => __( 'Castellón', 'wpuf-pro' ),
        'CE' => __( 'Ceuta', 'wpuf-pro' ),
        'CR' => __( 'Ciudad Real', 'wpuf-pro' ),
        'CO' => __( 'Córdoba', 'wpuf-pro' ),
        'CU' => __( 'Cuenca', 'wpuf-pro' ),
        'GI' => __( 'Girona', 'wpuf-pro' ),
        'GR' => __( 'Granada', 'wpuf-pro' ),
        'GU' => __( 'Guadalajara', 'wpuf-pro' ),
        'SS' => __( 'Gipuzkoa', 'wpuf-pro' ),
        'H'  => __( 'Huelva', 'wpuf-pro' ),
        'HU' => __( 'Huesca', 'wpuf-pro' ),
        'J'  => __( 'Jaén', 'wpuf-pro' ),
        'LO' => __( 'La Rioja', 'wpuf-pro' ),
        'GC' => __( 'Las Palmas', 'wpuf-pro' ),
        'LE' => __( 'León', 'wpuf-pro' ),
        'L'  => __( 'Lleida', 'wpuf-pro' ),
        'LU' => __( 'Lugo', 'wpuf-pro' ),
        'M'  => __( 'Madrid', 'wpuf-pro' ),
        'MA' => __( 'Málaga', 'wpuf-pro' ),
        'ML' => __( 'Melilla', 'wpuf-pro' ),
        'MU' => __( 'Murcia', 'wpuf-pro' ),
        'NA' => __( 'Navarra', 'wpuf-pro' ),
        'OR' => __( 'Ourense', 'wpuf-pro' ),
        'P'  => __( 'Palencia', 'wpuf-pro' ),
        'PO' => __( 'Pontevedra', 'wpuf-pro' ),
        'SA' => __( 'Salamanca', 'wpuf-pro' ),
        'TF' => __( 'Santa Cruz de Tenerife', 'wpuf-pro' ),
        'SG' => __( 'Segovia', 'wpuf-pro' ),
        'SE' => __( 'Sevilla', 'wpuf-pro' ),
        'SO' => __( 'Soria', 'wpuf-pro' ),
        'T'  => __( 'Tarragona', 'wpuf-pro' ),
        'TE' => __( 'Teruel', 'wpuf-pro' ),
        'TO' => __( 'Toledo', 'wpuf-pro' ),
        'V'  => __( 'Valencia', 'wpuf-pro' ),
        'VA' => __( 'Valladolid', 'wpuf-pro' ),
        'BI' => __( 'Biscay', 'wpuf-pro' ),
        'ZA' => __( 'Zamora', 'wpuf-pro' ),
        'Z'  => __( 'Zaragoza', 'wpuf-pro' ),
    ],
    'FI' => [ // Finland regions.
        'FI-01' => __( 'Åland', 'wpuf-pro' ),
        'FI-02' => __( 'Etelä-Suomen Lääni', 'wpuf-pro' ),
        'FI-03' => __( 'Itä-Suomen Lääni', 'wpuf-pro' ),
        'FI-04' => __( 'Länsi-Suomen Lääni', 'wpuf-pro' ),
        'FI-05' => __( 'Lappi', 'wpuf-pro' ),
        'FI-06' => __( 'Oulun Lääni', 'wpuf-pro' ),
    ],
    'FR' => [ // France regions.
        'FR-ALS' => __( 'Alsace', 'wpuf-pro' ),
        'FR-AQU' => __( 'Aquitaine', 'wpuf-pro' ),
        'FR-AUV' => __( 'Auvergne', 'wpuf-pro' ),
        'FR-BNO' => __( 'Basse-Normandie', 'wpuf-pro' ),
        'FR-BOU' => __( 'Bourgogne', 'wpuf-pro' ),
        'FR-BRE' => __( 'Bretagne', 'wpuf-pro' ),
        'FR-CEN' => __( 'Centre', 'wpuf-pro' ),
        'FR-CHA' => __( 'Champagne-Ardenne', 'wpuf-pro' ),
        'FR-COR' => __( 'Corse', 'wpuf-pro' ),
        'FR-FCO' => __( 'Franche-Comté', 'wpuf-pro' ),
        'FR-HNO' => __( 'Haute-Normandie', 'wpuf-pro' ),
        'FR-IDF' => __( 'Île-de-France', 'wpuf-pro' ),
        'FR-LRO' => __( 'Languedoc-Roussillon', 'wpuf-pro' ),
        'FR-LIM' => __( 'Limousin', 'wpuf-pro' ),
        'FR-LOR' => __( 'Lorraine', 'wpuf-pro' ),
        'FR-MPY' => __( 'Midi-Pyrénées', 'wpuf-pro' ),
        'FR-NPC' => __( 'Nord-Pas-de-Calais', 'wpuf-pro' ),
        'FR-PDL' => __( 'Pays de la Loire', 'wpuf-pro' ),
        'FR-PIC' => __( 'Picardie', 'wpuf-pro' ),
        'FR-PCH' => __( 'Poitou-Charentes', 'wpuf-pro' ),
        'FR-PAC' => __( 'Provence-Alpes-Côte d\'Azur', 'wpuf-pro' ),
        'FR-RHA' => __( 'Rhône-Alpes', 'wpuf-pro' ),
    ],
    'GH' => [ // Ghanaian Regions.
        'AF' => __( 'Ahafo', 'wpuf-pro' ),
        'AH' => __( 'Ashanti', 'wpuf-pro' ),
        'BA' => __( 'Brong-Ahafo', 'wpuf-pro' ),
        'BO' => __( 'Bono', 'wpuf-pro' ),
        'BE' => __( 'Bono East', 'wpuf-pro' ),
        'CP' => __( 'Central', 'wpuf-pro' ),
        'EP' => __( 'Eastern', 'wpuf-pro' ),
        'AA' => __( 'Greater Accra', 'wpuf-pro' ),
        'NE' => __( 'North East', 'wpuf-pro' ),
        'NP' => __( 'Northern', 'wpuf-pro' ),
        'OT' => __( 'Oti', 'wpuf-pro' ),
        'SV' => __( 'Savannah', 'wpuf-pro' ),
        'UE' => __( 'Upper East', 'wpuf-pro' ),
        'UW' => __( 'Upper West', 'wpuf-pro' ),
        'TV' => __( 'Volta', 'wpuf-pro' ),
        'WP' => __( 'Western', 'wpuf-pro' ),
        'WN' => __( 'Western North', 'wpuf-pro' ),
    ],
    'GP' => [ // Guadeloupe districts.
        'GP-01' => __( 'Basse-Terre', 'wpuf-pro' ),
        'GP-02' => __( 'Grande-Terre', 'wpuf-pro' ),
        'GP-03' => __( 'Saint-Barthélemy', 'wpuf-pro' ),
        'GP-04' => __( 'Saint-Martin', 'wpuf-pro' ),
        'GP-05' => __( 'Saint-Pierre', 'wpuf-pro' ),
        'GP-06' => __( 'Saint-Barthelemy', 'wpuf-pro' ),
        'GP-07' => __( 'Saint-Martin', 'wpuf-pro' ),
        'GP-08' => __( 'Saint-Pierre', 'wpuf-pro' ),
        'GP-09' => __( 'Saint-Barthelemy', 'wpuf-pro' ),
        'GP-10' => __( 'Saint-Martin', 'wpuf-pro' ),
        'GP-11' => __( 'Saint-Pierre', 'wpuf-pro' ),
    ],
    'GR' => [ // Greek Regions.
        'I' => __( 'Attica', 'wpuf-pro' ),
        'A' => __( 'East Macedonia and Thrace', 'wpuf-pro' ),
        'B' => __( 'Central Macedonia', 'wpuf-pro' ),
        'C' => __( 'West Macedonia', 'wpuf-pro' ),
        'D' => __( 'Epirus', 'wpuf-pro' ),
        'E' => __( 'Thessaly', 'wpuf-pro' ),
        'F' => __( 'Ionian Islands', 'wpuf-pro' ),
        'G' => __( 'West Greece', 'wpuf-pro' ),
        'H' => __( 'Central Greece', 'wpuf-pro' ),
        'J' => __( 'Peloponnese', 'wpuf-pro' ),
        'K' => __( 'North Aegean', 'wpuf-pro' ),
        'L' => __( 'South Aegean', 'wpuf-pro' ),
        'M' => __( 'Crete', 'wpuf-pro' ),
    ],
    'GF' => [ // French Guiana districts.
        'GF-01' => __( 'Cayenne', 'wpuf-pro' ),
        'GF-02' => __( 'Saint-Laurent-du-Maroni', 'wpuf-pro' ),
        'GF-03' => __( 'Kourou', 'wpuf-pro' ),
    ],
    'HK' => [ // Hong Kong states.
        'HONG KONG'       => __( 'Hong Kong Island', 'wpuf-pro' ),
        'KOWLOON'         => __( 'Kowloon', 'wpuf-pro' ),
        'NEW TERRITORIES' => __( 'New Territories', 'wpuf-pro' ),
    ],
    'HU' => [ // Hungary states.
        'BK' => __( 'Bács-Kiskun', 'wpuf-pro' ),
        'BE' => __( 'Békés', 'wpuf-pro' ),
        'BA' => __( 'Baranya', 'wpuf-pro' ),
        'BZ' => __( 'Borsod-Abaúj-Zemplén', 'wpuf-pro' ),
        'BU' => __( 'Budapest', 'wpuf-pro' ),
        'CS' => __( 'Csongrád-Csanád', 'wpuf-pro' ),
        'FE' => __( 'Fejér', 'wpuf-pro' ),
        'GS' => __( 'Győr-Moson-Sopron', 'wpuf-pro' ),
        'HB' => __( 'Hajdú-Bihar', 'wpuf-pro' ),
        'HE' => __( 'Heves', 'wpuf-pro' ),
        'JN' => __( 'Jász-Nagykun-Szolnok', 'wpuf-pro' ),
        'KE' => __( 'Komárom-Esztergom', 'wpuf-pro' ),
        'NO' => __( 'Nógrád', 'wpuf-pro' ),
        'PE' => __( 'Pest', 'wpuf-pro' ),
        'SO' => __( 'Somogy', 'wpuf-pro' ),
        'SZ' => __( 'Szabolcs-Szatmár-Bereg', 'wpuf-pro' ),
        'TO' => __( 'Tolna', 'wpuf-pro' ),
        'VA' => __( 'Vas', 'wpuf-pro' ),
        'VE' => __( 'Veszprém', 'wpuf-pro' ),
        'ZA' => __( 'Zala', 'wpuf-pro' ),
    ],
    'ID' => [ // Indonesia Provinces.
        'AC' => __( 'Daerah Istimewa Aceh', 'wpuf-pro' ),
        'SU' => __( 'Sumatera Utara', 'wpuf-pro' ),
        'SB' => __( 'Sumatera Barat', 'wpuf-pro' ),
        'RI' => __( 'Riau', 'wpuf-pro' ),
        'KR' => __( 'Kepulauan Riau', 'wpuf-pro' ),
        'JA' => __( 'Jambi', 'wpuf-pro' ),
        'SS' => __( 'Sumatera Selatan', 'wpuf-pro' ),
        'BB' => __( 'Bangka Belitung', 'wpuf-pro' ),
        'BE' => __( 'Bengkulu', 'wpuf-pro' ),
        'LA' => __( 'Lampung', 'wpuf-pro' ),
        'JK' => __( 'DKI Jakarta', 'wpuf-pro' ),
        'JB' => __( 'Jawa Barat', 'wpuf-pro' ),
        'BT' => __( 'Banten', 'wpuf-pro' ),
        'JT' => __( 'Jawa Tengah', 'wpuf-pro' ),
        'JI' => __( 'Jawa Timur', 'wpuf-pro' ),
        'YO' => __( 'Daerah Istimewa Yogyakarta', 'wpuf-pro' ),
        'BA' => __( 'Bali', 'wpuf-pro' ),
        'NB' => __( 'Nusa Tenggara Barat', 'wpuf-pro' ),
        'NT' => __( 'Nusa Tenggara Timur', 'wpuf-pro' ),
        'KB' => __( 'Kalimantan Barat', 'wpuf-pro' ),
        'KT' => __( 'Kalimantan Tengah', 'wpuf-pro' ),
        'KI' => __( 'Kalimantan Timur', 'wpuf-pro' ),
        'KS' => __( 'Kalimantan Selatan', 'wpuf-pro' ),
        'KU' => __( 'Kalimantan Utara', 'wpuf-pro' ),
        'SA' => __( 'Sulawesi Utara', 'wpuf-pro' ),
        'ST' => __( 'Sulawesi Tengah', 'wpuf-pro' ),
        'SG' => __( 'Sulawesi Tenggara', 'wpuf-pro' ),
        'SR' => __( 'Sulawesi Barat', 'wpuf-pro' ),
        'SN' => __( 'Sulawesi Selatan', 'wpuf-pro' ),
        'GO' => __( 'Gorontalo', 'wpuf-pro' ),
        'MA' => __( 'Maluku', 'wpuf-pro' ),
        'MU' => __( 'Maluku Utara', 'wpuf-pro' ),
        'PA' => __( 'Papua', 'wpuf-pro' ),
        'PB' => __( 'Papua Barat', 'wpuf-pro' ),
    ],
    'IE' => [ // Republic of Ireland.
        'CW' => __( 'Carlow', 'wpuf-pro' ),
        'CN' => __( 'Cavan', 'wpuf-pro' ),
        'CE' => __( 'Clare', 'wpuf-pro' ),
        'CO' => __( 'Cork', 'wpuf-pro' ),
        'DL' => __( 'Donegal', 'wpuf-pro' ),
        'D'  => __( 'Dublin', 'wpuf-pro' ),
        'G'  => __( 'Galway', 'wpuf-pro' ),
        'KY' => __( 'Kerry', 'wpuf-pro' ),
        'KE' => __( 'Kildare', 'wpuf-pro' ),
        'KK' => __( 'Kilkenny', 'wpuf-pro' ),
        'LS' => __( 'Laois', 'wpuf-pro' ),
        'LM' => __( 'Leitrim', 'wpuf-pro' ),
        'LK' => __( 'Limerick', 'wpuf-pro' ),
        'LD' => __( 'Longford', 'wpuf-pro' ),
        'LH' => __( 'Louth', 'wpuf-pro' ),
        'MO' => __( 'Mayo', 'wpuf-pro' ),
        'MH' => __( 'Meath', 'wpuf-pro' ),
        'MN' => __( 'Monaghan', 'wpuf-pro' ),
        'OY' => __( 'Offaly', 'wpuf-pro' ),
        'RN' => __( 'Roscommon', 'wpuf-pro' ),
        'SO' => __( 'Sligo', 'wpuf-pro' ),
        'TA' => __( 'Tipperary', 'wpuf-pro' ),
        'WD' => __( 'Waterford', 'wpuf-pro' ),
        'WH' => __( 'Westmeath', 'wpuf-pro' ),
        'WX' => __( 'Wexford', 'wpuf-pro' ),
        'WW' => __( 'Wicklow', 'wpuf-pro' ),
    ],
    'IN' => [ // Indian states.
        'AP' => __( 'Andhra Pradesh', 'wpuf-pro' ),
        'AR' => __( 'Arunachal Pradesh', 'wpuf-pro' ),
        'AS' => __( 'Assam', 'wpuf-pro' ),
        'BR' => __( 'Bihar', 'wpuf-pro' ),
        'CT' => __( 'Chhattisgarh', 'wpuf-pro' ),
        'GA' => __( 'Goa', 'wpuf-pro' ),
        'GJ' => __( 'Gujarat', 'wpuf-pro' ),
        'HR' => __( 'Haryana', 'wpuf-pro' ),
        'HP' => __( 'Himachal Pradesh', 'wpuf-pro' ),
        'JK' => __( 'Jammu and Kashmir', 'wpuf-pro' ),
        'JH' => __( 'Jharkhand', 'wpuf-pro' ),
        'KA' => __( 'Karnataka', 'wpuf-pro' ),
        'KL' => __( 'Kerala', 'wpuf-pro' ),
        'MP' => __( 'Madhya Pradesh', 'wpuf-pro' ),
        'MH' => __( 'Maharashtra', 'wpuf-pro' ),
        'MN' => __( 'Manipur', 'wpuf-pro' ),
        'ML' => __( 'Meghalaya', 'wpuf-pro' ),
        'MZ' => __( 'Mizoram', 'wpuf-pro' ),
        'NL' => __( 'Nagaland', 'wpuf-pro' ),
        'OR' => __( 'Orissa', 'wpuf-pro' ),
        'PB' => __( 'Punjab', 'wpuf-pro' ),
        'RJ' => __( 'Rajasthan', 'wpuf-pro' ),
        'SK' => __( 'Sikkim', 'wpuf-pro' ),
        'TN' => __( 'Tamil Nadu', 'wpuf-pro' ),
        'TS' => __( 'Telangana', 'wpuf-pro' ),
        'TR' => __( 'Tripura', 'wpuf-pro' ),
        'UK' => __( 'Uttarakhand', 'wpuf-pro' ),
        'UP' => __( 'Uttar Pradesh', 'wpuf-pro' ),
        'WB' => __( 'West Bengal', 'wpuf-pro' ),
        'AN' => __( 'Andaman and Nicobar Islands', 'wpuf-pro' ),
        'CH' => __( 'Chandigarh', 'wpuf-pro' ),
        'DN' => __( 'Dadra and Nagar Haveli', 'wpuf-pro' ),
        'DD' => __( 'Daman and Diu', 'wpuf-pro' ),
        'DL' => __( 'Delhi', 'wpuf-pro' ),
        'LD' => __( 'Lakshadeep', 'wpuf-pro' ),
        'PY' => __( 'Pondicherry (Puducherry)', 'wpuf-pro' ),
    ],
    'IR' => [ // Iran States.
        'KHZ' => __( 'Khuzestan  (خوزستان)', 'wpuf-pro' ),
        'THR' => __( 'Tehran  (تهران)', 'wpuf-pro' ),
        'ILM' => __( 'Ilaam (ایلام)', 'wpuf-pro' ),
        'BHR' => __( 'Bushehr (بوشهر)', 'wpuf-pro' ),
        'ADL' => __( 'Ardabil (اردبیل)', 'wpuf-pro' ),
        'ESF' => __( 'Isfahan (اصفهان)', 'wpuf-pro' ),
        'YZD' => __( 'Yazd (یزد)', 'wpuf-pro' ),
        'KRH' => __( 'Kermanshah (کرمانشاه)', 'wpuf-pro' ),
        'KRN' => __( 'Kerman (کرمان)', 'wpuf-pro' ),
        'HDN' => __( 'Hamadan (همدان)', 'wpuf-pro' ),
        'GZN' => __( 'Ghazvin (قزوین)', 'wpuf-pro' ),
        'ZJN' => __( 'Zanjan (زنجان)', 'wpuf-pro' ),
        'LRS' => __( 'Luristan (لرستان)', 'wpuf-pro' ),
        'ABZ' => __( 'Alborz (البرز)', 'wpuf-pro' ),
        'EAZ' => __( 'East Azarbaijan (آذربایجان شرقی)', 'wpuf-pro' ),
        'WAZ' => __( 'West Azarbaijan (آذربایجان غربی)', 'wpuf-pro' ),
        'CHB' => __( 'Chaharmahal and Bakhtiari (چهارمحال و بختیاری)', 'wpuf-pro' ),
        'SKH' => __( 'South Khorasan (خراسان جنوبی)', 'wpuf-pro' ),
        'RKH' => __( 'Razavi Khorasan (خراسان رضوی)', 'wpuf-pro' ),
        'NKH' => __( 'North Khorasan (خراسان شمالی)', 'wpuf-pro' ),
        'SMN' => __( 'Semnan (سمنان)', 'wpuf-pro' ),
        'FRS' => __( 'Fars (فارس)', 'wpuf-pro' ),
        'QHM' => __( 'Qom (قم)', 'wpuf-pro' ),
        'KRD' => __( 'Kurdistan / کردستان)', 'wpuf-pro' ),
        'KBD' => __( 'Kohgiluyeh and BoyerAhmad (کهگیلوییه و بویراحمد)', 'wpuf-pro' ),
        'GLS' => __( 'Golestan (گلستان)', 'wpuf-pro' ),
        'GIL' => __( 'Gilan (گیلان)', 'wpuf-pro' ),
        'MZN' => __( 'Mazandaran (مازندران)', 'wpuf-pro' ),
        'MKZ' => __( 'Markazi (مرکزی)', 'wpuf-pro' ),
        'HRZ' => __( 'Hormozgan (هرمزگان)', 'wpuf-pro' ),
        'SBN' => __( 'Sistan and Baluchestan (سیستان و بلوچستان)', 'wpuf-pro' ),
    ],
    'IS' => [ // Icelandic counties.
        'IS-01' => __( 'Höfuðborgarsvæði', 'wpuf-pro' ),
        'IS-02' => __( 'Suðurnes', 'wpuf-pro' ),
        'IS-03' => __( 'Vesturland', 'wpuf-pro' ),
        'IS-04' => __( 'Vesturland', 'wpuf-pro' ),
        'IS-05' => __( 'Vesturland', 'wpuf-pro' ),
    ],
    'IT' => [ // Italy Provinces.
        'AG' => __( 'Agrigento', 'wpuf-pro' ),
        'AL' => __( 'Alessandria', 'wpuf-pro' ),
        'AN' => __( 'Ancona', 'wpuf-pro' ),
        'AO' => __( 'Aosta', 'wpuf-pro' ),
        'AR' => __( 'Arezzo', 'wpuf-pro' ),
        'AP' => __( 'Ascoli Piceno', 'wpuf-pro' ),
        'AT' => __( 'Asti', 'wpuf-pro' ),
        'AV' => __( 'Avellino', 'wpuf-pro' ),
        'BA' => __( 'Bari', 'wpuf-pro' ),
        'BT' => __( 'Barletta-Andria-Trani', 'wpuf-pro' ),
        'BL' => __( 'Belluno', 'wpuf-pro' ),
        'BN' => __( 'Benevento', 'wpuf-pro' ),
        'BG' => __( 'Bergamo', 'wpuf-pro' ),
        'BI' => __( 'Biella', 'wpuf-pro' ),
        'BO' => __( 'Bologna', 'wpuf-pro' ),
        'BZ' => __( 'Bolzano', 'wpuf-pro' ),
        'BS' => __( 'Brescia', 'wpuf-pro' ),
        'BR' => __( 'Brindisi', 'wpuf-pro' ),
        'CA' => __( 'Cagliari', 'wpuf-pro' ),
        'CL' => __( 'Caltanissetta', 'wpuf-pro' ),
        'CB' => __( 'Campobasso', 'wpuf-pro' ),
        'CE' => __( 'Caserta', 'wpuf-pro' ),
        'CT' => __( 'Catania', 'wpuf-pro' ),
        'CZ' => __( 'Catanzaro', 'wpuf-pro' ),
        'CH' => __( 'Chieti', 'wpuf-pro' ),
        'CO' => __( 'Como', 'wpuf-pro' ),
        'CS' => __( 'Cosenza', 'wpuf-pro' ),
        'CR' => __( 'Cremona', 'wpuf-pro' ),
        'KR' => __( 'Crotone', 'wpuf-pro' ),
        'CN' => __( 'Cuneo', 'wpuf-pro' ),
        'EN' => __( 'Enna', 'wpuf-pro' ),
        'FM' => __( 'Fermo', 'wpuf-pro' ),
        'FE' => __( 'Ferrara', 'wpuf-pro' ),
        'FI' => __( 'Firenze', 'wpuf-pro' ),
        'FG' => __( 'Foggia', 'wpuf-pro' ),
        'FC' => __( 'Forlì-Cesena', 'wpuf-pro' ),
        'FR' => __( 'Frosinone', 'wpuf-pro' ),
        'GE' => __( 'Genova', 'wpuf-pro' ),
        'GO' => __( 'Gorizia', 'wpuf-pro' ),
        'GR' => __( 'Grosseto', 'wpuf-pro' ),
        'IM' => __( 'Imperia', 'wpuf-pro' ),
        'IS' => __( 'Isernia', 'wpuf-pro' ),
        'SP' => __( 'La Spezia', 'wpuf-pro' ),
        'AQ' => __( "L'Aquila", 'wpuf-pro' ),
        'LT' => __( 'Latina', 'wpuf-pro' ),
        'LE' => __( 'Lecce', 'wpuf-pro' ),
        'LC' => __( 'Lecco', 'wpuf-pro' ),
        'LI' => __( 'Livorno', 'wpuf-pro' ),
        'LO' => __( 'Lodi', 'wpuf-pro' ),
        'LU' => __( 'Lucca', 'wpuf-pro' ),
        'MC' => __( 'Macerata', 'wpuf-pro' ),
        'MN' => __( 'Mantova', 'wpuf-pro' ),
        'MS' => __( 'Massa-Carrara', 'wpuf-pro' ),
        'MT' => __( 'Matera', 'wpuf-pro' ),
        'ME' => __( 'Messina', 'wpuf-pro' ),
        'MI' => __( 'Milano', 'wpuf-pro' ),
        'MO' => __( 'Modena', 'wpuf-pro' ),
        'MB' => __( 'Monza e della Brianza', 'wpuf-pro' ),
        'NA' => __( 'Napoli', 'wpuf-pro' ),
        'NO' => __( 'Novara', 'wpuf-pro' ),
        'NU' => __( 'Nuoro', 'wpuf-pro' ),
        'OR' => __( 'Oristano', 'wpuf-pro' ),
        'PD' => __( 'Padova', 'wpuf-pro' ),
        'PA' => __( 'Palermo', 'wpuf-pro' ),
        'PR' => __( 'Parma', 'wpuf-pro' ),
        'PV' => __( 'Pavia', 'wpuf-pro' ),
        'PG' => __( 'Perugia', 'wpuf-pro' ),
        'PU' => __( 'Pesaro e Urbino', 'wpuf-pro' ),
        'PE' => __( 'Pescara', 'wpuf-pro' ),
        'PC' => __( 'Piacenza', 'wpuf-pro' ),
        'PI' => __( 'Pisa', 'wpuf-pro' ),
        'PT' => __( 'Pistoia', 'wpuf-pro' ),
        'PN' => __( 'Pordenone', 'wpuf-pro' ),
        'PZ' => __( 'Potenza', 'wpuf-pro' ),
        'PO' => __( 'Prato', 'wpuf-pro' ),
        'RG' => __( 'Ragusa', 'wpuf-pro' ),
        'RA' => __( 'Ravenna', 'wpuf-pro' ),
        'RC' => __( 'Reggio Calabria', 'wpuf-pro' ),
        'RE' => __( 'Reggio Emilia', 'wpuf-pro' ),
        'RI' => __( 'Rieti', 'wpuf-pro' ),
        'RN' => __( 'Rimini', 'wpuf-pro' ),
        'RM' => __( 'Roma', 'wpuf-pro' ),
        'RO' => __( 'Rovigo', 'wpuf-pro' ),
        'SA' => __( 'Salerno', 'wpuf-pro' ),
        'SS' => __( 'Sassari', 'wpuf-pro' ),
        'SV' => __( 'Savona', 'wpuf-pro' ),
        'SI' => __( 'Siena', 'wpuf-pro' ),
        'SR' => __( 'Siracusa', 'wpuf-pro' ),
        'SO' => __( 'Sondrio', 'wpuf-pro' ),
        'SU' => __( 'Sud Sardegna', 'wpuf-pro' ),
        'TA' => __( 'Taranto', 'wpuf-pro' ),
        'TE' => __( 'Teramo', 'wpuf-pro' ),
        'TR' => __( 'Terni', 'wpuf-pro' ),
        'TO' => __( 'Torino', 'wpuf-pro' ),
        'TP' => __( 'Trapani', 'wpuf-pro' ),
        'TN' => __( 'Trento', 'wpuf-pro' ),
        'TV' => __( 'Treviso', 'wpuf-pro' ),
        'TS' => __( 'Trieste', 'wpuf-pro' ),
        'UD' => __( 'Udine', 'wpuf-pro' ),
        'VA' => __( 'Varese', 'wpuf-pro' ),
        'VE' => __( 'Venezia', 'wpuf-pro' ),
        'VB' => __( 'Verbano-Cusio-Ossola', 'wpuf-pro' ),
        'VC' => __( 'Vercelli', 'wpuf-pro' ),
        'VR' => __( 'Verona', 'wpuf-pro' ),
        'VV' => __( 'Vibo Valentia', 'wpuf-pro' ),
        'VI' => __( 'Vicenza', 'wpuf-pro' ),
        'VT' => __( 'Viterbo', 'wpuf-pro' ),
    ],
    'IL' => [ // Israel districts.
        'IL-01' => __( 'Tel Aviv', 'wpuf-pro' ),
        'IL-02' => __( 'Jerusalem', 'wpuf-pro' ),
        'IL-03' => __( 'Haifa', 'wpuf-pro' ),
        'IL-04' => __( 'Rishon LeZion', 'wpuf-pro' ),
        'IL-05' => __( 'Beer Sheva', 'wpuf-pro' ),
    ],
    'IM' => [ // Isle of Man districts.
        'IM-01' => __( 'Douglas', 'wpuf-pro' ),
        'IM-02' => __( 'Isle of Man', 'wpuf-pro' ),
        'IM-03' => __( 'Onchan', 'wpuf-pro' ),
        'IM-04' => __( 'Peel', 'wpuf-pro' ),
        'IM-05' => __( 'Port Erin', 'wpuf-pro' ),
    ],
    'JM' => [ // Jamaica's Parishes. Ref: https://en.wikipedia.org/wiki/ISO_3166-2:JM.
        'JM-01' => __( 'Kingston', 'wpuf-pro' ),
        'JM-02' => __( 'Saint Andrew', 'wpuf-pro' ),
        'JM-03' => __( 'Saint Thomas', 'wpuf-pro' ),
        'JM-04' => __( 'Portland', 'wpuf-pro' ),
        'JM-05' => __( 'Saint Mary', 'wpuf-pro' ),
        'JM-06' => __( 'Saint Ann', 'wpuf-pro' ),
        'JM-07' => __( 'Trelawny', 'wpuf-pro' ),
        'JM-08' => __( 'Saint James', 'wpuf-pro' ),
        'JM-09' => __( 'Hanover', 'wpuf-pro' ),
        'JM-10' => __( 'Westmoreland', 'wpuf-pro' ),
        'JM-11' => __( 'Saint Elizabeth', 'wpuf-pro' ),
        'JM-12' => __( 'Manchester', 'wpuf-pro' ),
        'JM-13' => __( 'Clarendon', 'wpuf-pro' ),
        'JM-14' => __( 'Saint Catherine', 'wpuf-pro' ),
    ],

    /**
     * Japan States.
     *
     * English notation of prefectures conform to the notation of Japan Post.
     * The suffix corresponds with the Japanese translation file.
     */
    'JP' => [
        'JP01' => __( 'Hokkaido', 'wpuf-pro' ),
        'JP02' => __( 'Aomori', 'wpuf-pro' ),
        'JP03' => __( 'Iwate', 'wpuf-pro' ),
        'JP04' => __( 'Miyagi', 'wpuf-pro' ),
        'JP05' => __( 'Akita', 'wpuf-pro' ),
        'JP06' => __( 'Yamagata', 'wpuf-pro' ),
        'JP07' => __( 'Fukushima', 'wpuf-pro' ),
        'JP08' => __( 'Ibaraki', 'wpuf-pro' ),
        'JP09' => __( 'Tochigi', 'wpuf-pro' ),
        'JP10' => __( 'Gunma', 'wpuf-pro' ),
        'JP11' => __( 'Saitama', 'wpuf-pro' ),
        'JP12' => __( 'Chiba', 'wpuf-pro' ),
        'JP13' => __( 'Tokyo', 'wpuf-pro' ),
        'JP14' => __( 'Kanagawa', 'wpuf-pro' ),
        'JP15' => __( 'Niigata', 'wpuf-pro' ),
        'JP16' => __( 'Toyama', 'wpuf-pro' ),
        'JP17' => __( 'Ishikawa', 'wpuf-pro' ),
        'JP18' => __( 'Fukui', 'wpuf-pro' ),
        'JP19' => __( 'Yamanashi', 'wpuf-pro' ),
        'JP20' => __( 'Nagano', 'wpuf-pro' ),
        'JP21' => __( 'Gifu', 'wpuf-pro' ),
        'JP22' => __( 'Shizuoka', 'wpuf-pro' ),
        'JP23' => __( 'Aichi', 'wpuf-pro' ),
        'JP24' => __( 'Mie', 'wpuf-pro' ),
        'JP25' => __( 'Shiga', 'wpuf-pro' ),
        'JP26' => __( 'Kyoto', 'wpuf-pro' ),
        'JP27' => __( 'Osaka', 'wpuf-pro' ),
        'JP28' => __( 'Hyogo', 'wpuf-pro' ),
        'JP29' => __( 'Nara', 'wpuf-pro' ),
        'JP30' => __( 'Wakayama', 'wpuf-pro' ),
        'JP31' => __( 'Tottori', 'wpuf-pro' ),
        'JP32' => __( 'Shimane', 'wpuf-pro' ),
        'JP33' => __( 'Okayama', 'wpuf-pro' ),
        'JP34' => __( 'Hiroshima', 'wpuf-pro' ),
        'JP35' => __( 'Yamaguchi', 'wpuf-pro' ),
        'JP36' => __( 'Tokushima', 'wpuf-pro' ),
        'JP37' => __( 'Kagawa', 'wpuf-pro' ),
        'JP38' => __( 'Ehime', 'wpuf-pro' ),
        'JP39' => __( 'Kochi', 'wpuf-pro' ),
        'JP40' => __( 'Fukuoka', 'wpuf-pro' ),
        'JP41' => __( 'Saga', 'wpuf-pro' ),
        'JP42' => __( 'Nagasaki', 'wpuf-pro' ),
        'JP43' => __( 'Kumamoto', 'wpuf-pro' ),
        'JP44' => __( 'Oita', 'wpuf-pro' ),
        'JP45' => __( 'Miyazaki', 'wpuf-pro' ),
        'JP46' => __( 'Kagoshima', 'wpuf-pro' ),
        'JP47' => __( 'Okinawa', 'wpuf-pro' ),
    ],
    'KE' => [ // Kenya counties.
        'KE01' => __( 'Baringo', 'wpuf-pro' ),
        'KE02' => __( 'Bomet', 'wpuf-pro' ),
        'KE03' => __( 'Bungoma', 'wpuf-pro' ),
        'KE04' => __( 'Busia', 'wpuf-pro' ),
        'KE05' => __( 'Elgeyo-Marakwet', 'wpuf-pro' ),
        'KE06' => __( 'Embu', 'wpuf-pro' ),
        'KE07' => __( 'Garissa', 'wpuf-pro' ),
        'KE08' => __( 'Homa Bay', 'wpuf-pro' ),
        'KE09' => __( 'Isiolo', 'wpuf-pro' ),
        'KE10' => __( 'Kajiado', 'wpuf-pro' ),
        'KE11' => __( 'Kakamega', 'wpuf-pro' ),
        'KE12' => __( 'Kericho', 'wpuf-pro' ),
        'KE13' => __( 'Kiambu', 'wpuf-pro' ),
        'KE14' => __( 'Kilifi', 'wpuf-pro' ),
        'KE15' => __( 'Kirinyaga', 'wpuf-pro' ),
        'KE16' => __( 'Kisii', 'wpuf-pro' ),
        'KE17' => __( 'Kisumu', 'wpuf-pro' ),
        'KE18' => __( 'Kitui', 'wpuf-pro' ),
        'KE19' => __( 'Kwale', 'wpuf-pro' ),
        'KE20' => __( 'Laikipia', 'wpuf-pro' ),
        'KE21' => __( 'Lamu', 'wpuf-pro' ),
        'KE22' => __( 'Machakos', 'wpuf-pro' ),
        'KE23' => __( 'Makueni', 'wpuf-pro' ),
        'KE24' => __( 'Mandera', 'wpuf-pro' ),
        'KE25' => __( 'Marsabit', 'wpuf-pro' ),
        'KE26' => __( 'Meru', 'wpuf-pro' ),
        'KE27' => __( 'Migori', 'wpuf-pro' ),
        'KE28' => __( 'Mombasa', 'wpuf-pro' ),
        'KE29' => __( 'Murang’a', 'wpuf-pro' ),
        'KE30' => __( 'Nairobi County', 'wpuf-pro' ),
        'KE31' => __( 'Nakuru', 'wpuf-pro' ),
        'KE32' => __( 'Nandi', 'wpuf-pro' ),
        'KE33' => __( 'Narok', 'wpuf-pro' ),
        'KE34' => __( 'Nyamira', 'wpuf-pro' ),
        'KE35' => __( 'Nyandarua', 'wpuf-pro' ),
        'KE36' => __( 'Nyeri', 'wpuf-pro' ),
        'KE37' => __( 'Samburu', 'wpuf-pro' ),
        'KE38' => __( 'Siaya', 'wpuf-pro' ),
        'KE39' => __( 'Taita-Taveta', 'wpuf-pro' ),
        'KE40' => __( 'Tana River', 'wpuf-pro' ),
        'KE41' => __( 'Tharaka-Nithi', 'wpuf-pro' ),
        'KE42' => __( 'Trans Nzoia', 'wpuf-pro' ),
        'KE43' => __( 'Turkana', 'wpuf-pro' ),
        'KE44' => __( 'Uasin Gishu', 'wpuf-pro' ),
        'KE45' => __( 'Vihiga', 'wpuf-pro' ),
        'KE46' => __( 'Wajir', 'wpuf-pro' ),
        'KE47' => __( 'West Pokot', 'wpuf-pro' ),
    ],
    'KR' => [ // South Korea provinces.
        'KR-01' => __( 'Seoul', 'wpuf-pro' ),
        'KR-02' => __( 'Busan', 'wpuf-pro' ),
        'KR-03' => __( 'Daegu', 'wpuf-pro' ),
        'KR-04' => __( 'Incheon', 'wpuf-pro' ),
        'KR-05' => __( 'Gwangju', 'wpuf-pro' ),
        'KR-06' => __( 'Daejeon', 'wpuf-pro' ),
        'KR-07' => __( 'Ulsan', 'wpuf-pro' ),
        'KR-08' => __( 'Gyeonggi', 'wpuf-pro' ),
        'KR-09' => __( 'Gangwon', 'wpuf-pro' ),
        'KR-10' => __( 'Chungcheongbuk', 'wpuf-pro' ),
        'KR-11' => __( 'Chungcheongnam', 'wpuf-pro' ),
        'KR-12' => __( 'Jeollabuk', 'wpuf-pro' ),
        'KR-13' => __( 'Jeollanam', 'wpuf-pro' ),
        'KR-14' => __( 'Gyeongsangbuk', 'wpuf-pro' ),
        'KR-15' => __( 'Gyeongsangnam', 'wpuf-pro' ),
        'KR-16' => __( 'Jeju', 'wpuf-pro' ),
    ],
    'KW' => [ // Kuwait governorates.
        'KU' => __( 'Al Farwaniyah', 'wpuf-pro' ),
        'AH' => __( 'Al Ahmadi', 'wpuf-pro' ),
        'FA' => __( 'Al Farwaniyah', 'wpuf-pro' ),
        'JA' => __( 'Al Jahra', 'wpuf-pro' ),
        'MU' => __( 'Mubarak Al-Kabeer', 'wpuf-pro' ),
        'NU' => __( 'Al Jahra', 'wpuf-pro' ),
        'SA' => __( 'Al Farwaniyah', 'wpuf-pro' ),
        'WA' => __( 'Al Farwaniyah', 'wpuf-pro' ),
    ],
    'LA' => [
        'AT' => __( 'Attapeu', 'wpuf-pro' ),
        'BK' => __( 'Bokeo', 'wpuf-pro' ),
        'BL' => __( 'Bolikhamsai', 'wpuf-pro' ),
        'CH' => __( 'Champasak', 'wpuf-pro' ),
        'HO' => __( 'Houaphanh', 'wpuf-pro' ),
        'KH' => __( 'Khammouane', 'wpuf-pro' ),
        'LM' => __( 'Luang Namtha', 'wpuf-pro' ),
        'LP' => __( 'Luang Prabang', 'wpuf-pro' ),
        'OU' => __( 'Oudomxay', 'wpuf-pro' ),
        'PH' => __( 'Phongsaly', 'wpuf-pro' ),
        'SL' => __( 'Salavan', 'wpuf-pro' ),
        'SV' => __( 'Savannakhet', 'wpuf-pro' ),
        'VI' => __( 'Vientiane Province', 'wpuf-pro' ),
        'VT' => __( 'Vientiane', 'wpuf-pro' ),
        'XA' => __( 'Sainyabuli', 'wpuf-pro' ),
        'XE' => __( 'Sekong', 'wpuf-pro' ),
        'XI' => __( 'Xiangkhouang', 'wpuf-pro' ),
        'XS' => __( 'Xaisomboun', 'wpuf-pro' ),
    ],
    'LB' => [ // Lebanon districts.
        'BA' => __( 'Baalbek-Hermel', 'wpuf-pro' ),
        'BI' => __( 'Beirut', 'wpuf-pro' ),
        'JA' => __( 'Jbeil', 'wpuf-pro' ),
        'NA' => __( 'Nabatiye', 'wpuf-pro' ),
    ],
    'LR' => [ // Liberia provinces.
        'BM' => __( 'Bomi', 'wpuf-pro' ),
        'BN' => __( 'Bong', 'wpuf-pro' ),
        'GA' => __( 'Gbarpolu', 'wpuf-pro' ),
        'GB' => __( 'Grand Bassa', 'wpuf-pro' ),
        'GC' => __( 'Grand Cape Mount', 'wpuf-pro' ),
        'GG' => __( 'Grand Gedeh', 'wpuf-pro' ),
        'GK' => __( 'Grand Kru', 'wpuf-pro' ),
        'LO' => __( 'Lofa', 'wpuf-pro' ),
        'MA' => __( 'Margibi', 'wpuf-pro' ),
        'MY' => __( 'Maryland', 'wpuf-pro' ),
        'MO' => __( 'Montserrado', 'wpuf-pro' ),
        'NM' => __( 'Nimba', 'wpuf-pro' ),
        'RV' => __( 'Rivercess', 'wpuf-pro' ),
        'RG' => __( 'River Gee', 'wpuf-pro' ),
        'SN' => __( 'Sinoe', 'wpuf-pro' ),
    ],
    'LU' => [ // Luxembourg districts.
        'D' => __( 'Diekirch', 'wpuf-pro' ),
        'G' => __( 'Grevenmacher', 'wpuf-pro' ),
        'L' => __( 'Luxembourg', 'wpuf-pro' ),
        'M' => __( 'Mersch', 'wpuf-pro' ),
        'R' => __( 'Redange', 'wpuf-pro' ),
        'V' => __( 'Vianden', 'wpuf-pro' ),
        'W' => __( 'Wiltz', 'wpuf-pro' ),
    ],
    'MD' => [ // Moldova states.
        'C'  => __( 'Chișinău', 'wpuf-pro' ),
        'BL' => __( 'Bălți', 'wpuf-pro' ),
        'AN' => __( 'Anenii Noi', 'wpuf-pro' ),
        'BS' => __( 'Basarabeasca', 'wpuf-pro' ),
        'BR' => __( 'Briceni', 'wpuf-pro' ),
        'CH' => __( 'Cahul', 'wpuf-pro' ),
        'CT' => __( 'Cantemir', 'wpuf-pro' ),
        'CL' => __( 'Călărași', 'wpuf-pro' ),
        'CS' => __( 'Căușeni', 'wpuf-pro' ),
        'CM' => __( 'Cimișlia', 'wpuf-pro' ),
        'CR' => __( 'Criuleni', 'wpuf-pro' ),
        'DN' => __( 'Dondușeni', 'wpuf-pro' ),
        'DR' => __( 'Drochia', 'wpuf-pro' ),
        'DB' => __( 'Dubăsari', 'wpuf-pro' ),
        'ED' => __( 'Edineț', 'wpuf-pro' ),
        'FL' => __( 'Fălești', 'wpuf-pro' ),
        'FR' => __( 'Florești', 'wpuf-pro' ),
        'GE' => __( 'UTA Găgăuzia', 'wpuf-pro' ),
        'GL' => __( 'Glodeni', 'wpuf-pro' ),
        'HN' => __( 'Hîncești', 'wpuf-pro' ),
        'IL' => __( 'Ialoveni', 'wpuf-pro' ),
        'LV' => __( 'Leova', 'wpuf-pro' ),
        'NS' => __( 'Nisporeni', 'wpuf-pro' ),
        'OC' => __( 'Ocnița', 'wpuf-pro' ),
        'OR' => __( 'Orhei', 'wpuf-pro' ),
        'RZ' => __( 'Rezina', 'wpuf-pro' ),
        'RS' => __( 'Rîșcani', 'wpuf-pro' ),
        'SG' => __( 'Sîngerei', 'wpuf-pro' ),
        'SR' => __( 'Soroca', 'wpuf-pro' ),
        'ST' => __( 'Strășeni', 'wpuf-pro' ),
        'SD' => __( 'Șoldănești', 'wpuf-pro' ),
        'SV' => __( 'Ștefan Vodă', 'wpuf-pro' ),
        'TR' => __( 'Taraclia', 'wpuf-pro' ),
        'TL' => __( 'Telenești', 'wpuf-pro' ),
        'UN' => __( 'Ungheni', 'wpuf-pro' ),
    ],
    'MQ' => [ // Martinique districts.
        'MQ-01' => __( 'Basse-Terre', 'wpuf-pro' ),
        'MQ-02' => __( 'Grande-Terre', 'wpuf-pro' ),
        'MQ-03' => __( 'Saint-Barthélemy', 'wpuf-pro' ),
        'MQ-04' => __( 'Saint-Martin', 'wpuf-pro' ),
        'MQ-05' => __( 'Saint-Pierre', 'wpuf-pro' ),
        'MQ-06' => __( 'Saint-Barthelemy', 'wpuf-pro' ),
        'MQ-07' => __( 'Saint-Martin', 'wpuf-pro' ),
        'MQ-08' => __( 'Saint-Pierre', 'wpuf-pro' ),
    ],
    'MT' => [ // Malta districts.
        'MT-01' => __( 'Attard', 'wpuf-pro' ),
        'MT-02' => __( 'Balzan', 'wpuf-pro' ),
        'MT-03' => __( 'Birżebbuġa', 'wpuf-pro' ),
        'MT-04' => __( 'Birkirkara', 'wpuf-pro' ),
    ],
    'MX' => [ // Mexico States.
        'DF' => __( 'Ciudad de México', 'wpuf-pro' ),
        'JA' => __( 'Jalisco', 'wpuf-pro' ),
        'NL' => __( 'Nuevo León', 'wpuf-pro' ),
        'AG' => __( 'Aguascalientes', 'wpuf-pro' ),
        'BC' => __( 'Baja California', 'wpuf-pro' ),
        'BS' => __( 'Baja California Sur', 'wpuf-pro' ),
        'CM' => __( 'Campeche', 'wpuf-pro' ),
        'CS' => __( 'Chiapas', 'wpuf-pro' ),
        'CH' => __( 'Chihuahua', 'wpuf-pro' ),
        'CO' => __( 'Coahuila', 'wpuf-pro' ),
        'CL' => __( 'Colima', 'wpuf-pro' ),
        'DG' => __( 'Durango', 'wpuf-pro' ),
        'GT' => __( 'Guanajuato', 'wpuf-pro' ),
        'GR' => __( 'Guerrero', 'wpuf-pro' ),
        'HG' => __( 'Hidalgo', 'wpuf-pro' ),
        'MX' => __( 'Estado de México', 'wpuf-pro' ),
        'MI' => __( 'Michoacán', 'wpuf-pro' ),
        'MO' => __( 'Morelos', 'wpuf-pro' ),
        'NA' => __( 'Nayarit', 'wpuf-pro' ),
        'OA' => __( 'Oaxaca', 'wpuf-pro' ),
        'PU' => __( 'Puebla', 'wpuf-pro' ),
        'QT' => __( 'Querétaro', 'wpuf-pro' ),
        'QR' => __( 'Quintana Roo', 'wpuf-pro' ),
        'SL' => __( 'San Luis Potosí', 'wpuf-pro' ),
        'SI' => __( 'Sinaloa', 'wpuf-pro' ),
        'SO' => __( 'Sonora', 'wpuf-pro' ),
        'TB' => __( 'Tabasco', 'wpuf-pro' ),
        'TM' => __( 'Tamaulipas', 'wpuf-pro' ),
        'TL' => __( 'Tlaxcala', 'wpuf-pro' ),
        'VE' => __( 'Veracruz', 'wpuf-pro' ),
        'YU' => __( 'Yucatán', 'wpuf-pro' ),
        'ZA' => __( 'Zacatecas', 'wpuf-pro' ),
    ],
    'MY' => [ // Malaysian states.
        'JHR' => __( 'Johor', 'wpuf-pro' ),
        'KDH' => __( 'Kedah', 'wpuf-pro' ),
        'KTN' => __( 'Kelantan', 'wpuf-pro' ),
        'LBN' => __( 'Labuan', 'wpuf-pro' ),
        'MLK' => __( 'Malacca (Melaka)', 'wpuf-pro' ),
        'NSN' => __( 'Negeri Sembilan', 'wpuf-pro' ),
        'PHG' => __( 'Pahang', 'wpuf-pro' ),
        'PNG' => __( 'Penang (Pulau Pinang)', 'wpuf-pro' ),
        'PRK' => __( 'Perak', 'wpuf-pro' ),
        'PLS' => __( 'Perlis', 'wpuf-pro' ),
        'SBH' => __( 'Sabah', 'wpuf-pro' ),
        'SWK' => __( 'Sarawak', 'wpuf-pro' ),
        'SGR' => __( 'Selangor', 'wpuf-pro' ),
        'TRG' => __( 'Terengganu', 'wpuf-pro' ),
        'PJY' => __( 'Putrajaya', 'wpuf-pro' ),
        'KUL' => __( 'Kuala Lumpur', 'wpuf-pro' ),
    ],
    'MZ' => [ // Mozambique provinces.
        'MZP'   => __( 'Cabo Delgado', 'wpuf-pro' ),
        'MZG'   => __( 'Gaza', 'wpuf-pro' ),
        'MZI'   => __( 'Inhambane', 'wpuf-pro' ),
        'MZB'   => __( 'Manica', 'wpuf-pro' ),
        'MZL'   => __( 'Maputo Province', 'wpuf-pro' ),
        'MZMPM' => __( 'Maputo', 'wpuf-pro' ),
        'MZN'   => __( 'Nampula', 'wpuf-pro' ),
        'MZA'   => __( 'Niassa', 'wpuf-pro' ),
        'MZS'   => __( 'Sofala', 'wpuf-pro' ),
        'MZT'   => __( 'Tete', 'wpuf-pro' ),
        'MZQ'   => __( 'Zambézia', 'wpuf-pro' ),
    ],
    'NA' => [ // Namibia regions.
        'ER' => __( 'Erongo', 'wpuf-pro' ),
        'HA' => __( 'Hardap', 'wpuf-pro' ),
        'KA' => __( 'Karas', 'wpuf-pro' ),
        'KE' => __( 'Kavango East', 'wpuf-pro' ),
        'KW' => __( 'Kavango West', 'wpuf-pro' ),
        'KH' => __( 'Khomas', 'wpuf-pro' ),
        'KU' => __( 'Kunene', 'wpuf-pro' ),
        'OW' => __( 'Ohangwena', 'wpuf-pro' ),
        'OH' => __( 'Omaheke', 'wpuf-pro' ),
        'OS' => __( 'Omusati', 'wpuf-pro' ),
        'ON' => __( 'Oshana', 'wpuf-pro' ),
        'OT' => __( 'Oshikoto', 'wpuf-pro' ),
        'OD' => __( 'Otjozondjupa', 'wpuf-pro' ),
        'CA' => __( 'Zambezi', 'wpuf-pro' ),
    ],
    'NG' => [ // Nigerian provinces.
        'AB' => __( 'Abia', 'wpuf-pro' ),
        'FC' => __( 'Abuja', 'wpuf-pro' ),
        'AD' => __( 'Adamawa', 'wpuf-pro' ),
        'AK' => __( 'Akwa Ibom', 'wpuf-pro' ),
        'AN' => __( 'Anambra', 'wpuf-pro' ),
        'BA' => __( 'Bauchi', 'wpuf-pro' ),
        'BY' => __( 'Bayelsa', 'wpuf-pro' ),
        'BE' => __( 'Benue', 'wpuf-pro' ),
        'BO' => __( 'Borno', 'wpuf-pro' ),
        'CR' => __( 'Cross River', 'wpuf-pro' ),
        'DE' => __( 'Delta', 'wpuf-pro' ),
        'EB' => __( 'Ebonyi', 'wpuf-pro' ),
        'ED' => __( 'Edo', 'wpuf-pro' ),
        'EK' => __( 'Ekiti', 'wpuf-pro' ),
        'EN' => __( 'Enugu', 'wpuf-pro' ),
        'GO' => __( 'Gombe', 'wpuf-pro' ),
        'IM' => __( 'Imo', 'wpuf-pro' ),
        'JI' => __( 'Jigawa', 'wpuf-pro' ),
        'KD' => __( 'Kaduna', 'wpuf-pro' ),
        'KN' => __( 'Kano', 'wpuf-pro' ),
        'KT' => __( 'Katsina', 'wpuf-pro' ),
        'KE' => __( 'Kebbi', 'wpuf-pro' ),
        'KO' => __( 'Kogi', 'wpuf-pro' ),
        'KW' => __( 'Kwara', 'wpuf-pro' ),
        'LA' => __( 'Lagos', 'wpuf-pro' ),
        'NA' => __( 'Nasarawa', 'wpuf-pro' ),
        'NI' => __( 'Niger', 'wpuf-pro' ),
        'OG' => __( 'Ogun', 'wpuf-pro' ),
        'ON' => __( 'Ondo', 'wpuf-pro' ),
        'OS' => __( 'Osun', 'wpuf-pro' ),
        'OY' => __( 'Oyo', 'wpuf-pro' ),
        'PL' => __( 'Plateau', 'wpuf-pro' ),
        'RI' => __( 'Rivers', 'wpuf-pro' ),
        'SO' => __( 'Sokoto', 'wpuf-pro' ),
        'TA' => __( 'Taraba', 'wpuf-pro' ),
        'YO' => __( 'Yobe', 'wpuf-pro' ),
        'ZA' => __( 'Zamfara', 'wpuf-pro' ),
    ],
    'NL' => [ // Netherlands provinces.
        'NL-DR' => __( 'Drenthe', 'wpuf-pro' ),
        'NL-FL' => __( 'Flevoland', 'wpuf-pro' ),
        'NL-FR' => __( 'Friesland', 'wpuf-pro' ),
        'NL-GE' => __( 'Gelderland', 'wpuf-pro' ),
        'NL-GR' => __( 'Groningen', 'wpuf-pro' ),
        'NL-LI' => __( 'Limburg', 'wpuf-pro' ),
        'NL-NB' => __( 'Noord-Brabant', 'wpuf-pro' ),
        'NL-NH' => __( 'Noord-Holland', 'wpuf-pro' ),
        'NL-OV' => __( 'Overijssel', 'wpuf-pro' ),
        'NL-UT' => __( 'Utrecht', 'wpuf-pro' ),
        'NL-ZE' => __( 'Zeeland', 'wpuf-pro' ),
        'NL-ZH' => __( 'Zuid-Holland', 'wpuf-pro' ),
    ],
    'NO' => [ // Norway counties.
        'NO-02' => __( 'Akershus', 'wpuf-pro' ),
        'NO-09' => __( 'Aust-Agder', 'wpuf-pro' ),
        'NO-06' => __( 'Buskerud', 'wpuf-pro' ),
        'NO-20' => __( 'Finnmark', 'wpuf-pro' ),
        'NO-04' => __( 'Hedmark', 'wpuf-pro' ),
        'NO-12' => __( 'Hordaland', 'wpuf-pro' ),
        'NO-15' => __( 'Møre og Romsdal', 'wpuf-pro' ),
        'NO-17' => __( 'Nord-Trøndelag', 'wpuf-pro' ),
        'NO-18' => __( 'Nordland', 'wpuf-pro' ),
        'NO-05' => __( 'Oppland', 'wpuf-pro' ),
        'NO-03' => __( 'Oslo', 'wpuf-pro' ),
        'NO-01' => __( 'Østfold', 'wpuf-pro' ),
        'NO-11' => __( 'Rogaland', 'wpuf-pro' ),
        'NO-14' => __( 'Sogn og Fjordane', 'wpuf-pro' ),
        'NO-16' => __( 'Sør-Trøndelag', 'wpuf-pro' ),
        'NO-08' => __( 'Telemark', 'wpuf-pro' ),
        'NO-19' => __( 'Troms', 'wpuf-pro' ),
        'NO-10' => __( 'Vest-Agder', 'wpuf-pro' ),
        'NO-07' => __( 'Vestfold', 'wpuf-pro' ),
    ],
    'NP' => [ // Nepal states (Zones).
        'BAG' => __( 'Bagmati', 'wpuf-pro' ),
        'BHE' => __( 'Bheri', 'wpuf-pro' ),
        'DHA' => __( 'Dhaulagiri', 'wpuf-pro' ),
        'GAN' => __( 'Gandaki', 'wpuf-pro' ),
        'JAN' => __( 'Janakpur', 'wpuf-pro' ),
        'KAR' => __( 'Karnali', 'wpuf-pro' ),
        'KOS' => __( 'Koshi', 'wpuf-pro' ),
        'LUM' => __( 'Lumbini', 'wpuf-pro' ),
        'MAH' => __( 'Mahakali', 'wpuf-pro' ),
        'MEC' => __( 'Mechi', 'wpuf-pro' ),
        'NAR' => __( 'Narayani', 'wpuf-pro' ),
        'RAP' => __( 'Rapti', 'wpuf-pro' ),
        'SAG' => __( 'Sagarmatha', 'wpuf-pro' ),
        'SET' => __( 'Seti', 'wpuf-pro' ),
    ],
    'NZ' => [ // New Zealand States.
        'NL' => __( 'Northland', 'wpuf-pro' ),
        'AK' => __( 'Auckland', 'wpuf-pro' ),
        'WA' => __( 'Waikato', 'wpuf-pro' ),
        'BP' => __( 'Bay of Plenty', 'wpuf-pro' ),
        'TK' => __( 'Taranaki', 'wpuf-pro' ),
        'GI' => __( 'Gisborne', 'wpuf-pro' ),
        'HB' => __( 'Hawke’s Bay', 'wpuf-pro' ),
        'MW' => __( 'Manawatu-Wanganui', 'wpuf-pro' ),
        'WE' => __( 'Wellington', 'wpuf-pro' ),
        'NS' => __( 'Nelson', 'wpuf-pro' ),
        'MB' => __( 'Marlborough', 'wpuf-pro' ),
        'TM' => __( 'Tasman', 'wpuf-pro' ),
        'WC' => __( 'West Coast', 'wpuf-pro' ),
        'CT' => __( 'Canterbury', 'wpuf-pro' ),
        'OT' => __( 'Otago', 'wpuf-pro' ),
        'SL' => __( 'Southland', 'wpuf-pro' ),
    ],
    'PE' => [ // Peru states.
        'CAL' => __( 'El Callao', 'wpuf-pro' ),
        'LMA' => __( 'Municipalidad Metropolitana de Lima', 'wpuf-pro' ),
        'AMA' => __( 'Amazonas', 'wpuf-pro' ),
        'ANC' => __( 'Ancash', 'wpuf-pro' ),
        'APU' => __( 'Apurímac', 'wpuf-pro' ),
        'ARE' => __( 'Arequipa', 'wpuf-pro' ),
        'AYA' => __( 'Ayacucho', 'wpuf-pro' ),
        'CAJ' => __( 'Cajamarca', 'wpuf-pro' ),
        'CUS' => __( 'Cusco', 'wpuf-pro' ),
        'HUV' => __( 'Huancavelica', 'wpuf-pro' ),
        'HUC' => __( 'Huánuco', 'wpuf-pro' ),
        'ICA' => __( 'Ica', 'wpuf-pro' ),
        'JUN' => __( 'Junín', 'wpuf-pro' ),
        'LAL' => __( 'La Libertad', 'wpuf-pro' ),
        'LAM' => __( 'Lambayeque', 'wpuf-pro' ),
        'LIM' => __( 'Lima', 'wpuf-pro' ),
        'LOR' => __( 'Loreto', 'wpuf-pro' ),
        'MDD' => __( 'Madre de Dios', 'wpuf-pro' ),
        'MOQ' => __( 'Moquegua', 'wpuf-pro' ),
        'PAS' => __( 'Pasco', 'wpuf-pro' ),
        'PIU' => __( 'Piura', 'wpuf-pro' ),
        'PUN' => __( 'Puno', 'wpuf-pro' ),
        'SAM' => __( 'San Martín', 'wpuf-pro' ),
        'TAC' => __( 'Tacna', 'wpuf-pro' ),
        'TUM' => __( 'Tumbes', 'wpuf-pro' ),
        'UCA' => __( 'Ucayali', 'wpuf-pro' ),
    ],

    /**
     * Philippine Provinces.
     */
    'PH' => [
        'ABR' => __( 'Abra', 'wpuf-pro' ),
        'AGN' => __( 'Agusan del Norte', 'wpuf-pro' ),
        'AGS' => __( 'Agusan del Sur', 'wpuf-pro' ),
        'AKL' => __( 'Aklan', 'wpuf-pro' ),
        'ALB' => __( 'Albay', 'wpuf-pro' ),
        'ANT' => __( 'Antique', 'wpuf-pro' ),
        'APA' => __( 'Apayao', 'wpuf-pro' ),
        'AUR' => __( 'Aurora', 'wpuf-pro' ),
        'BAS' => __( 'Basilan', 'wpuf-pro' ),
        'BAN' => __( 'Bataan', 'wpuf-pro' ),
        'BTN' => __( 'Batanes', 'wpuf-pro' ),
        'BTG' => __( 'Batangas', 'wpuf-pro' ),
        'BEN' => __( 'Benguet', 'wpuf-pro' ),
        'BIL' => __( 'Biliran', 'wpuf-pro' ),
        'BOH' => __( 'Bohol', 'wpuf-pro' ),
        'BUK' => __( 'Bukidnon', 'wpuf-pro' ),
        'BUL' => __( 'Bulacan', 'wpuf-pro' ),
        'CAG' => __( 'Cagayan', 'wpuf-pro' ),
        'CAN' => __( 'Camarines Norte', 'wpuf-pro' ),
        'CAS' => __( 'Camarines Sur', 'wpuf-pro' ),
        'CAM' => __( 'Camiguin', 'wpuf-pro' ),
        'CAP' => __( 'Capiz', 'wpuf-pro' ),
        'CAT' => __( 'Catanduanes', 'wpuf-pro' ),
        'CAV' => __( 'Cavite', 'wpuf-pro' ),
        'CEB' => __( 'Cebu', 'wpuf-pro' ),
        'COM' => __( 'Compostela Valley', 'wpuf-pro' ),
        'NCO' => __( 'Cotabato', 'wpuf-pro' ),
        'DAV' => __( 'Davao del Norte', 'wpuf-pro' ),
        'DAS' => __( 'Davao del Sur', 'wpuf-pro' ),
        'DAC' => __( 'Davao Occidental', 'wpuf-pro' ),
        'DAO' => __( 'Davao Oriental', 'wpuf-pro' ),
        'DIN' => __( 'Dinagat Islands', 'wpuf-pro' ),
        'EAS' => __( 'Eastern Samar', 'wpuf-pro' ),
        'GUI' => __( 'Guimaras', 'wpuf-pro' ),
        'IFU' => __( 'Ifugao', 'wpuf-pro' ),
        'ILN' => __( 'Ilocos Norte', 'wpuf-pro' ),
        'ILS' => __( 'Ilocos Sur', 'wpuf-pro' ),
        'ILI' => __( 'Iloilo', 'wpuf-pro' ),
        'ISA' => __( 'Isabela', 'wpuf-pro' ),
        'KAL' => __( 'Kalinga', 'wpuf-pro' ),
        'LUN' => __( 'La Union', 'wpuf-pro' ),
        'LAG' => __( 'Laguna', 'wpuf-pro' ),
        'LAN' => __( 'Lanao del Norte', 'wpuf-pro' ),
        'LAS' => __( 'Lanao del Sur', 'wpuf-pro' ),
        'LEY' => __( 'Leyte', 'wpuf-pro' ),
        'MAG' => __( 'Maguindanao', 'wpuf-pro' ),
        'MAD' => __( 'Marinduque', 'wpuf-pro' ),
        'MAS' => __( 'Masbate', 'wpuf-pro' ),
        'MSC' => __( 'Misamis Occidental', 'wpuf-pro' ),
        'MSR' => __( 'Misamis Oriental', 'wpuf-pro' ),
        'MOU' => __( 'Mountain Province', 'wpuf-pro' ),
        'NEC' => __( 'Negros Occidental', 'wpuf-pro' ),
        'NER' => __( 'Negros Oriental', 'wpuf-pro' ),
        'NSA' => __( 'Northern Samar', 'wpuf-pro' ),
        'NUE' => __( 'Nueva Ecija', 'wpuf-pro' ),
        'NUV' => __( 'Nueva Vizcaya', 'wpuf-pro' ),
        'MDC' => __( 'Occidental Mindoro', 'wpuf-pro' ),
        'MDR' => __( 'Oriental Mindoro', 'wpuf-pro' ),
        'PLW' => __( 'Palawan', 'wpuf-pro' ),
        'PAM' => __( 'Pampanga', 'wpuf-pro' ),
        'PAN' => __( 'Pangasinan', 'wpuf-pro' ),
        'QUE' => __( 'Quezon', 'wpuf-pro' ),
        'QUI' => __( 'Quirino', 'wpuf-pro' ),
        'RIZ' => __( 'Rizal', 'wpuf-pro' ),
        'ROM' => __( 'Romblon', 'wpuf-pro' ),
        'WSA' => __( 'Samar', 'wpuf-pro' ),
        'SAR' => __( 'Sarangani', 'wpuf-pro' ),
        'SIQ' => __( 'Siquijor', 'wpuf-pro' ),
        'SOR' => __( 'Sorsogon', 'wpuf-pro' ),
        'SCO' => __( 'South Cotabato', 'wpuf-pro' ),
        'SLE' => __( 'Southern Leyte', 'wpuf-pro' ),
        'SUK' => __( 'Sultan Kudarat', 'wpuf-pro' ),
        'SLU' => __( 'Sulu', 'wpuf-pro' ),
        'SUN' => __( 'Surigao del Norte', 'wpuf-pro' ),
        'SUR' => __( 'Surigao del Sur', 'wpuf-pro' ),
        'TAR' => __( 'Tarlac', 'wpuf-pro' ),
        'TAW' => __( 'Tawi-Tawi', 'wpuf-pro' ),
        'ZMB' => __( 'Zambales', 'wpuf-pro' ),
        'ZAN' => __( 'Zamboanga del Norte', 'wpuf-pro' ),
        'ZAS' => __( 'Zamboanga del Sur', 'wpuf-pro' ),
        'ZSI' => __( 'Zamboanga Sibugay', 'wpuf-pro' ),
        '00'  => __( 'Metro Manila', 'wpuf-pro' ),
    ],
    'PK' => [ // Pakistan's states.
        'JK' => __( 'Azad Kashmir', 'wpuf-pro' ),
        'BA' => __( 'Balochistan', 'wpuf-pro' ),
        'TA' => __( 'FATA', 'wpuf-pro' ),
        'GB' => __( 'Gilgit Baltistan', 'wpuf-pro' ),
        'IS' => __( 'Islamabad Capital Territory', 'wpuf-pro' ),
        'KP' => __( 'Khyber Pakhtunkhwa', 'wpuf-pro' ),
        'PB' => __( 'Punjab', 'wpuf-pro' ),
        'SD' => __( 'Sindh', 'wpuf-pro' ),
    ],
    'PL' => [ // Poland voivodeships.
        'PL-DS' => __( 'Dolnośląskie', 'wpuf-pro' ),
        'PL-KP' => __( 'Kujawsko-Pomorskie', 'wpuf-pro' ),
        'PL-LD' => __( 'Łódzkie', 'wpuf-pro' ),
        'PL-LU' => __( 'Lubelskie', 'wpuf-pro' ),
        'PL-LB' => __( 'Lubuskie', 'wpuf-pro' ),
        'PL-MA' => __( 'Małopolskie', 'wpuf-pro' ),
        'PL-MZ' => __( 'Mazowieckie', 'wpuf-pro' ),
        'PL-OP' => __( 'Opolskie', 'wpuf-pro' ),
        'PL-PK' => __( 'Podkarpackie', 'wpuf-pro' ),
        'PL-PD' => __( 'Podlaskie', 'wpuf-pro' ),
        'PL-PM' => __( 'Pomorskie', 'wpuf-pro' ),
        'PL-SL' => __( 'Śląskie', 'wpuf-pro' ),
        'PL-SK' => __( 'Świętokrzyskie', 'wpuf-pro' ),
        'PL-WN' => __( 'Warmińsko-Mazurskie', 'wpuf-pro' ),
        'PL-WP' => __( 'Wielkopolskie', 'wpuf-pro' ),
        'PL-ZP' => __( 'Zachodniopomorskie', 'wpuf-pro' ),
    ],
    'PR' => [ // Puerto Rico districts.
        'PR-01' => __( 'Adjuntas', 'wpuf-pro' ),
        'PR-02' => __( 'Aguada', 'wpuf-pro' ),
        'PR-03' => __( 'Aguadilla', 'wpuf-pro' ),
        'PR-04' => __( 'Aguas Buenas', 'wpuf-pro' ),
        'PR-05' => __( 'Aibonito', 'wpuf-pro' ),
        'PR-06' => __( 'Anasco', 'wpuf-pro' ),
        'PR-07' => __( 'Arecibo', 'wpuf-pro' ),
    ],
    'PT' => [ // Portugal districts.
        'PT-20' => __( 'Açores (Azores)', 'wpuf-pro' ),
        'PT-01' => __( 'Aveiro', 'wpuf-pro' ),
        'PT-02' => __( 'Beja', 'wpuf-pro' ),
        'PT-03' => __( 'Braga', 'wpuf-pro' ),
        'PT-04' => __( 'Bragança', 'wpuf-pro' ),
        'PT-05' => __( 'Castelo Branco', 'wpuf-pro' ),
        'PT-06' => __( 'Coimbra', 'wpuf-pro' ),
        'PT-07' => __( 'Évora', 'wpuf-pro' ),
        'PT-08' => __( 'Faro', 'wpuf-pro' ),
        'PT-09' => __( 'Guarda', 'wpuf-pro' ),
        'PT-10' => __( 'Leiria', 'wpuf-pro' ),
        'PT-11' => __( 'Lisboa', 'wpuf-pro' ),
        'PT-30' => __( 'Madeira', 'wpuf-pro' ),
        'PT-12' => __( 'Portalegre', 'wpuf-pro' ),
        'PT-13' => __( 'Porto', 'wpuf-pro' ),
        'PT-14' => __( 'Santarém', 'wpuf-pro' ),
        'PT-15' => __( 'Setúbal', 'wpuf-pro' ),
        'PT-16' => __( 'Viana do Castelo', 'wpuf-pro' ),
        'PT-17' => __( 'Vila Real', 'wpuf-pro' ),
        'PT-18' => __( 'Viseu', 'wpuf-pro' ),
    ],
    'PY' => [ // Paraguay states.
        'PY-ASU' => __( 'Asunción', 'wpuf-pro' ),
        'PY-1'   => __( 'Concepción', 'wpuf-pro' ),
        'PY-2'   => __( 'San Pedro', 'wpuf-pro' ),
        'PY-3'   => __( 'Cordillera', 'wpuf-pro' ),
        'PY-4'   => __( 'Guairá', 'wpuf-pro' ),
        'PY-5'   => __( 'Caaguazú', 'wpuf-pro' ),
        'PY-6'   => __( 'Caazapá', 'wpuf-pro' ),
        'PY-7'   => __( 'Itapúa', 'wpuf-pro' ),
        'PY-8'   => __( 'Misiones', 'wpuf-pro' ),
        'PY-9'   => __( 'Paraguarí', 'wpuf-pro' ),
        'PY-10'  => __( 'Alto Paraná', 'wpuf-pro' ),
        'PY-11'  => __( 'Central', 'wpuf-pro' ),
        'PY-12'  => __( 'Ñeembucú', 'wpuf-pro' ),
        'PY-13'  => __( 'Amambay', 'wpuf-pro' ),
        'PY-14'  => __( 'Canindeyú', 'wpuf-pro' ),
        'PY-15'  => __( 'Presidente Hayes', 'wpuf-pro' ),
        'PY-16'  => __( 'Alto Paraguay', 'wpuf-pro' ),
        'PY-17'  => __( 'Boquerón', 'wpuf-pro' ),
    ],
    'RE' => [ // Réunion districts.
        'RE-01' => __( 'Saint-Denis', 'wpuf-pro' ),
        'RE-02' => __( 'Saint-Paul', 'wpuf-pro' ),
        'RE-03' => __( 'Saint-Pierre', 'wpuf-pro' ),
        'RE-04' => __( 'Le Tampon', 'wpuf-pro' ),
    ],
    'RO' => [ // Romania states.
        'AB' => __( 'Alba', 'wpuf-pro' ),
        'AR' => __( 'Arad', 'wpuf-pro' ),
        'AG' => __( 'Argeș', 'wpuf-pro' ),
        'BC' => __( 'Bacău', 'wpuf-pro' ),
        'BH' => __( 'Bihor', 'wpuf-pro' ),
        'BN' => __( 'Bistrița-Năsăud', 'wpuf-pro' ),
        'BT' => __( 'Botoșani', 'wpuf-pro' ),
        'BR' => __( 'Brăila', 'wpuf-pro' ),
        'BV' => __( 'Brașov', 'wpuf-pro' ),
        'B'  => __( 'București', 'wpuf-pro' ),
        'BZ' => __( 'Buzău', 'wpuf-pro' ),
        'CL' => __( 'Călărași', 'wpuf-pro' ),
        'CS' => __( 'Caraș-Severin', 'wpuf-pro' ),
        'CJ' => __( 'Cluj', 'wpuf-pro' ),
        'CT' => __( 'Constanța', 'wpuf-pro' ),
        'CV' => __( 'Covasna', 'wpuf-pro' ),
        'DB' => __( 'Dâmbovița', 'wpuf-pro' ),
        'DJ' => __( 'Dolj', 'wpuf-pro' ),
        'GL' => __( 'Galați', 'wpuf-pro' ),
        'GR' => __( 'Giurgiu', 'wpuf-pro' ),
        'GJ' => __( 'Gorj', 'wpuf-pro' ),
        'HR' => __( 'Harghita', 'wpuf-pro' ),
        'HD' => __( 'Hunedoara', 'wpuf-pro' ),
        'IL' => __( 'Ialomița', 'wpuf-pro' ),
        'IS' => __( 'Iași', 'wpuf-pro' ),
        'IF' => __( 'Ilfov', 'wpuf-pro' ),
        'MM' => __( 'Maramureș', 'wpuf-pro' ),
        'MH' => __( 'Mehedinți', 'wpuf-pro' ),
        'MS' => __( 'Mureș', 'wpuf-pro' ),
        'NT' => __( 'Neamț', 'wpuf-pro' ),
        'OT' => __( 'Olt', 'wpuf-pro' ),
        'PH' => __( 'Prahova', 'wpuf-pro' ),
        'SJ' => __( 'Sălaj', 'wpuf-pro' ),
        'SM' => __( 'Satu Mare', 'wpuf-pro' ),
        'SB' => __( 'Sibiu', 'wpuf-pro' ),
        'SV' => __( 'Suceava', 'wpuf-pro' ),
        'TR' => __( 'Teleorman', 'wpuf-pro' ),
        'TM' => __( 'Timiș', 'wpuf-pro' ),
        'TL' => __( 'Tulcea', 'wpuf-pro' ),
        'VL' => __( 'Vâlcea', 'wpuf-pro' ),
        'VS' => __( 'Vaslui', 'wpuf-pro' ),
        'VN' => __( 'Vrancea', 'wpuf-pro' ),
    ],
    'SG' => [ // Singapore districts.
        'SG-01' => __( 'Central', 'wpuf-pro' ),
        'SG-02' => __( 'East', 'wpuf-pro' ),
        'SG-03' => __( 'North', 'wpuf-pro' ),
        'SG-04' => __( 'North-East', 'wpuf-pro' ),
        'SG-05' => __( 'West', 'wpuf-pro' ),
    ],
    'SK' => [ // Slovakia districts.
        'SK-BC' => __( 'Banská Bystrica', 'wpuf-pro' ),
        'SK-BL' => __( 'Bratislava', 'wpuf-pro' ),
        'SK-KI' => __( 'Košice', 'wpuf-pro' ),
        'SK-NI' => __( 'Nitra', 'wpuf-pro' ),
        'SK-PV' => __( 'Prešov', 'wpuf-pro' ),
    ],
    'SI' => [ // Slovenia districts.
        'SI-001' => __( 'Ajdovščina', 'wpuf-pro' ),
        'SI-002' => __( 'Beltinci', 'wpuf-pro' ),
        'SI-003' => __( 'Bled', 'wpuf-pro' ),
        'SI-004' => __( 'Bohinj', 'wpuf-pro' ),
        'SI-005' => __( 'Borovnica', 'wpuf-pro' ),
    ],
    'TH' => [ // Thailand states.
        'TH-37' => __( 'Amnat Charoen', 'wpuf-pro' ),
        'TH-15' => __( 'Ang Thong', 'wpuf-pro' ),
        'TH-14' => __( 'Ayutthaya', 'wpuf-pro' ),
        'TH-10' => __( 'Bangkok', 'wpuf-pro' ),
        'TH-38' => __( 'Bueng Kan', 'wpuf-pro' ),
        'TH-31' => __( 'Buri Ram', 'wpuf-pro' ),
        'TH-24' => __( 'Chachoengsao', 'wpuf-pro' ),
        'TH-18' => __( 'Chai Nat', 'wpuf-pro' ),
        'TH-36' => __( 'Chaiyaphum', 'wpuf-pro' ),
        'TH-22' => __( 'Chanthaburi', 'wpuf-pro' ),
        'TH-50' => __( 'Chiang Mai', 'wpuf-pro' ),
        'TH-57' => __( 'Chiang Rai', 'wpuf-pro' ),
        'TH-20' => __( 'Chonburi', 'wpuf-pro' ),
        'TH-86' => __( 'Chumphon', 'wpuf-pro' ),
        'TH-46' => __( 'Kalasin', 'wpuf-pro' ),
        'TH-62' => __( 'Kamphaeng Phet', 'wpuf-pro' ),
        'TH-71' => __( 'Kanchanaburi', 'wpuf-pro' ),
        'TH-40' => __( 'Khon Kaen', 'wpuf-pro' ),
        'TH-81' => __( 'Krabi', 'wpuf-pro' ),
        'TH-52' => __( 'Lampang', 'wpuf-pro' ),
        'TH-51' => __( 'Lamphun', 'wpuf-pro' ),
        'TH-42' => __( 'Loei', 'wpuf-pro' ),
        'TH-16' => __( 'Lopburi', 'wpuf-pro' ),
        'TH-58' => __( 'Mae Hong Son', 'wpuf-pro' ),
        'TH-44' => __( 'Maha Sarakham', 'wpuf-pro' ),
        'TH-49' => __( 'Mukdahan', 'wpuf-pro' ),
        'TH-26' => __( 'Nakhon Nayok', 'wpuf-pro' ),
        'TH-73' => __( 'Nakhon Pathom', 'wpuf-pro' ),
        'TH-48' => __( 'Nakhon Phanom', 'wpuf-pro' ),
        'TH-30' => __( 'Nakhon Ratchasima', 'wpuf-pro' ),
        'TH-60' => __( 'Nakhon Sawan', 'wpuf-pro' ),
        'TH-80' => __( 'Nakhon Si Thammarat', 'wpuf-pro' ),
        'TH-55' => __( 'Nan', 'wpuf-pro' ),
        'TH-96' => __( 'Narathiwat', 'wpuf-pro' ),
        'TH-39' => __( 'Nong Bua Lam Phu', 'wpuf-pro' ),
        'TH-43' => __( 'Nong Khai', 'wpuf-pro' ),
        'TH-12' => __( 'Nonthaburi', 'wpuf-pro' ),
        'TH-13' => __( 'Pathum Thani', 'wpuf-pro' ),
        'TH-94' => __( 'Pattani', 'wpuf-pro' ),
        'TH-82' => __( 'Phang Nga', 'wpuf-pro' ),
        'TH-93' => __( 'Phatthalung', 'wpuf-pro' ),
        'TH-56' => __( 'Phayao', 'wpuf-pro' ),
        'TH-67' => __( 'Phetchabun', 'wpuf-pro' ),
        'TH-76' => __( 'Phetchaburi', 'wpuf-pro' ),
        'TH-66' => __( 'Phichit', 'wpuf-pro' ),
        'TH-65' => __( 'Phitsanulok', 'wpuf-pro' ),
        'TH-54' => __( 'Phrae', 'wpuf-pro' ),
        'TH-83' => __( 'Phuket', 'wpuf-pro' ),
        'TH-25' => __( 'Prachin Buri', 'wpuf-pro' ),
        'TH-77' => __( 'Prachuap Khiri Khan', 'wpuf-pro' ),
        'TH-85' => __( 'Ranong', 'wpuf-pro' ),
        'TH-70' => __( 'Ratchaburi', 'wpuf-pro' ),
        'TH-21' => __( 'Rayong', 'wpuf-pro' ),
        'TH-45' => __( 'Roi Et', 'wpuf-pro' ),
        'TH-27' => __( 'Sa Kaeo', 'wpuf-pro' ),
        'TH-47' => __( 'Sakon Nakhon', 'wpuf-pro' ),
        'TH-11' => __( 'Samut Prakan', 'wpuf-pro' ),
        'TH-74' => __( 'Samut Sakhon', 'wpuf-pro' ),
        'TH-75' => __( 'Samut Songkhram', 'wpuf-pro' ),
        'TH-19' => __( 'Saraburi', 'wpuf-pro' ),
        'TH-91' => __( 'Satun', 'wpuf-pro' ),
        'TH-17' => __( 'Sing Buri', 'wpuf-pro' ),
        'TH-33' => __( 'Sisaket', 'wpuf-pro' ),
        'TH-90' => __( 'Songkhla', 'wpuf-pro' ),
        'TH-64' => __( 'Sukhothai', 'wpuf-pro' ),
        'TH-72' => __( 'Suphan Buri', 'wpuf-pro' ),
        'TH-84' => __( 'Surat Thani', 'wpuf-pro' ),
        'TH-32' => __( 'Surin', 'wpuf-pro' ),
        'TH-63' => __( 'Tak', 'wpuf-pro' ),
        'TH-92' => __( 'Trang', 'wpuf-pro' ),
        'TH-23' => __( 'Trat', 'wpuf-pro' ),
        'TH-34' => __( 'Ubon Ratchathani', 'wpuf-pro' ),
        'TH-41' => __( 'Udon Thani', 'wpuf-pro' ),
        'TH-61' => __( 'Uthai Thani', 'wpuf-pro' ),
        'TH-53' => __( 'Uttaradit', 'wpuf-pro' ),
        'TH-95' => __( 'Yala', 'wpuf-pro' ),
        'TH-35' => __( 'Yasothon', 'wpuf-pro' ),
    ],
    'TR' => [ // Turkey States.
        'TR01' => __( 'Adana', 'wpuf-pro' ),
        'TR02' => __( 'Adıyaman', 'wpuf-pro' ),
        'TR03' => __( 'Afyon', 'wpuf-pro' ),
        'TR04' => __( 'Ağrı', 'wpuf-pro' ),
        'TR05' => __( 'Amasya', 'wpuf-pro' ),
        'TR06' => __( 'Ankara', 'wpuf-pro' ),
        'TR07' => __( 'Antalya', 'wpuf-pro' ),
        'TR08' => __( 'Artvin', 'wpuf-pro' ),
        'TR09' => __( 'Aydın', 'wpuf-pro' ),
        'TR10' => __( 'Balıkesir', 'wpuf-pro' ),
        'TR11' => __( 'Bilecik', 'wpuf-pro' ),
        'TR12' => __( 'Bingöl', 'wpuf-pro' ),
        'TR13' => __( 'Bitlis', 'wpuf-pro' ),
        'TR14' => __( 'Bolu', 'wpuf-pro' ),
        'TR15' => __( 'Burdur', 'wpuf-pro' ),
        'TR16' => __( 'Bursa', 'wpuf-pro' ),
        'TR17' => __( 'Çanakkale', 'wpuf-pro' ),
        'TR18' => __( 'Çankırı', 'wpuf-pro' ),
        'TR19' => __( 'Çorum', 'wpuf-pro' ),
        'TR20' => __( 'Denizli', 'wpuf-pro' ),
        'TR21' => __( 'Diyarbakır', 'wpuf-pro' ),
        'TR22' => __( 'Edirne', 'wpuf-pro' ),
        'TR23' => __( 'Elazığ', 'wpuf-pro' ),
        'TR24' => __( 'Erzincan', 'wpuf-pro' ),
        'TR25' => __( 'Erzurum', 'wpuf-pro' ),
        'TR26' => __( 'Eskişehir', 'wpuf-pro' ),
        'TR27' => __( 'Gaziantep', 'wpuf-pro' ),
        'TR28' => __( 'Giresun', 'wpuf-pro' ),
        'TR29' => __( 'Gümüşhane', 'wpuf-pro' ),
        'TR30' => __( 'Hakkari', 'wpuf-pro' ),
        'TR31' => __( 'Hatay', 'wpuf-pro' ),
        'TR32' => __( 'Isparta', 'wpuf-pro' ),
        'TR33' => __( 'İçel', 'wpuf-pro' ),
        'TR34' => __( 'İstanbul', 'wpuf-pro' ),
        'TR35' => __( 'İzmir', 'wpuf-pro' ),
        'TR36' => __( 'Kars', 'wpuf-pro' ),
        'TR37' => __( 'Kastamonu', 'wpuf-pro' ),
        'TR38' => __( 'Kayseri', 'wpuf-pro' ),
        'TR39' => __( 'Kırklareli', 'wpuf-pro' ),
        'TR40' => __( 'Kırşehir', 'wpuf-pro' ),
        'TR41' => __( 'Kocaeli', 'wpuf-pro' ),
        'TR42' => __( 'Konya', 'wpuf-pro' ),
        'TR43' => __( 'Kütahya', 'wpuf-pro' ),
        'TR44' => __( 'Malatya', 'wpuf-pro' ),
        'TR45' => __( 'Manisa', 'wpuf-pro' ),
        'TR46' => __( 'Kahramanmaraş', 'wpuf-pro' ),
        'TR47' => __( 'Mardin', 'wpuf-pro' ),
        'TR48' => __( 'Muğla', 'wpuf-pro' ),
        'TR49' => __( 'Muş', 'wpuf-pro' ),
        'TR50' => __( 'Nevşehir', 'wpuf-pro' ),
        'TR51' => __( 'Niğde', 'wpuf-pro' ),
        'TR52' => __( 'Ordu', 'wpuf-pro' ),
        'TR53' => __( 'Rize', 'wpuf-pro' ),
        'TR54' => __( 'Sakarya', 'wpuf-pro' ),
        'TR55' => __( 'Samsun', 'wpuf-pro' ),
        'TR56' => __( 'Siirt', 'wpuf-pro' ),
        'TR57' => __( 'Sinop', 'wpuf-pro' ),
        'TR58' => __( 'Sivas', 'wpuf-pro' ),
        'TR59' => __( 'Tekirdağ', 'wpuf-pro' ),
        'TR60' => __( 'Tokat', 'wpuf-pro' ),
        'TR61' => __( 'Trabzon', 'wpuf-pro' ),
        'TR62' => __( 'Tunceli', 'wpuf-pro' ),
        'TR63' => __( 'Şanlıurfa', 'wpuf-pro' ),
        'TR64' => __( 'Uşak', 'wpuf-pro' ),
        'TR65' => __( 'Van', 'wpuf-pro' ),
        'TR66' => __( 'Yozgat', 'wpuf-pro' ),
        'TR67' => __( 'Zonguldak', 'wpuf-pro' ),
        'TR68' => __( 'Aksaray', 'wpuf-pro' ),
        'TR69' => __( 'Bayburt', 'wpuf-pro' ),
        'TR70' => __( 'Karaman', 'wpuf-pro' ),
        'TR71' => __( 'Kırıkkale', 'wpuf-pro' ),
        'TR72' => __( 'Batman', 'wpuf-pro' ),
        'TR73' => __( 'Şırnak', 'wpuf-pro' ),
        'TR74' => __( 'Bartın', 'wpuf-pro' ),
        'TR75' => __( 'Ardahan', 'wpuf-pro' ),
        'TR76' => __( 'Iğdır', 'wpuf-pro' ),
        'TR77' => __( 'Yalova', 'wpuf-pro' ),
        'TR78' => __( 'Karabük', 'wpuf-pro' ),
        'TR79' => __( 'Kilis', 'wpuf-pro' ),
        'TR80' => __( 'Osmaniye', 'wpuf-pro' ),
        'TR81' => __( 'Düzce', 'wpuf-pro' ),
    ],
    'TZ' => [ // Tanzania States.
        'TZ01' => __( 'Arusha', 'wpuf-pro' ),
        'TZ02' => __( 'Dar es Salaam', 'wpuf-pro' ),
        'TZ03' => __( 'Dodoma', 'wpuf-pro' ),
        'TZ04' => __( 'Iringa', 'wpuf-pro' ),
        'TZ05' => __( 'Kagera', 'wpuf-pro' ),
        'TZ06' => __( 'Pemba North', 'wpuf-pro' ),
        'TZ07' => __( 'Zanzibar North', 'wpuf-pro' ),
        'TZ08' => __( 'Kigoma', 'wpuf-pro' ),
        'TZ09' => __( 'Kilimanjaro', 'wpuf-pro' ),
        'TZ10' => __( 'Pemba South', 'wpuf-pro' ),
        'TZ11' => __( 'Zanzibar South', 'wpuf-pro' ),
        'TZ12' => __( 'Lindi', 'wpuf-pro' ),
        'TZ13' => __( 'Mara', 'wpuf-pro' ),
        'TZ14' => __( 'Mbeya', 'wpuf-pro' ),
        'TZ15' => __( 'Zanzibar West', 'wpuf-pro' ),
        'TZ16' => __( 'Morogoro', 'wpuf-pro' ),
        'TZ17' => __( 'Mtwara', 'wpuf-pro' ),
        'TZ18' => __( 'Mwanza', 'wpuf-pro' ),
        'TZ19' => __( 'Coast', 'wpuf-pro' ),
        'TZ20' => __( 'Rukwa', 'wpuf-pro' ),
        'TZ21' => __( 'Ruvuma', 'wpuf-pro' ),
        'TZ22' => __( 'Shinyanga', 'wpuf-pro' ),
        'TZ23' => __( 'Singida', 'wpuf-pro' ),
        'TZ24' => __( 'Tabora', 'wpuf-pro' ),
        'TZ25' => __( 'Tanga', 'wpuf-pro' ),
        'TZ26' => __( 'Manyara', 'wpuf-pro' ),
        'TZ27' => __( 'Geita', 'wpuf-pro' ),
        'TZ28' => __( 'Katavi', 'wpuf-pro' ),
        'TZ29' => __( 'Njombe', 'wpuf-pro' ),
        'TZ30' => __( 'Simiyu', 'wpuf-pro' ),
    ],
    'LK' => [ // Sri Lanka districts.
        'LK-11' => __( 'Colombo', 'wpuf-pro' ),
        'LK-12' => __( 'Gampaha', 'wpuf-pro' ),
        'LK-13' => __( 'Kalutara', 'wpuf-pro' ),
        'LK-21' => __( 'Kandy', 'wpuf-pro' ),
        'LK-22' => __( 'Matale', 'wpuf-pro' ),
        'LK-23' => __( 'Nuwara Eliya', 'wpuf-pro' ),
        'LK-24' => __( 'Kurunegala', 'wpuf-pro' ),
        'LK-31' => __( 'Ampara', 'wpuf-pro' ),
        'LK-32' => __( 'Batticaloa', 'wpuf-pro' ),
        'LK-33' => __( 'Trincomalee', 'wpuf-pro' ),
        'LK-41' => __( 'Anuradhapura', 'wpuf-pro' ),
        'LK-42' => __( 'Polonnaruwa', 'wpuf-pro' ),
        'LK-51' => __( 'Badulla', 'wpuf-pro' ),
        'LK-52' => __( 'Monaragala', 'wpuf-pro' ),
        'LK-61' => __( 'Ratnapura', 'wpuf-pro' ),
        'LK-62' => __( 'Kegalle', 'wpuf-pro' ),
    ],
    'RS' => [ // Serbia districts Ref: https://github.com/unicode-org/cldr/blob/release-37/common/subdivisions/en.xml#L4251-L4283.
        'RS00' => _x( 'Belgrade', 'district', 'wpuf-pro' ),
        'RS14' => _x( 'Bor', 'district', 'wpuf-pro' ),
        'RS11' => _x( 'Braničevo', 'district', 'wpuf-pro' ),
        'RS02' => _x( 'Central Banat', 'district', 'wpuf-pro' ),
        'RS10' => _x( 'Danube', 'district', 'wpuf-pro' ),
        'RS23' => _x( 'Jablanica', 'district', 'wpuf-pro' ),
        'RS09' => _x( 'Kolubara', 'district', 'wpuf-pro' ),
        'RS08' => _x( 'Mačva', 'district', 'wpuf-pro' ),
        'RS17' => _x( 'Morava', 'district', 'wpuf-pro' ),
        'RS20' => _x( 'Nišava', 'district', 'wpuf-pro' ),
        'RS01' => _x( 'North Bačka', 'district', 'wpuf-pro' ),
        'RS03' => _x( 'North Banat', 'district', 'wpuf-pro' ),
        'RS24' => _x( 'Pčinja', 'district', 'wpuf-pro' ),
        'RS22' => _x( 'Pirot', 'district', 'wpuf-pro' ),
        'RS13' => _x( 'Pomoravlje', 'district', 'wpuf-pro' ),
        'RS19' => _x( 'Rasina', 'district', 'wpuf-pro' ),
        'RS18' => _x( 'Raška', 'district', 'wpuf-pro' ),
        'RS06' => _x( 'South Bačka', 'district', 'wpuf-pro' ),
        'RS04' => _x( 'South Banat', 'district', 'wpuf-pro' ),
        'RS07' => _x( 'Srem', 'district', 'wpuf-pro' ),
        'RS12' => _x( 'Šumadija', 'district', 'wpuf-pro' ),
        'RS21' => _x( 'Toplica', 'district', 'wpuf-pro' ),
        'RS05' => _x( 'West Bačka', 'district', 'wpuf-pro' ),
        'RS15' => _x( 'Zaječar', 'district', 'wpuf-pro' ),
        'RS16' => _x( 'Zlatibor', 'district', 'wpuf-pro' ),
        'RS25' => _x( 'Kosovo', 'district', 'wpuf-pro' ),
        'RS26' => _x( 'Peć', 'district', 'wpuf-pro' ),
        'RS27' => _x( 'Prizren', 'district', 'wpuf-pro' ),
        'RS28' => _x( 'Kosovska Mitrovica', 'district', 'wpuf-pro' ),
        'RS29' => _x( 'Kosovo-Pomoravlje', 'district', 'wpuf-pro' ),
        'RSKM' => _x( 'Kosovo-Metohija', 'district', 'wpuf-pro' ),
        'RSVO' => _x( 'Vojvodina', 'district', 'wpuf-pro' ),
    ],
    'SE' => [ // Sweden districts.
        'SE-AB' => __( 'Stockholm', 'wpuf-pro' ),
        'SE-AC' => __( 'Västerbotten', 'wpuf-pro' ),
        'SE-BD' => __( 'Norrbotten', 'wpuf-pro' ),
        'SE-C' => __( 'Uppsala', 'wpuf-pro' ),
        'SE-D' => __( 'Södermanland', 'wpuf-pro' ),
    ],
    'UG' => [ // Uganda districts. Ref: https://en.wikipedia.org/wiki/ISO_3166-2:UG.
        'UG314' => __( 'Abim', 'wpuf-pro' ),
        'UG301' => __( 'Adjumani', 'wpuf-pro' ),
        'UG322' => __( 'Agago', 'wpuf-pro' ),
        'UG323' => __( 'Alebtong', 'wpuf-pro' ),
        'UG315' => __( 'Amolatar', 'wpuf-pro' ),
        'UG324' => __( 'Amudat', 'wpuf-pro' ),
        'UG216' => __( 'Amuria', 'wpuf-pro' ),
        'UG316' => __( 'Amuru', 'wpuf-pro' ),
        'UG302' => __( 'Apac', 'wpuf-pro' ),
        'UG303' => __( 'Arua', 'wpuf-pro' ),
        'UG217' => __( 'Budaka', 'wpuf-pro' ),
        'UG218' => __( 'Bududa', 'wpuf-pro' ),
        'UG201' => __( 'Bugiri', 'wpuf-pro' ),
        'UG235' => __( 'Bugweri', 'wpuf-pro' ),
        'UG420' => __( 'Buhweju', 'wpuf-pro' ),
        'UG117' => __( 'Buikwe', 'wpuf-pro' ),
        'UG219' => __( 'Bukedea', 'wpuf-pro' ),
        'UG118' => __( 'Bukomansimbi', 'wpuf-pro' ),
        'UG220' => __( 'Bukwa', 'wpuf-pro' ),
        'UG225' => __( 'Bulambuli', 'wpuf-pro' ),
        'UG416' => __( 'Buliisa', 'wpuf-pro' ),
        'UG401' => __( 'Bundibugyo', 'wpuf-pro' ),
        'UG430' => __( 'Bunyangabu', 'wpuf-pro' ),
        'UG402' => __( 'Bushenyi', 'wpuf-pro' ),
        'UG202' => __( 'Busia', 'wpuf-pro' ),
        'UG221' => __( 'Butaleja', 'wpuf-pro' ),
        'UG119' => __( 'Butambala', 'wpuf-pro' ),
        'UG233' => __( 'Butebo', 'wpuf-pro' ),
        'UG120' => __( 'Buvuma', 'wpuf-pro' ),
        'UG226' => __( 'Buyende', 'wpuf-pro' ),
        'UG317' => __( 'Dokolo', 'wpuf-pro' ),
        'UG121' => __( 'Gomba', 'wpuf-pro' ),
        'UG304' => __( 'Gulu', 'wpuf-pro' ),
        'UG403' => __( 'Hoima', 'wpuf-pro' ),
        'UG417' => __( 'Ibanda', 'wpuf-pro' ),
        'UG203' => __( 'Iganga', 'wpuf-pro' ),
        'UG418' => __( 'Isingiro', 'wpuf-pro' ),
        'UG204' => __( 'Jinja', 'wpuf-pro' ),
        'UG318' => __( 'Kaabong', 'wpuf-pro' ),
        'UG404' => __( 'Kabale', 'wpuf-pro' ),
        'UG405' => __( 'Kabarole', 'wpuf-pro' ),
        'UG213' => __( 'Kaberamaido', 'wpuf-pro' ),
        'UG427' => __( 'Kagadi', 'wpuf-pro' ),
        'UG428' => __( 'Kakumiro', 'wpuf-pro' ),
        'UG101' => __( 'Kalangala', 'wpuf-pro' ),
        'UG222' => __( 'Kaliro', 'wpuf-pro' ),
        'UG122' => __( 'Kalungu', 'wpuf-pro' ),
        'UG102' => __( 'Kampala', 'wpuf-pro' ),
        'UG205' => __( 'Kamuli', 'wpuf-pro' ),
        'UG413' => __( 'Kamwenge', 'wpuf-pro' ),
        'UG414' => __( 'Kanungu', 'wpuf-pro' ),
        'UG206' => __( 'Kapchorwa', 'wpuf-pro' ),
        'UG236' => __( 'Kapelebyong', 'wpuf-pro' ),
        'UG126' => __( 'Kasanda', 'wpuf-pro' ),
        'UG406' => __( 'Kasese', 'wpuf-pro' ),
        'UG207' => __( 'Katakwi', 'wpuf-pro' ),
        'UG112' => __( 'Kayunga', 'wpuf-pro' ),
        'UG407' => __( 'Kibaale', 'wpuf-pro' ),
        'UG103' => __( 'Kiboga', 'wpuf-pro' ),
        'UG227' => __( 'Kibuku', 'wpuf-pro' ),
        'UG432' => __( 'Kikuube', 'wpuf-pro' ),
        'UG419' => __( 'Kiruhura', 'wpuf-pro' ),
        'UG421' => __( 'Kiryandongo', 'wpuf-pro' ),
        'UG408' => __( 'Kisoro', 'wpuf-pro' ),
        'UG305' => __( 'Kitgum', 'wpuf-pro' ),
        'UG319' => __( 'Koboko', 'wpuf-pro' ),
        'UG325' => __( 'Kole', 'wpuf-pro' ),
        'UG306' => __( 'Kotido', 'wpuf-pro' ),
        'UG208' => __( 'Kumi', 'wpuf-pro' ),
        'UG333' => __( 'Kwania', 'wpuf-pro' ),
        'UG228' => __( 'Kween', 'wpuf-pro' ),
        'UG123' => __( 'Kyankwanzi', 'wpuf-pro' ),
        'UG422' => __( 'Kyegegwa', 'wpuf-pro' ),
        'UG415' => __( 'Kyenjojo', 'wpuf-pro' ),
        'UG125' => __( 'Kyotera', 'wpuf-pro' ),
        'UG326' => __( 'Lamwo', 'wpuf-pro' ),
        'UG307' => __( 'Lira', 'wpuf-pro' ),
        'UG229' => __( 'Luuka', 'wpuf-pro' ),
        'UG104' => __( 'Luwero', 'wpuf-pro' ),
        'UG124' => __( 'Lwengo', 'wpuf-pro' ),
        'UG114' => __( 'Lyantonde', 'wpuf-pro' ),
        'UG223' => __( 'Manafwa', 'wpuf-pro' ),
        'UG320' => __( 'Maracha', 'wpuf-pro' ),
        'UG105' => __( 'Masaka', 'wpuf-pro' ),
        'UG409' => __( 'Masindi', 'wpuf-pro' ),
        'UG214' => __( 'Mayuge', 'wpuf-pro' ),
        'UG209' => __( 'Mbale', 'wpuf-pro' ),
        'UG410' => __( 'Mbarara', 'wpuf-pro' ),
        'UG423' => __( 'Mitooma', 'wpuf-pro' ),
        'UG115' => __( 'Mityana', 'wpuf-pro' ),
        'UG308' => __( 'Moroto', 'wpuf-pro' ),
        'UG309' => __( 'Moyo', 'wpuf-pro' ),
        'UG106' => __( 'Mpigi', 'wpuf-pro' ),
        'UG107' => __( 'Mubende', 'wpuf-pro' ),
        'UG108' => __( 'Mukono', 'wpuf-pro' ),
        'UG334' => __( 'Nabilatuk', 'wpuf-pro' ),
        'UG311' => __( 'Nakapiripirit', 'wpuf-pro' ),
        'UG116' => __( 'Nakaseke', 'wpuf-pro' ),
        'UG109' => __( 'Nakasongola', 'wpuf-pro' ),
        'UG230' => __( 'Namayingo', 'wpuf-pro' ),
        'UG234' => __( 'Namisindwa', 'wpuf-pro' ),
        'UG224' => __( 'Namutumba', 'wpuf-pro' ),
        'UG327' => __( 'Napak', 'wpuf-pro' ),
        'UG310' => __( 'Nebbi', 'wpuf-pro' ),
        'UG231' => __( 'Ngora', 'wpuf-pro' ),
        'UG424' => __( 'Ntoroko', 'wpuf-pro' ),
        'UG411' => __( 'Ntungamo', 'wpuf-pro' ),
        'UG328' => __( 'Nwoya', 'wpuf-pro' ),
        'UG331' => __( 'Omoro', 'wpuf-pro' ),
        'UG329' => __( 'Otuke', 'wpuf-pro' ),
        'UG321' => __( 'Oyam', 'wpuf-pro' ),
        'UG312' => __( 'Pader', 'wpuf-pro' ),
        'UG332' => __( 'Pakwach', 'wpuf-pro' ),
        'UG210' => __( 'Pallisa', 'wpuf-pro' ),
        'UG110' => __( 'Rakai', 'wpuf-pro' ),
        'UG429' => __( 'Rubanda', 'wpuf-pro' ),
        'UG425' => __( 'Rubirizi', 'wpuf-pro' ),
        'UG431' => __( 'Rukiga', 'wpuf-pro' ),
        'UG412' => __( 'Rukungiri', 'wpuf-pro' ),
        'UG111' => __( 'Sembabule', 'wpuf-pro' ),
        'UG232' => __( 'Serere', 'wpuf-pro' ),
        'UG426' => __( 'Sheema', 'wpuf-pro' ),
        'UG215' => __( 'Sironko', 'wpuf-pro' ),
        'UG211' => __( 'Soroti', 'wpuf-pro' ),
        'UG212' => __( 'Tororo', 'wpuf-pro' ),
        'UG113' => __( 'Wakiso', 'wpuf-pro' ),
        'UG313' => __( 'Yumbe', 'wpuf-pro' ),
        'UG330' => __( 'Zombo', 'wpuf-pro' ),
    ],
    'UM' => [
        '81' => __( 'Baker Island', 'wpuf-pro' ),
        '84' => __( 'Howland Island', 'wpuf-pro' ),
        '86' => __( 'Jarvis Island', 'wpuf-pro' ),
        '67' => __( 'Johnston Atoll', 'wpuf-pro' ),
        '89' => __( 'Kingman Reef', 'wpuf-pro' ),
        '71' => __( 'Midway Atoll', 'wpuf-pro' ),
        '76' => __( 'Navassa Island', 'wpuf-pro' ),
        '95' => __( 'Palmyra Atoll', 'wpuf-pro' ),
        '79' => __( 'Wake Island', 'wpuf-pro' ),
    ],
    'US' => [ // United States.
        'AL' => __( 'Alabama', 'wpuf-pro' ),
        'AK' => __( 'Alaska', 'wpuf-pro' ),
        'AZ' => __( 'Arizona', 'wpuf-pro' ),
        'AR' => __( 'Arkansas', 'wpuf-pro' ),
        'CA' => __( 'California', 'wpuf-pro' ),
        'CO' => __( 'Colorado', 'wpuf-pro' ),
        'CT' => __( 'Connecticut', 'wpuf-pro' ),
        'DE' => __( 'Delaware', 'wpuf-pro' ),
        'DC' => __( 'District Of Columbia', 'wpuf-pro' ),
        'FL' => __( 'Florida', 'wpuf-pro' ),
        'GA' => _x( 'Georgia', 'US state of Georgia', 'wpuf-pro' ),
        'HI' => __( 'Hawaii', 'wpuf-pro' ),
        'ID' => __( 'Idaho', 'wpuf-pro' ),
        'IL' => __( 'Illinois', 'wpuf-pro' ),
        'IN' => __( 'Indiana', 'wpuf-pro' ),
        'IA' => __( 'Iowa', 'wpuf-pro' ),
        'KS' => __( 'Kansas', 'wpuf-pro' ),
        'KY' => __( 'Kentucky', 'wpuf-pro' ),
        'LA' => __( 'Louisiana', 'wpuf-pro' ),
        'ME' => __( 'Maine', 'wpuf-pro' ),
        'MD' => __( 'Maryland', 'wpuf-pro' ),
        'MA' => __( 'Massachusetts', 'wpuf-pro' ),
        'MI' => __( 'Michigan', 'wpuf-pro' ),
        'MN' => __( 'Minnesota', 'wpuf-pro' ),
        'MS' => __( 'Mississippi', 'wpuf-pro' ),
        'MO' => __( 'Missouri', 'wpuf-pro' ),
        'MT' => __( 'Montana', 'wpuf-pro' ),
        'NE' => __( 'Nebraska', 'wpuf-pro' ),
        'NV' => __( 'Nevada', 'wpuf-pro' ),
        'NH' => __( 'New Hampshire', 'wpuf-pro' ),
        'NJ' => __( 'New Jersey', 'wpuf-pro' ),
        'NM' => __( 'New Mexico', 'wpuf-pro' ),
        'NY' => __( 'New York', 'wpuf-pro' ),
        'NC' => __( 'North Carolina', 'wpuf-pro' ),
        'ND' => __( 'North Dakota', 'wpuf-pro' ),
        'OH' => __( 'Ohio', 'wpuf-pro' ),
        'OK' => __( 'Oklahoma', 'wpuf-pro' ),
        'OR' => __( 'Oregon', 'wpuf-pro' ),
        'PA' => __( 'Pennsylvania', 'wpuf-pro' ),
        'RI' => __( 'Rhode Island', 'wpuf-pro' ),
        'SC' => __( 'South Carolina', 'wpuf-pro' ),
        'SD' => __( 'South Dakota', 'wpuf-pro' ),
        'TN' => __( 'Tennessee', 'wpuf-pro' ),
        'TX' => __( 'Texas', 'wpuf-pro' ),
        'UT' => __( 'Utah', 'wpuf-pro' ),
        'VT' => __( 'Vermont', 'wpuf-pro' ),
        'VA' => __( 'Virginia', 'wpuf-pro' ),
        'WA' => __( 'Washington', 'wpuf-pro' ),
        'WV' => __( 'West Virginia', 'wpuf-pro' ),
        'WI' => __( 'Wisconsin', 'wpuf-pro' ),
        'WY' => __( 'Wyoming', 'wpuf-pro' ),
        'AA' => __( 'Armed Forces (AA)', 'wpuf-pro' ),
        'AE' => __( 'Armed Forces (AE)', 'wpuf-pro' ),
        'AP' => __( 'Armed Forces (AP)', 'wpuf-pro' ),
    ],
    'VN' => [ // Vietnam provinces.
        'VN-01' => __( 'Hà Nội', 'wpuf-pro' ),
        'VN-02' => __( 'Hà Giang', 'wpuf-pro' ),
        'VN-03' => __( 'Cao Bằng', 'wpuf-pro' ),
        'VN-04' => __( 'Bắc Kạn', 'wpuf-pro' ),
        'VN-05' => __( 'Tuyên Quang', 'wpuf-pro' ),
        'VN-06' => __( 'Lào Cai', 'wpuf-pro' ),
        'VN-07' => __( 'Điện Biên', 'wpuf-pro' ),
        'VN-08' => __( 'Hà Giang', 'wpuf-pro' ),
        'VN-09' => __( 'Cao Bằng', 'wpuf-pro' ),
    ],
    'YT' => [ // Mayotte districts.
        'YT-01' => __( 'Mamoudzou', 'wpuf-pro' ),
        'YT-02' => __( 'Dzaoudzi', 'wpuf-pro' ),
    ],
    'ZA' => [ // South African states.
        'EC'  => __( 'Eastern Cape', 'wpuf-pro' ),
        'FS'  => __( 'Free State', 'wpuf-pro' ),
        'GP'  => __( 'Gauteng', 'wpuf-pro' ),
        'KZN' => __( 'KwaZulu-Natal', 'wpuf-pro' ),
        'LP'  => __( 'Limpopo', 'wpuf-pro' ),
        'MP'  => __( 'Mpumalanga', 'wpuf-pro' ),
        'NC'  => __( 'Northern Cape', 'wpuf-pro' ),
        'NW'  => __( 'North West', 'wpuf-pro' ),
        'WC'  => __( 'Western Cape', 'wpuf-pro' ),
    ],
    'ZM' => [ // Zambia's Provinces. Ref: https://en.wikipedia.org/wiki/ISO_3166-2:ZM.
        'ZM-01' => __( 'Western', 'wpuf-pro' ),
        'ZM-02' => __( 'Central', 'wpuf-pro' ),
        'ZM-03' => __( 'Eastern', 'wpuf-pro' ),
        'ZM-04' => __( 'Luapula', 'wpuf-pro' ),
        'ZM-05' => __( 'Northern', 'wpuf-pro' ),
        'ZM-06' => __( 'North-Western', 'wpuf-pro' ),
        'ZM-07' => __( 'Southern', 'wpuf-pro' ),
        'ZM-08' => __( 'Copperbelt', 'wpuf-pro' ),
        'ZM-09' => __( 'Lusaka', 'wpuf-pro' ),
        'ZM-10' => __( 'Muchinga', 'wpuf-pro' ),
    ],
];
