<?php
    global $post;

    $image_url     = WPUF_QR_DIR . '/images/';
    $form_settings = wpuf_get_form_settings( $post->ID );
    $alt_text      = isset( $form_settings['alt_text'] ) ? $form_settings['alt_text'] : 'QR Code';
    $size          = isset( $form_settings['size'] ) ? absint( $form_settings['size'] ) : 200;
    $qrcolor       = isset( $form_settings['qrcolor'] ) ? $form_settings['qrcolor'] : '#000000';
    $bgcolor       = isset( $form_settings['bgcolor'] ) ? $form_settings['bgcolor'] : '#ffffff';
    $margin        = isset( $form_settings['margin'] ) ? absint( $form_settings['margin'] ) : 4;
    $format        = isset( $form_settings['format'] ) ? absint( $form_settings['format'] ) : 'png';
?>

<div id="wpuf-metabox-qr-code" class="group">
    <div class="align_left">
        <h2><?php _e( 'Settings', 'wpuf-pro' ); ?></h2>
        <form method="post" action="">
            <table class="form-table">
                <tr>
                    <th scope="row">
                        <label for="wpuf_settings[alt_text]">
                            <?php _e( 'Default alternative text', 'wpuf-pro' ); ?>
                        </label>
                    </th>
                    <td>
                        <input type="text" name="wpuf_settings[alt_text]" value="<?php echo esc_attr( $alt_text ); ?>" id="wpuf_settings[alt_text]" />
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="wpuf_settings[size]">
                            <?php _e( 'Default size (px)', 'wpuf-pro' ); ?>
                        </label>
                    </th>
                    <td>
                        <input type="text" name="wpuf_settings[size]" value="<?php echo esc_attr( $size ); ?>" id="wpuf_settings[size]" />
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="wpuf_settings[qrcolor]">
                            <?php _e( 'QR color', 'wpuf-pro' ); ?>
                        </label>
                    </th>
                    <td>
                        <input type="color" name="wpuf_settings[qrcolor]" value="<?php echo esc_attr( $qrcolor ); ?>" id="wpuf_settings[qrcolor]" />
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="wpuf_settings[bgcolor]">
                            <?php _e( 'Background color', 'wpuf-pro' ); ?>
                        </label>
                    </th>
                    <td>
                        <input type="color" name="wpuf_settings[bgcolor]" value="<?php echo esc_attr( $bgcolor ); ?>" id="wpuf_settings[bgcolor]" />
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="wpuf_settings[margin]">
                            <?php _e( 'Margin (blocks)', 'wpuf-pro' ); ?>
                        </label>
                    </th>
                    <td>
                        <input type="number" name="wpuf_settings[margin]" value="<?php echo esc_attr( $margin ); ?>" id="wpuf_settings[margin]" />
                    </td>
                </tr>
                <tr>
                    <th scope="row">
                        <label for="wpuf_settings[format]">
                            <?php _e( 'Format', 'wpuf-pro' ); ?>
                        </label>
                    </th>
                    <td>
                        <select name="wpuf_settings[format]" id="wpuf_settings[format]">
                            <option <?php selected( 'png', $format ); ?> value="png">PNG</option>
                            <option <?php selected( 'svg', $format ); ?> value="svg">SVG</option>
                        </select>
                    </td>
                </tr>
            </table>

            <br/>

        </form>
    </div>
    <div class="clearfix"></div>
</div>
