// User Bio Block Registration
// Registers the WPUF User Bio inner block
import { __ } from '@wordpress/i18n';
import Edit from './edit';
import Save from './save';
import metadata from './block.json';

import './style.css';

const { name } = metadata;
export { metadata, name };

export const settings = {
    ...metadata,
    title: __('User Bio', 'wpuf-pro'),
    description: metadata.description,
    icon: 
    <svg width="18" height="22" viewBox="0 0 18 22" fill="#fff" xmlns="http://www.w3.org/2000/svg">
        <path fill="#fff" d="M12.7501 5.00684C12.7501 7.0779 11.0712 8.75684 9.00009 8.75684C6.92902 8.75684 5.25009 7.0779 5.25009 5.00684C5.25009 2.93577 6.92902 1.25684 9.00009 1.25684C11.0712 1.25684 12.7501 2.93577 12.7501 5.00684Z" stroke="#059669" strokeWidth="1.5" strokeLinecap="round" strokeLinejoin="round"/>
        <path fill="#fff" d="M1.50122 19.1251C1.57153 15.0437 4.90196 11.7568 9.00009 11.7568C13.0983 11.7568 16.4288 15.0439 16.499 19.1254C14.2162 20.1729 11.6765 20.7568 9.00041 20.7568C6.32408 20.7568 3.78418 20.1727 1.50122 19.1251Z" stroke="#059669" strokeWidth="1.5" strokeLinecap="round" strokeLinejoin="round"/>
    </svg>,
    category: metadata.category,
    edit: Edit,
    save: Save,
};
