/**
 * WordPress dependencies
 */
import { __ } from '@wordpress/i18n';

// Sorting Fields Preview Component
function SortingFieldsPreview({ enabled = true, orderby, order }) {
	// Note: enabled prop is kept for backward compatibility but not used
	// The parent component now controls when this component is rendered

	// Get orderby options for display
	const getOrderbyOptions = () => {
		// Core fields
		const coreFields = [
			{ value: 'id', label: __('User ID', 'wpuf-pro') },
			{ value: 'user_login', label: __('Username', 'wpuf-pro') },
			{ value: 'user_email', label: __('Email', 'wpuf-pro') },
			{ value: 'display_name', label: __('Display Name', 'wpuf-pro') },
			{ value: 'user_registered', label: __('Registration Date', 'wpuf-pro') },
		];

		// Add usermeta keys if available
		const metaFields = [];
		const metaKeys = window.wpufUserDirectory?.metaKeys || [];
		if (Array.isArray(metaKeys)) {
			metaKeys.forEach(key => {
				metaFields.push({
					value: key,
					label: key.replace(/_/g, ' ').replace(/\b\w/g, l => l.toUpperCase())
				});
			});
		}

		return [...coreFields, ...metaFields];
	};

	// Get order options for display
	const getOrderOptions = () => {
		return [
			{ value: 'asc', label: __('Ascending (A-Z)', 'wpuf-pro') },
			{ value: 'desc', label: __('Descending (Z-A)', 'wpuf-pro') },
		];
	};

	// Parse orderby string to array for display
	const orderbyArray = orderby ? orderby.split(',').map(o => o.trim()).filter(o => o) : ['id'];
	const currentOrderby = orderbyArray[0] || 'id';
	const currentOrder = order || 'desc';

	// Get display labels
	const orderbyOptions = getOrderbyOptions();
	const orderOptions = getOrderOptions();
	
	const currentOrderbyLabel = orderbyOptions.find(opt => opt.value === currentOrderby)?.label || __('User ID', 'wpuf-pro');
	const currentOrderLabel = orderOptions.find(opt => opt.value === currentOrder)?.label || __('Descending (Z-A)', 'wpuf-pro');

	return (
		<div className="wpuf-sorting-preview">
			<div className="wpuf-mt-2 wpuf-grid wpuf-grid-cols-1 md:wpuf-grid-cols-2 wpuf-gap-3">
				{/* Sort By Dropdown */}
				<div className="wpuf-relative">
					<select
						disabled
						className="wpuf-block wpuf-w-full wpuf-rounded-md wpuf-bg-white wpuf-py-1.5 wpuf-pl-3 wpuf-pr-8 wpuf-text-base wpuf-text-gray-900 wpuf-outline wpuf-outline-1 -wpuf-outline-offset-1 wpuf-outline-gray-300 focus:wpuf-outline focus:wpuf-outline-2 focus:-wpuf-outline-offset-2 focus:wpuf-outline-indigo-600 sm:wpuf-text-sm/6"
						value={currentOrderby}
					>
						{orderbyOptions.map((option) => (
							<option key={option.value} value={option.value}>
								{option.label}
							</option>
						))}
					</select>
				</div>

				{/* Sort Order Dropdown */}
				<div className="wpuf-relative">
					<select
						disabled
						className="wpuf-block wpuf-w-full wpuf-rounded-md wpuf-bg-white wpuf-py-1.5 wpuf-pl-3 wpuf-pr-8 wpuf-text-base wpuf-text-gray-900 wpuf-outline wpuf-outline-1 -wpuf-outline-offset-1 wpuf-outline-gray-300 focus:wpuf-outline focus:wpuf-outline-2 focus:-wpuf-outline-offset-2 focus:wpuf-outline-indigo-600 sm:wpuf-text-sm/6"
						value={currentOrder}
					>
						{orderOptions.map((option) => (
							<option key={option.value} value={option.value}>
								{option.label}
							</option>
						))}
					</select>
				</div>
			</div>
		</div>
	);
}

export default SortingFieldsPreview; 