// User Files Block Registration
// Registers the WPUF User Files inner block

import { __ } from '@wordpress/i18n';

import Edit from './edit';
import Save from './save';
import metadata from './block.json';

import './style.css';

const { name } = metadata;
export { metadata, name };

export const settings = {
    ...metadata,
    title: __('User Files', 'wpuf-pro'),
    description: metadata.description,
    icon: 
    <svg width="18" height="18" viewBox="0 0 18 18" xmlns="http://www.w3.org/2000/svg">
        <path d="M12 2H4C3.45 2 3 2.45 3 3V15C3 15.55 3.45 16 4 16H14C14.55 16 15 15.55 15 15V6L12 2Z" fill="#059669"/>
        <path d="M12 2V6H15" fill="#059669"/>
        <path d="M6 8H12" stroke="#fff" strokeWidth="1.5" strokeLinecap="round"/>
        <path d="M6 10H12" stroke="#fff" strokeWidth="1.5" strokeLinecap="round"/>
        <path d="M6 12H10" stroke="#fff" strokeWidth="1.5" strokeLinecap="round"/>
    </svg>,
    category: metadata.category,
    edit: Edit,
    save: Save,
};
