import { __ } from '@wordpress/i18n';
import React from 'react';

const DirectorySuccess = ( { onClose } ) => (
    <div className="wpuf-flex wpuf-justify-center wpuf-items-center wpuf-min-h-[600px]">
        <div className="wpuf-flex wpuf-flex-col wpuf-items-center wpuf-justify-center wpuf-max-w-[730px] wpuf-mx-auto wpuf-px-4">
            <img src={wpuf_ud.asset_url + '/images/confetti.png'} alt={__('Celebration', 'wpuf-pro')} />
            <h2 className="wpuf-font-normal wpuf-text-gray-900 wpuf-text-[40px] wpuf-leading-[54px] wpuf-m-0 wpuf-mt-9 wpuf-text-center">
                {__('Congrats! You\'ve successfully setup a new Directory', 'wpuf-pro')}
            </h2>
            <h3 className="wpuf-text-3xl wpuf-leading-9 wpuf-font-normal wpuf-m-0 wpuf-mt-10 wpuf-text-center">
                {__('Take full control with with Gutenberg!', 'wpuf-pro')}
            </h3>
            <p className="wpuf-text-gray-500 wpuf-text-sm wpuf-font-normal wpuf-m-0 wpuf-mt-4 wpuf-text-center">
                {__('Customize your User Directory and Profile with ease using our highly flexible Gutenberg blocks. Unlock advanced layouts, dynamic filters, and role-based visibility all directly in the block editor!', 'wpuf-pro')}
            </p>
            <a
                href="https://wedevs.com/docs/wp-user-frontend-pro/modules/user-listing-profile/"
                target="_blank"
                className="wpuf-btn-primary wpuf-flex wpuf-items-center wpuf-mt-12"
                onClick={onClose}
            >
                {__('Learn More', 'wpuf-pro')}

                <span className="wpuf-ml-3">
                    <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M0.75 13.25L13.25 0.75M13.25 0.75L3.875 0.75M13.25 0.75V10.125" stroke="white" strokeWidth="1.5" strokeLinecap="round" strokeLinejoin="round"/>
                    </svg>
                </span>
            </a>
            <img
                src={wpuf_ud.asset_url + '/images/gutenberg-example.svg'}
                alt={__('Gutenberg Block Example', 'wpuf-pro')}
                className="wpuf-rounded wpuf-mt-12"
                style={{ maxWidth: '100%', height: 'auto' }}
            />
            <a
                className="wpuf-text-gray-700 wpuf-text-sm wpuf-leading-5 wpuf-font-normal wpuf-mt-10 wpuf-px-4 wpuf-py-3 wpuf-flex wpuf-items-center wpuf-justify-between wpuf-border wpuf-border-gray-300 wpuf-shadow-sm wpuf-w-full wpuf-rounded-[6px]"
                onClick={onClose}
                href="#">
                <span>
                    {__('Go to Directory List Page', 'wpuf-pro')}
                </span>
                <span>
                    <svg width="18" height="14" viewBox="0 0 18 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M10.25 0.75L16.5 7M16.5 7L10.25 13.25M16.5 7H1.5" stroke="#059669" strokeWidth="1.5" strokeLinecap="round" strokeLinejoin="round"/>
                    </svg>
                </span>
            </a>
        </div>
    </div>
);

export default DirectorySuccess;
