<?php
/**
 * Block template for user directory layout-6 (compact style)
 *
 * Available variables:
 * @var array $users Array of WP_User objects
 * @var array $attributes Block attributes
 * @var array $pagination Pagination data
 * @var string $layout Layout name
 * @var string $context Rendering context ('block' or 'shortcode')
 *
 * @since 4.2.0
 */

// Ensure we have the required variables
$users = $users ?? [];
$attributes = $attributes ?? [];
$pagination = $pagination ?? [];
$layout = $layout ?? 'layout-6';
$context = $context ?? 'block';

// Extract block-specific attributes
$enable_search = $attributes['enable_search'] ?? true;
$search_placeholder = $attributes['search_placeholder'] ?? __('Search Users', 'wpuf-pro');
$block_id = $attributes['blockId'] ?? uniqid('wpuf-ud-');
$page_id = get_the_ID();

// Set default columns for block rendering
$columns = ['name', 'bio', 'email'];

// Get avatar size from attributes or use default
$avatar_size = $attributes['avatarSize'] ?? 48;

// Include search field if enabled
if ($enable_search) {
    include // user-lists template removed
}
?>

<div class="wpuf-user-listing" data-block-id="<?php echo esc_attr($block_id); ?>" data-page-id="<?php echo esc_attr($page_id); ?>" data-layout="<?php echo esc_attr($layout); ?>">
    <div class="!wpuf-my-8">
        <?php if ($enable_search): ?>
            <div class="wpuf-search-container">
                <div class="wpuf-flex wpuf-items-center wpuf-bg-white wpuf-rounded-sm wpuf-shadow-sm wpuf-border wpuf-border-gray-200 wpuf-px-4 wpuf-max-w-md wpuf-ud-search-wrapper"
                     data-block-id="<?php echo esc_attr($block_id); ?>"
                     data-page-id="<?php echo esc_attr($page_id); ?>">
                    <svg class="wpuf-w-5 wpuf-h-5 wpuf-text-gray-400" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24" aria-hidden="true">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M21 21l-4.35-4.35m0 0A7.5 7.5 0 104.5 4.5a7.5 7.5 0 0012.15 12.15z"/>
                    </svg>
                    <input type="text"
                           placeholder="<?php echo esc_attr($search_placeholder); ?>"
                           class="wpuf-ud-search-input wpuf-ml-3 wpuf-py-3 wpuf-bg-transparent wpuf-border-0 wpuf-w-full wpuf-text-gray-900 wpuf-placeholder-gray-400 focus:wpuf-outline-none"
                           autocomplete="off"
                           aria-label="<?php esc_attr_e( 'Search users', 'wpuf-pro' ); ?>" />
                </div>
            </div>
        <?php endif; ?>
    </div>

    <div class="wpuf-ud-list wpuf-ud-list-layout-6 wpuf-flow-root">
        <?php if (!empty($users)): ?>
            <ul role="list" class="wpuf-mx-auto wpuf-mt-4 wpuf-grid wpuf-max-w-2xl wpuf-grid-cols-1 wpuf-gap-x-6 wpuf-gap-y-20 sm:wpuf-grid-cols-2 lg:wpuf-max-w-4xl lg:wpuf-gap-x-8 xl:wpuf-max-w-none">
                <?php foreach ($users as $user): ?>
                    <?php
                    // Include the row template with proper variables
                    $row_template = // user-lists template removed
                    if (file_exists($row_template)) {
                        include $row_template;
                    }
                    ?>
                <?php endforeach; ?>
            </ul>
        <?php else: ?>
            <div class="wpuf-px-6 wpuf-py-24 sm:wpuf-px-6 sm:wpuf-py-32 lg:wpuf-px-8">
                <div class="wpuf-mx-auto wpuf-max-w-2xl wpuf-text-center">
                    <h2 class="text-balance wpuf-text-4xl wpuf-font-semibold wpuf-tracking-tight wpuf-text-gray-900 sm:wpuf-text-5xl">
                        <?php esc_html_e('No users found.', 'wpuf-pro'); ?>
                    </h2>
                </div>
            </div>
        <?php endif; ?>
    </div>

    <?php if (!empty($pagination) && $pagination['total_pages'] > 1): ?>
        <div class="wpuf-ud-pagination">
            <?php include // user-lists template removed
        </div>
    <?php endif; ?>
</div>
