<?php
/**
 * User Profile Layout 1 - Tabbed Interface
 *
 * @since 4.2.0
 *
 * Available variables:
 * @var array $template_data Complete data including user info and settings
 * @var array $user User data array
 */

// Prevent direct access
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Extract data
$user = $template_data['user'];
$show_avatar = ! empty( $template_data['show_avatar'] );
$enable_tabs = ! empty( $template_data['enable_tabs'] );
$default_tabs = ! empty( $template_data['default_tabs'] ) ? $template_data['default_tabs'] : [ 'about' ];
$default_active_tab = ! empty( $template_data['default_active_tab'] ) ? $template_data['default_active_tab'] : 'about';
$avatar_size = ! empty( $template_data['avatar_size'] ) ? $template_data['avatar_size'] : 'thumbnail';

// Get avatar URL
$avatar_sizes = [
    'thumbnail' => 150,
    'medium' => 300,
    'large' => 600
];
$size = $avatar_sizes[ $avatar_size ] ?? 150;
$avatar_url = $user['avatar_urls'][ $size ] ?? $user['avatar_urls']['96'] ?? '';

?>

<!-- Profile Header -->
<div class="wpuf-profile-header">
    <div class="wpuf-profile-avatar-section">
        <?php if ( $show_avatar && $avatar_url ) : ?>
            <div class="wpuf-profile-avatar">
                <img src="<?php echo esc_url( $avatar_url ); ?>"
                     alt="<?php echo esc_attr( $user['name'] ?: $user['username'] ?: __( 'User Avatar', 'wpuf-pro' ) ); ?>"
                     class="wpuf-avatar-image" />
            </div>
        <?php endif; ?>

        <div class="wpuf-profile-basic-info">
            <h2 class="wpuf-profile-name">
                <?php echo esc_html( $user['name'] ?: $user['username'] ?: __( 'Unknown User', 'wpuf-pro' ) ); ?>
            </h2>

            <?php if ( $user['email'] ) : ?>
                <div class="wpuf-profile-email"><?php echo esc_html( $user['email'] ); ?></div>
            <?php endif; ?>

            <?php if ( $user['url'] ) : ?>
                <div class="wpuf-profile-website">
                    <a href="<?php echo esc_url( $user['url'] ); ?>" target="_blank" rel="noopener noreferrer">
                        <?php echo esc_html( $user['url'] ); ?>
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Tabs Section -->
<?php if ( $enable_tabs && ! empty( $default_tabs ) ) : ?>
    <div class="wpuf-profile-tabs">
        <!-- Tab Navigation -->
        <div class="wpuf-tab-nav">
            <?php foreach ( $default_tabs as $tab ) : ?>
                <?php if ( in_array( $tab, [ 'about', 'posts', 'comments' ] ) ) : ?>
                    <button class="wpuf-tab-button <?php echo $tab === $default_active_tab ? 'active' : ''; ?>"
                            data-tab="<?php echo esc_attr( $tab ); ?>">
                        <?php
                        switch ( $tab ) {
                            case 'about':
                                esc_html_e( 'About', 'wpuf-pro' );
                                break;
                            case 'posts':
                                esc_html_e( 'Posts', 'wpuf-pro' );
                                break;
                            case 'comments':
                                esc_html_e( 'Comments', 'wpuf-pro' );
                                break;
                        }
                        ?>
                    </button>
                <?php endif; ?>
            <?php endforeach; ?>
        </div>

        <!-- Tab Content -->
        <div class="wpuf-tab-content">
            <!-- About Tab -->
            <div class="wpuf-tab-content-about" style="<?php echo $default_active_tab !== 'about' ? 'display: none;' : ''; ?>">
                <?php if ( ! empty( $template_data['show_bio'] ) && $user['description'] ) : ?>
                    <div class="wpuf-biography">
                        <h4><?php esc_html_e( 'Biography', 'wpuf-pro' ); ?></h4>
                        <div class="wpuf-bio-text">
                            <p><?php echo esc_html( $user['description'] ); ?></p>
                        </div>
                    </div>
                <?php endif; ?>

                <!-- Profile Fields -->
                <?php if ( ! empty( $template_data['profile_fields'] ) ) : ?>
                    <div class="wpuf-profile-fields">
                        <?php foreach ( $template_data['profile_fields'] as $field ) : ?>
                            <?php
                            $value = '';
                            switch ( $field ) {
                                case 'username':
                                    $value = $user['username'];
                                    break;
                                case 'display_name':
                                    $value = $user['name'];
                                    break;
                                case 'first_name':
                                    $value = $user['first_name'];
                                    break;
                                case 'last_name':
                                    $value = $user['last_name'];
                                    break;
                                case 'email':
                                    $value = $user['email'];
                                    break;
                                case 'website':
                                    $value = $user['url'];
                                    break;
                            }
                            if ( $value ) :
                            ?>
                                <div class="wpuf-profile-field">
                                    <strong><?php echo esc_html( ucwords( str_replace( '_', ' ', $field ) ) ); ?>:</strong>
                                    <span><?php echo esc_html( $value ); ?></span>
                                </div>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>

                <!-- Custom Fields -->
                <?php if ( ! empty( $template_data['custom_fields'] ) ) : ?>
                    <div class="wpuf-custom-fields">
                        <h4><?php esc_html_e( 'Additional Information', 'wpuf-pro' ); ?></h4>
                        <?php foreach ( $template_data['custom_fields'] as $field ) : ?>
                            <?php if ( ! empty( $user['meta'][ $field ] ) ) : ?>
                                <div class="wpuf-custom-field">
                                    <strong><?php echo esc_html( ucwords( str_replace( '_', ' ', $field ) ) ); ?>:</strong>
                                    <span><?php echo esc_html( $user['meta'][ $field ] ); ?></span>
                                </div>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Posts Tab -->
            <?php if ( in_array( 'posts', $default_tabs ) ) : ?>
                <div class="wpuf-tab-content-posts"
                     data-load-content="posts"
                     style="<?php echo $default_active_tab !== 'posts' ? 'display: none;' : ''; ?>">
                    <div class="wpuf-loading">
                        <span class="dashicons dashicons-update"></span>
                        <?php esc_html_e( 'Loading posts...', 'wpuf-pro' ); ?>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Comments Tab -->
            <?php if ( in_array( 'comments', $default_tabs ) ) : ?>
                <div class="wpuf-tab-content-comments"
                     data-load-content="comments"
                     style="<?php echo $default_active_tab !== 'comments' ? 'display: none;' : ''; ?>">
                    <div class="wpuf-loading">
                        <span class="dashicons dashicons-update"></span>
                        <?php esc_html_e( 'Loading comments...', 'wpuf-pro' ); ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php else : ?>
    <!-- No tabs - show about content directly -->
    <div class="wpuf-profile-content">
        <?php if ( ! empty( $template_data['show_bio'] ) && $user['description'] ) : ?>
            <div class="wpuf-biography">
                <h4><?php esc_html_e( 'Biography', 'wpuf-pro' ); ?></h4>
                <div class="wpuf-bio-text">
                    <p><?php echo esc_html( $user['description'] ); ?></p>
                </div>
            </div>
        <?php endif; ?>

        <!-- Profile Fields -->
        <?php if ( ! empty( $template_data['profile_fields'] ) ) : ?>
            <div class="wpuf-profile-fields">
                <?php foreach ( $template_data['profile_fields'] as $field ) : ?>
                    <?php
                    $value = '';
                    switch ( $field ) {
                        case 'username':
                            $value = $user['username'];
                            break;
                        case 'display_name':
                            $value = $user['name'];
                            break;
                        case 'first_name':
                            $value = $user['first_name'];
                            break;
                        case 'last_name':
                            $value = $user['last_name'];
                            break;
                        case 'email':
                            $value = $user['email'];
                            break;
                        case 'website':
                            $value = $user['url'];
                            break;
                    }
                    if ( $value ) :
                    ?>
                        <div class="wpuf-profile-field">
                            <strong><?php echo esc_html( ucwords( str_replace( '_', ' ', $field ) ) ); ?>:</strong>
                            <span><?php echo esc_html( $value ); ?></span>
                        </div>
                    <?php endif; ?>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
<?php endif; ?>
