<?php

class Gravity_Flow_Checklist_Block {

	public function init() {
		// Only load if Gutenberg is available.
		if ( ! function_exists( 'register_block_type' ) ) {
			return;
		}

		register_block_type( 'gravityflow/checklists', array(
			'attributes'      => array(
				'checklist'  => array(
					'type'    => 'string',
					'default' => '',
				),
				'theme'      => array(
					'type'    => 'string',
					'default' => '',
				),
				'singlePage' => array(
					'type'    => 'boolean',
					'default' => false,
				),
			),
			'render_callback' => array( $this, 'get_rendered_markup' ),
		) );
	}

	public function get_rendered_markup( $attributes, $content ) {
		$checklist        = isset( $attributes['checklist'] ) ? sprintf( 'checklist="%s"', $attributes['checklist'] ) : null;
		$theme            = isset( $attributes['theme'] ) ? sprintf( 'theme="%s"', $attributes['theme'] ) : null;
		$single_page      = isset( $attributes['singlePage'] ) ? sprintf( 'single_page="%s"', (bool) $attributes['singlePage'] ? 'true' : 'false' ) : null;
		$shortcode_markup = sprintf( '[gravityflow page="checklists" %s %s %s]', $checklist, $theme, $single_page );
		$before = '';
		$after = '';

		if ( defined('REST_REQUEST') && REST_REQUEST ) {
			$before = '<div class="gravityflow_checklist_preview_wrapper"><div class="gravityflow_checklist_overlay"></div>';
			$after = '</div>';
		}

		return $before . do_shortcode( $shortcode_markup ) . $after;
	}

}