<?php

/**
 * AI Summarizer Plugin
 *
 * Plugin Name: AI Summarizer
 * Plugin URI: https://sobold.co.uk/
 * Description: A WordPress plugin that integrates with AWS Bedrock to generate AI-powered summaries of post content.
 * Version: 1.0.1
 * Author: SoBold
 * Author URI: https://sobold.co.uk/team/
 * License: GPL-2.0-or-later
 * Requires PHP: 8.1
 * Text Domain: ai-summarizer
 *
 * @category WordPress
 * @package  AI_Summarizer
 * @author   SoBold
 * @license  GPL-2.0-or-later https://www.gnu.org/licenses/gpl-2.0.html
 * @link     https://sobold.co.uk/
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

require_once plugin_dir_path(__FILE__) . 'vendor/autoload.php';
require_once plugin_dir_path(__FILE__) . 'includes/GlobalFunctions.php';

/**
 * Checks PHP version compatibility.
 *
 * @return void
 */
function ai_summarizer_CheckPhpVersion()
{
    if (version_compare(PHP_VERSION, '8.1', '<')) {
        // Display an admin notice if the PHP version is below 8.1
        add_action('admin_notices', 'ai_summarizerPhpVersionNotice');

        // Prevent plugin activation
        deactivate_plugins(plugin_basename(__FILE__));
    }
}

/**
 * Displays an admin notice for PHP version compatibility.
 *
 * @return void
 */
function ai_summarizer_PhpVersionNotice()
{
?>
    <div class="notice notice-error">
        <p>
            <?php esc_html_e(
                'AI Summarizer Plugin requires PHP 8.1 or higher. Please update your PHP version to use this plugin.',
                'ai-summarizer'
            ); ?>
        </p>
    </div>
<?php
}

// Run PHP version check on activation
register_activation_hook(
    __FILE__,
    'ai_summarizer_CheckPhpVersion'
);

// Register the activation hook for other plugin setup, only if PHP version is compatible
register_activation_hook(
    __FILE__,
    function () {
        if (version_compare(PHP_VERSION, '8.1', '>=')) {
            AISummarizer\AISummarizer::AISummarizer_pluginActivation();
        }
    }
);

register_deactivation_hook(
    __FILE__,
    [
        'AISummarizer\AISummarizer',
        'AISummarizer_pluginDeactivation'
    ]
);

// Initialize the plugin if the PHP version is compatible
add_action(
    'plugins_loaded',
    function () {
        if (version_compare(PHP_VERSION, '8.1', '>=')) {
            \AISummarizer\AISummarizer::AISummarizer_init();
        }
    }
);
