<?php


/**
 * AiModelInterface
 *
 * Interface for AI models used in summarization.
 *
 * @category Plugin
 * @package  AI_Summarizer
 */

namespace AISummarizer\Interfaces;

if (! defined('ABSPATH')) exit; // Exit if accessed directly

interface AiModelInterface
{
    /**
     * Summarizes the given content.
     *
     * @param string $content The content to summarize.
     *
     * @return string The summarized content.
     */
    public function summarize(string $content): string;
}
