=== AI Summarizer ===

-   Contributors: sobold, santoshsobold
-   Tags: AI, Summarization, AWS Bedrock, WordPress
-   Requires at least: 5.8
-   Tested up to: 6.7
-   Requires PHP: 8.1
-   Stable tag: 1.0.0
-   License: GPLv2 or later
-   License URI: https://www.gnu.org/licenses/gpl-2.0.html
    A powerful WordPress plugin that generates AI-powered summaries for your posts using AWS Bedrock.

## Description

The **AI Summarizer** Plugin by **SoBold** is a powerful WordPress tool that leverages AWS Bedrock to generate AI-powered summaries for WordPress post content. With just a few settings, users can quickly Summarise articles, blog posts, and other long-form content, providing concise summaries for readers. The plugin offers easy integration with the WordPress REST API, making the summarization process both seamless and efficient.

## Key features of the AI Summarizer Plugin:

-   AI-Powered Summaries: Automatically generates summaries using AWS Bedrock AI models.
-   Customizable: Supports options for selecting post types, widget visibility, and AI model settings.
-   REST API Integration: Provides REST API routes for interacting with summarization endpoints.
-   Admin Control: Configure AWS credentials and model options via AI Summariser settings.
-   ACF, Gutenberg, and WPBakery Integration: Retrieves and Summarises content from popular post editors like Advanced Custom Fields (ACF), Gutenberg, and WPBakery.
-   Custom Widget: Displays summaries in a customizable widget box on the frontend.

## Requirements

-   PHP: 8.1 or higher
-   WordPress: 5.8 or higher
-   AWS Bedrock Account: Requires AWS access and secret keys to use Bedrock for AI summarization.

## Installation

1. Download the plugin zip file and upload it via the WordPress dashboard.
2. Go to **Plugins > Add New** in your WordPress admin panel.
3. Click **Upload Plugin** and choose the `ai-summarizer.zip` file.
4. Activate the plugin from the **Plugins** menu in WordPress.
5. Configure the plugin under **AI Summarizer** by adding your `AWS Access Key`, `Secret Key`, `Region`, and `Bedrock Model ID`.

## Usage

Automatic Summarization
Once configured, the plugin will automatically generate summaries for your selected post types on click and display in backend to approval before it start displaying on front.

To customize which post types are Summarised, go to AI Summariser > Post types and select the desired post types.
A custom widget will display the summary on the frontend if enabled.

## Deactivation & Uninstall

Upon deactivation, the plugin will:

Remove all plugin-related settings and options.
Delete AI summaries stored as post metadata.

## Manual Uninstallation

To manually uninstall the plugin and remove all associated data:

Deactivate the plugin from the Plugins section in WordPress.
Optionally, delete the plugin files from your wp-content/plugins directory.

## Frequently Asked Questions

### How does the AI Summarizer plugin work?

The plugin uses AI technology to analyze the content of your posts or pages and generates a summary based on key points and context. It integrates with external AI services (e.g., AWS Bedrock) to perform this task.

### Do I need an AWS account to use this plugin?

Yes, an active AWS account with Bedrock AI services is required to generate AI summaries.

### What happens if my AWS credentials are incorrect or missing?

If your AWS credentials or Bedrock model ID are incorrect or missing, the plugin will not generate summaries and will show error notices in the WordPress admin area.

### Can I choose which posts are Summarised?

Yes, you can choose specific post types for summarization under the plugin settings in AI Summariser > Post types.

### Can I modify the generated summaries?

Currently, summaries are automatically generated based on the AI model’s output, but users with appropriate permissions can approve summaries via the REST API.

## Changelog

### 1.0.0

-   Initial release with AI-powered summarization and AWS Bedrock integration.
-   Custom widget support for displaying summaries.
-   REST API routes for summarization and summary approval.

## License

This plugin is licensed under the GPLv2 or later. Please see the LICENSE file included in the plugin for more details.

== Screenshots ==

1. Screenshot 1: Screenshot of the plugin interface
2. Screenshot 2: Screenshot of the summarization post selection
3. Screenshot 3: Screenshot of the widget setting for front side display
4. Screenshot 4: Screenshot of the meta box will be added to each post of selected post-type.
5. Screenshot 5: Screenshot of the widget
6. Screenshot 6: Screenshot of the widget
