# Display Form Entries

A WordPress plugin for displaying Gravity Forms entries on the frontend with customizable layouts and field formatting.

## Description

Display Form Entries is a lightweight plugin that allows you to display Gravity Forms entries on your WordPress frontend using shortcodes. It provides multiple display templates, field formatting, and customization options.

## Features

- **Multiple Display Templates**: List, Table, Card, and Single Entry views
- **Field Formatting**: Automatic formatting for different field types (email, URL, file uploads, etc.)
- **Shortcode Support**: Easy-to-use shortcodes for displaying entries
- **Responsive Design**: Mobile-friendly layouts
- **Customizable Styling**: CSS classes and theme override support
- **Search and Sorting**: Built-in search and sorting capabilities
- **Accessibility**: WCAG compliant with keyboard navigation support

## Requirements

- WordPress 5.0 or higher
- PHP 7.4 or higher
- Gravity Forms plugin (any version)

## Installation

1. Upload the `displayFormEntries` folder to your `/wp-content/plugins/` directory
2. Activate the plugin through the 'Plugins' menu in WordPress
3. Ensure Gravity Forms is installed and activated

## Usage

### Shortcodes

#### Display Multiple Entries
```
[dfe_entries form_id="1" template="list" limit="10"]
```

**Parameters:**
- `form_id` (required): The ID of the Gravity Form
- `template`: Display template (list, table, card, single)
- `limit`: Number of entries to display
- `offset`: Number of entries to skip
- `search`: Search term
- `sort`: Sort field (id, date_created, date_updated)
- `sort_direction`: Sort direction (ASC, DESC)
- `fields`: Comma-separated list of field IDs to display
- `hide_empty`: Hide empty fields (true/false)
- `show_labels`: Show field labels (true/false)
- `pagination`: Enable pagination (true/false)
- `container_class`: Additional CSS class

#### Display Single Entry
```
[dfe_entry entry_id="123" form_id="1"]
```

**Parameters:**
- `entry_id`: The ID of the entry to display
- `form_id`: The ID of the Gravity Form
- `fields`: Comma-separated list of field IDs to display
- `hide_empty`: Hide empty fields (true/false)
- `show_labels`: Show field labels (true/false)
- `container_class`: Additional CSS class

#### Display Single Field
```
[dfe_field field_id="1" entry_id="123" format="html" label="true"]
```

**Parameters:**
- `field_id` (required): The ID of the field to display
- `entry_id`: The ID of the entry
- `form_id`: The ID of the Gravity Form
- `format`: Output format (html, text)
- `label`: Show field label (true/false)
- `container_class`: Additional CSS class

#### Display Form Information
```
[dfe_form form_id="1" title="true"]
```

**Parameters:**
- `form_id` (required): The ID of the Gravity Form
- `title`: Show form title (true/false)

### Examples

#### Basic List View
```
[dfe_entries form_id="1" template="list" limit="5"]
```

#### Table with Specific Fields
```
[dfe_entries form_id="1" template="table" fields="1,2,3" show_labels="true"]
```

#### Card View with Search
```
[dfe_entries form_id="1" template="card" limit="6" search="keyword"]
```

#### Single Entry Detail
```
[dfe_entry entry_id="123" form_id="1" template="single"]
```

#### Display Specific Field
```
[dfe_field field_id="1" entry_id="123" label="true"]
```

## Templates

### List Template
Displays entries in a vertical list format with each entry in its own container.

### Table Template
Displays entries in a table format with headers and rows.

### Card Template
Displays entries in a grid of cards, ideal for visual content.

### Single Template
Displays a single entry in detail view with all fields.

## Field Types Supported

- **Text**: Basic text fields
- **Email**: Automatically creates mailto links
- **URL/Website**: Automatically creates clickable links
- **File Upload**: Creates download links with file names
- **Date**: Formatted date display
- **Textarea**: Preserves line breaks
- **Select/Radio**: Shows choice labels instead of values
- **Checkbox**: Handles multiple selections
- **List**: Displays list items in organized format
- **Number**: Formatted number display
- **Phone**: Basic text display
- **Address**: Formatted address display

## Customization

### CSS Classes

The plugin uses consistent CSS classes for styling:

- `.dfe-container`: Main container
- `.dfe-list`: List view container
- `.dfe-table`: Table view container
- `.dfe-cards`: Card view container
- `.dfe-single`: Single entry view container
- `.dfe-field`: Individual field container
- `.dfe-field-label`: Field label
- `.dfe-field-value`: Field value

### Theme Override

You can override plugin styles by creating CSS files in your theme:

1. Create directory: `/your-theme/displayformentries/css/`
2. Add CSS files with the same names as plugin CSS files
3. Your theme CSS will take precedence over plugin CSS

### Template Override

You can override plugin templates by creating template files in your theme:

1. Create directory: `/your-theme/displayformentries/templates/`
2. Add PHP template files with the same names as plugin templates
3. Your theme templates will take precedence over plugin templates

## Hooks and Filters

### Actions

```php
// Before rendering entries
do_action('dfe_before_entries', $entries, $form, $atts);

// After rendering entries
do_action('dfe_after_entries', $entries, $form, $atts);

// Before rendering single entry
do_action('dfe_before_single_entry', $entry, $form, $atts);

// After rendering single entry
do_action('dfe_after_single_entry', $entry, $form, $atts);
```

### Filters

```php
// Modify field value before display
add_filter('dfe_field_value', $value, $field, $entry, $format);

// Modify field label before display
add_filter('dfe_field_label', $label, $field, $entry);

// Modify field CSS class
add_filter('dfe_field_class', $class, $field, $form, $entry);

// Modify container CSS class
add_filter('dfe_container_class', $class, $atts);

// Modify reserved query arguments
add_filter('dfe/reserved_query_args', $reserved_args);
```

## JavaScript API

The plugin includes a JavaScript API for enhanced functionality:

```javascript
// Initialize plugin
DFE.init();

// Show loading state
DFE.showLoading($container);

// Show notification
DFE.showNotification('Message', 'success');

// Utility functions
DFE.utils.formatDate(dateString);
DFE.utils.formatNumber(number, decimals);
DFE.utils.escapeHtml(text);
```

## Troubleshooting

### Common Issues

1. **Plugin not working**: Ensure Gravity Forms is installed and activated
2. **No entries displayed**: Check if the form has entries and the form ID is correct
3. **Styling issues**: Check for CSS conflicts with your theme
4. **Shortcode not working**: Ensure the shortcode syntax is correct

### Debug Mode

Enable WordPress debug mode to see detailed error messages:

```php
// In wp-config.php
define('WP_DEBUG', true);
define('WP_DEBUG_LOG', true);
```

## Support

For support and documentation, please visit the plugin website or contact the developer.

## Changelog

### Version 1.0.0
- Initial release
- Basic shortcode functionality
- Multiple display templates
- Field formatting support
- Responsive design
- Accessibility features

## License

This plugin is licensed under the GPL v2 or later.

## Credits

Developed with ❤️ for the WordPress community. 