<?php
/**
 * Gutenberg Blocks for Display Form Entries plugin
 *
 * @package   DisplayFormEntries
 * @license   GPL2+
 * @author    Your Name
 * @link      https://example.com
 * @copyright Copyright 2024
 *
 * @since 1.0.0
 */

/** If this file is called directly, abort. */
if ( ! defined( 'ABSPATH' ) ) {
	die;
}

class DFE_Blocks {

	/**
	 * Initialize blocks
	 */
	public static function init() {
		add_action( 'init', array( __CLASS__, 'register_blocks' ) );
		add_action( 'enqueue_block_editor_assets', array( __CLASS__, 'enqueue_block_assets' ) );
	}

	/**
	 * Register blocks
	 */
	public static function register_blocks() {
		// Register entries block
		register_block_type( 'displayformentries/entries', array(
			'editor_script'   => 'dfe-blocks',
			'editor_style'    => 'dfe-blocks-editor',
			'style'           => 'dfe-styles',
			'render_callback' => array( 'DFE_Shortcodes', 'render_entries_block' ),
		) );
		
		// Register entry block
		register_block_type( 'displayformentries/entry', array(
			'editor_script'   => 'dfe-blocks',
			'editor_style'    => 'dfe-blocks-editor',
			'style'           => 'dfe-styles',
			'render_callback' => array( 'DFE_Shortcodes', 'render_entry_block' ),
		) );
		
		// Register form block
		register_block_type( 'displayformentries/form', array(
			'editor_script'   => 'dfe-blocks',
			'editor_style'    => 'dfe-blocks-editor',
			'style'           => 'dfe-styles',
			'render_callback' => array( 'DFE_Shortcodes', 'render_form_block' ),
		) );
	}

	/**
	 * Enqueue block assets
	 */
	public static function enqueue_block_assets() {
		// Load token multiselect control first
		wp_enqueue_script(
			'dfe-token-multiselect',
			DFE_URL . 'assets/js/token-multiselect-control.js',
			array( 'wp-element', 'wp-components', 'wp-i18n' ),
			DFE_PLUGIN_VERSION,
			true
		);

		wp_enqueue_script(
			'dfe-blocks',
			DFE_URL . 'assets/js/blocks.js',
			array( 'wp-blocks', 'wp-element', 'wp-editor', 'wp-components', 'wp-i18n', 'dfe-token-multiselect' ),
			DFE_PLUGIN_VERSION,
			true
		);

		wp_enqueue_style(
			'dfe-blocks-editor',
			DFE_URL . 'assets/css/blocks-editor.css',
			array(),
			DFE_PLUGIN_VERSION
		);

		// Localize script with form data
		wp_localize_script( 'dfe-blocks', 'dfeBlocks', array(
			'forms' => self::get_forms_for_blocks(),
			'nonce' => wp_create_nonce( 'dfe_blocks_nonce' ),
			'ajaxUrl' => admin_url( 'admin-ajax.php' ),
		) );
	}

	/**
	 * Get forms for block dropdown
	 */
	private static function get_forms_for_blocks() {
		if ( ! class_exists( 'GFAPI' ) ) {
			return array();
		}

		$forms = GFAPI::get_forms();
		$form_options = array();

		foreach ( $forms as $form ) {
			$form_options[] = array(
				'value' => $form['id'],
				'label' => $form['title'],
			);
		}

		return $form_options;
	}
} 