<?php

/** Don't load directly */
defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'easy_post_submission_admin_description_strings' ) ) {
	/**
	 * Provides description strings for the backend.
	 *
	 * This function returns an array of description strings used in the WordPress admin interface. These strings
	 * describe the plugin, its tabs, and various sections in the backend.
	 *
	 * @return array An array containing description strings for the backend.
	 */
	function easy_post_submission_admin_description_strings() {

		return [
			'title'                                => esc_html__( 'Easy Post Submission', 'easy-post-submission' ),
			'description'                          => esc_html__( 'A lightweight and user-friendly WordPress plugin designed to let users submit content from the frontend with ease. Customizable forms, file uploads, and user role restrictions. Ideal for guest posts, user-generated content, and community contributions.', 'easy-post-submission' ),
			'formTab'                              => esc_html__( 'Forms Overview', 'easy-post-submission' ),
			'formSettingTab'                       => esc_html__( 'Form Settings', 'easy-post-submission' ),
			'syncDataTab'                          => esc_html__( 'Backup and Restore', 'easy-post-submission' ),
			'createFormTitle'                      => esc_html__( 'Start Creating Your Form', 'easy-post-submission' ),
			'createFormDesc'                       => esc_html__( 'To get started, click the button and enter your desired form name.', 'easy-post-submission' ),
			'createFormInputPlaceholder'           => esc_html__( 'Enter the form ID without special characters...', 'easy-post-submission' ),
			'createFormInputRequired'              => esc_html__( 'Form title is required!', 'easy-post-submission' ),
			'submitForm'                           => esc_html__( 'Save New Form', 'easy-post-submission' ),
			'cancel'                               => esc_html__( 'Cancel', 'easy-post-submission' ),
			'addNewForm'                           => esc_html__( 'Add New Form', 'easy-post-submission' ),
			'formNotFoundTitle'                    => esc_html__( 'No Forms Found!', 'easy-post-submission' ),
			'formNotFoundDescription'              => esc_html__( 'Click here to add a new form and begin your journey.', 'easy-post-submission' ),
			'goToAddNew'                           => esc_html__( 'Go to Add New Form', 'easy-post-submission' ),
			'formListTitle'                        => esc_html__( 'Your Forms', 'easy-post-submission' ),
			'formSettings'                         => esc_html__( 'Settings', 'easy-post-submission' ),
			'delete'                               => esc_html__( 'Delete', 'easy-post-submission' ),
			'deleteFormText'                       => esc_html__( 'Are you sure you want to delete this form?', 'easy-post-submission' ),
			'deleteFormTitle'                      => esc_html__( 'Confirm Deletion', 'easy-post-submission' ),
			'currentSettingsFor'                   => esc_html__( 'Form Settings for:', 'easy-post-submission' ),
			'changeFormLabel'                      => esc_html__( 'Select a form:', 'easy-post-submission' ),
			'generalSettings'                      => esc_html__( 'General', 'easy-post-submission' ),
			'userLogin'                            => esc_html__( 'User Login', 'easy-post-submission' ),
			'formFields'                           => esc_html__( 'Form Fields', 'easy-post-submission' ),
			'userProfile'                          => esc_html__( 'User Posts Management', 'easy-post-submission' ),
			'rubySubmissionManager'                => esc_html__( 'To display the post listings to users, create a page and insert the shortcode below. Adjust the settings below to your preference.', 'easy-post-submission' ),
			'securityFields'                       => esc_html__( 'Security Fields', 'easy-post-submission' ),
			'emails'                               => esc_html__( 'Emails', 'easy-post-submission' ),
			'preview'                              => esc_html__( 'Preview', 'easy-post-submission' ),
			'saveSettings'                         => esc_html__( 'Save Settings', 'easy-post-submission' ),
			'postStatus'                           => esc_html__( 'Post Submission Status', 'easy-post-submission' ),
			'postStatusDesc'                       => esc_html__( 'Choose the status of the post after submission.', 'easy-post-submission' ),
			'urlDirection'                         => esc_html__( 'Redirect URL After Successful Submission', 'easy-post-submission' ),
			'urlDirectionDesc'                     => esc_html__( 'Redirect users to this URL after their post is successfully submitted.', 'easy-post-submission' ),
			'uniqueTitle'                          => esc_html__( 'Require Unique Post Title', 'easy-post-submission' ),
			'uniqueTitleDesc'                      => esc_html__( 'Ensure all submitted post titles are unique to avoid duplication.', 'easy-post-submission' ),
			'authorAccess'                         => esc_html__( 'Author Access', 'easy-post-submission' ),
			'authorAccessDesc'                     => esc_html__( 'Require users to log in to WordPress to view or submit forms.', 'easy-post-submission' ),
			'loginType'                            => esc_html__( 'Login Action Choice', 'easy-post-submission' ),
			'loginTypeDesc'                        => esc_html__( 'Choose whether to show a notification or redirect to the login page when a visitor accesses this page without being logged in.', 'easy-post-submission' ),
			'assignAuthor'                         => esc_html__( 'Assign Author', 'easy-post-submission' ),
			'assignAuthorDesc'                     => esc_html__( 'The author named for the post.', 'easy-post-submission' ),
			'userName'                             => esc_html__( 'User Name', 'easy-post-submission' ),
			'typeUserName'                         => esc_html__( 'Type User Name', 'easy-post-submission' ),
			'typeAnythings'                        => esc_html__( 'type anythings', 'easy-post-submission' ),
			'typeUserEmail'                        => esc_html__( 'Type User Email', 'easy-post-submission' ),
			'userNameDesc'                         => esc_html__( 'Requirement for the user name.', 'easy-post-submission' ),
			'userEmail'                            => esc_html__( 'User Email', 'easy-post-submission' ),
			'userEmailDesc'                        => esc_html__( 'Requirement for the user email.', 'easy-post-submission' ),
			'postTitle'                            => esc_html__( 'Post Title', 'easy-post-submission' ),
			'postTitleDesc'                        => esc_html__( 'Requirement for the post title.', 'easy-post-submission' ),
			'tagline'                              => esc_html__( 'Tagline', 'easy-post-submission' ),
			'taglineDesc'                          => esc_html__( 'Requirement for the tagline.', 'easy-post-submission' ),
			'editorType'                           => esc_html__( 'Post Content Editor', 'easy-post-submission' ),
			'editorTypeDesc'                       => esc_html__( 'Select the layout for the content editor: use a WYSIWYG editor for visual editing or choose raw HTML for manual input.', 'easy-post-submission' ),
			'featuredImage'                        => esc_html__( 'Featured Image', 'easy-post-submission' ),
			'featuredImageDesc'                    => esc_html__( 'Requirement for the featured image.', 'easy-post-submission' ),
			'uploadFileSizeLimit'                  => esc_html__( 'Upload File Size Limit', 'easy-post-submission' ),
			'uploadFile'                           => esc_html__( 'Upload file', 'easy-post-submission' ),
			'grecapchaLoadError'                   => esc_html__( 'Recaptcha not available', 'easy-post-submission' ),
			'validId'                              => esc_html__( 'ID is valid.', 'easy-post-submission' ),
			'validTitle'                           => esc_html__( 'Title is valid.', 'easy-post-submission' ),
			'invalidTitle'                         => esc_html__( 'Title is invalid. Please check the input.', 'easy-post-submission' ),
			'validData'                            => esc_html__( 'Data is valid.', 'easy-post-submission' ),
			'invalidData'                          => esc_html__( 'Data is invalid. Please review the information.', 'easy-post-submission' ),
			'uploadFileSizeLimitDesc'              => esc_html__( 'Maximum file upload size in KB. Set to 0 for no limit.', 'easy-post-submission' ),
			'defaultFeaturedImage'                 => esc_html__( 'Default Featured Image', 'easy-post-submission' ),
			'defaultFeaturedImageDesc'             => esc_html__( 'The default image to use if no featured image is provided.', 'easy-post-submission' ),
			'categories'                           => esc_html__( 'Categories', 'easy-post-submission' ),
			'multipleCategories'                   => esc_html__( 'Multiple Categories', 'easy-post-submission' ),
			'multipleCategoriesDesc'               => esc_html__( 'Allow the selection of multiple categories.', 'easy-post-submission' ),
			'excludeCategories'                    => esc_html__( 'Exclude Categories', 'easy-post-submission' ),
			'excludeCategoriesDesc'                => esc_html__( 'Categories that cannot be selected in this form.', 'easy-post-submission' ),
			'autoAssignCategories'                 => esc_html__( 'Auto Assign Categories', 'easy-post-submission' ),
			'autoAssignCategoriesDesc'             => esc_html__( 'Automatically assign default categories if no categories are selected during the post submission.', 'easy-post-submission' ),
			'tags'                                 => esc_html__( 'Tags', 'easy-post-submission' ),
			'multipleTags'                         => esc_html__( 'Multiple Tags', 'easy-post-submission' ),
			'multipleTagsDesc'                     => esc_html__( 'Allow the selection of multiple tags.', 'easy-post-submission' ),
			'allowAddNewTags'                      => esc_html__( 'Allow Add New Tags', 'easy-post-submission' ),
			'allowAddNewTagsDesc'                  => esc_html__( 'Allow users to add new tags.', 'easy-post-submission' ),
			'excludeTags'                          => esc_html__( 'Exclude Tags', 'easy-post-submission' ),
			'excludeTagsDesc'                      => esc_html__( 'Tags that will be excluded from the post.', 'easy-post-submission' ),
			'autoAssignTags'                       => esc_html__( 'Auto Assign Tags', 'easy-post-submission' ),
			'autoAssignTagsDesc'                   => esc_html__( 'Automatically assign default tags if no tags are selected during the post submission.', 'easy-post-submission' ),
			'customFields'                         => esc_html__( 'Custom Fields', 'easy-post-submission' ),
			'customFieldsDesc'                     => esc_html__( 'Allow users to add new custom fields.', 'easy-post-submission' ),
			'addNewField'                          => esc_html__( 'Add New Field', 'easy-post-submission' ),
			'customFieldName'                      => esc_html__( 'Custom Field Name', 'easy-post-submission' ),
			'customFieldNameDesc'                  => esc_html__( 'The name of the custom field. Please use plain text without special characters, as it will be used to set the meta key. Use underscores (_) instead of spaces.', 'easy-post-submission' ),
			'customFieldLabel'                     => esc_html__( 'Custom Field Label', 'easy-post-submission' ),
			'customFieldLabelDesc'                 => esc_html__( 'The label of the custom field.', 'easy-post-submission' ),
			'fieldType'                            => esc_html__( 'Field Type', 'easy-post-submission' ),
			'fieldTypeDesc'                        => esc_html__( 'The type of the custom field.', 'easy-post-submission' ),
			'removeField'                          => esc_html__( 'Remove Field', 'easy-post-submission' ),
			'challenge'                            => esc_html__( 'Challenge', 'easy-post-submission' ),
			'challengeDesc'                        => esc_html__( 'The user must complete the challenge before submitting the post.', 'easy-post-submission' ),
			'challengeQuestion'                    => esc_html__( 'Challenge Question', 'easy-post-submission' ),
			'challengeQuestionDesc'                => esc_html__( 'This question requires an answer from the user.', 'easy-post-submission' ),
			'challengeResponse'                    => esc_html__( 'Challenge Response', 'easy-post-submission' ),
			'challengeResponseDesc'                => esc_html__( 'Provide the correct answer to complete the challenge.', 'easy-post-submission' ),
			'recaptcha'                            => esc_html__( 'ReCaptcha', 'easy-post-submission' ),
			'recaptchaDesc'                        => esc_html__( 'Require users to complete ReCaptcha verification before submitting the post.', 'easy-post-submission' ),
			'recaptchaSiteKey'                     => esc_html__( 'ReCaptcha Site Key', 'easy-post-submission' ),
			'recaptchaSiteKeyDesc'                 => esc_html__( 'Input the ReCaptcha Site Key.', 'easy-post-submission' ),
			'recaptchaSecretKey'                   => esc_html__( 'ReCaptcha Secret Key', 'easy-post-submission' ),
			'recaptchaSecretKeyDesc'               => esc_html__( 'Input the ReCaptcha Secret Key.', 'easy-post-submission' ),
			'globalRecaptchaSettings'              => esc_html__( 'Global reCAPTCHA ver2', 'easy-post-submission' ),
			'recaptchaSiteKeyPlaceholder'          => esc_html__( 'Enter your reCAPTCHA Site Key', 'easy-post-submission' ),
			'recaptchaSecretKeyPlaceholder'        => esc_html__( 'Enter your reCAPTCHA Secret Key', 'easy-post-submission' ),
			'enableRecaptchaForForms'              => esc_html__( 'Enable for Submission Forms', 'easy-post-submission' ),
			'enableRecaptchaForFormsDesc'          => esc_html__( 'Enable reCAPTCHA verification for all submission forms by default.', 'easy-post-submission' ),
			'enableRecaptchaForLogin'              => esc_html__( 'Enable for Login', 'easy-post-submission' ),
			'enableRecaptchaForLoginDesc'          => esc_html__( 'Enable reCAPTCHA verification for the login form.', 'easy-post-submission' ),
			'enableRecaptchaForRegister'           => esc_html__( 'Enable for Registration', 'easy-post-submission' ),
			'enableRecaptchaForRegisterDesc'       => esc_html__( 'Enable reCAPTCHA verification for the registration form.', 'easy-post-submission' ),
			'adminEmail'                           => esc_html__( 'Admin Email', 'easy-post-submission' ),
			'adminEmailDesc'                       => esc_html__( 'Notify the admin via email when a post is submitted.', 'easy-post-submission' ),
			'adminEmailAddress'                    => esc_html__( 'Admin Email Address', 'easy-post-submission' ),
			'subject'                              => esc_html__( 'Subject', 'easy-post-submission' ),
			'emailSubjectDesc'                     => esc_html__( 'The subject of the email. You can use custom tags such as {{post_title}} and {{post_link}} to provide dynamic information.', 'easy-post-submission' ),
			'emailTitle'                           => esc_html__( 'Email Title', 'easy-post-submission' ),
			'emailTitleDesc'                       => esc_html__( 'The title of the email. Allow custom tags such as {{post_title}}, {{post_link}} to display support information.', 'easy-post-submission' ),
			'message'                              => esc_html__( 'Message', 'easy-post-submission' ),
			'emailMessageDesc'                     => esc_html__( 'The email content. You can use custom tags such as {{post_title}} and {{post_link}} for dynamic information.', 'easy-post-submission' ),
			'postSubmitNotification'               => esc_html__( 'Post Submit Notification', 'easy-post-submission' ),
			'postSubmitNotificationDesc'           => esc_html__( 'Allow notification to the user by email when a post is submitted.', 'easy-post-submission' ),
			'postPublishNotification'              => esc_html__( 'Post Publish Notification', 'easy-post-submission' ),
			'postPublishNotificationDesc'          => esc_html__( 'Allow notification to the user by email when a post is published.', 'easy-post-submission' ),
			'postTrashNotification'                => esc_html__( 'Post Trash Notification', 'easy-post-submission' ),
			'postTrashNotificationDesc'            => esc_html__( 'Allow notification to the user by email when a post is trashed.', 'easy-post-submission' ),
			'importSettings'                       => esc_html__( 'Import Settings', 'easy-post-submission' ),
			'import'                               => esc_html__( 'Import', 'easy-post-submission' ),
			'backupData'                           => esc_html__( 'Export Settings', 'easy-post-submission' ),
			'copy'                                 => esc_html__( 'Copy', 'easy-post-submission' ),
			'copied'                               => esc_html__( 'Copied!', 'easy-post-submission' ),
			'paste'                                => esc_html__( 'Paste From Clipboard', 'easy-post-submission' ),
			'updateSuccessful'                     => esc_html__( 'Saved Changes', 'easy-post-submission' ),
			'updateSuccessfulMessage'              => esc_html__( 'Settings have been saved successfully.', 'easy-post-submission' ),
			'ok'                                   => esc_html__( 'OK', 'easy-post-submission' ),
			'wasUpdatedSuccessfully'               => esc_html__( 'Updated successfully.', 'easy-post-submission' ),
			'restoreDataSuccessMessage'            => esc_html__( 'Submission data restored successfully.', 'easy-post-submission' ),
			'restoreDataSuccessTitle'              => esc_html__( 'Restoration Successful', 'easy-post-submission' ),
			'restoreDataFailedTitle'               => esc_html__( 'Restoration failed', 'easy-post-submission' ),
			'restoreDataDuplicateKeyErrorMessage'  => esc_html__( 'Duplicate values found: ', 'easy-post-submission' ),
			'formCreateSuccess'                    => esc_html__( 'Form created', 'easy-post-submission' ),
			/* translators: %s is the name or title of the form */
			'formCreateSuccessMessage'             => esc_html__( '%s has been created successfully.', 'easy-post-submission' ),
			/* translators: %s is the name or title of the form */
			'formRemovedMessage'                   => esc_html__( 'Form %s was removed!', 'easy-post-submission' ),
			'warningSameCustomFieldName'           => esc_html__( 'Custom field names must be unique!', 'easy-post-submission' ),
			'maxCustomField'                       => esc_html__( 'Max custom field', 'easy-post-submission' ),
			'useThisMedia'                         => esc_html__( 'Use This Media', 'easy-post-submission' ),
			'selectMedia'                          => esc_html__( 'Select Media', 'easy-post-submission' ),
			'urlDirectionError'                    => esc_html__( 'The URL direction is invalid.', 'easy-post-submission' ),
			'chooseCategories'                     => esc_html__( 'Choose categories', 'easy-post-submission' ),
			'chooseTags'                           => esc_html__( 'Choose tags', 'easy-post-submission' ),
			'wordpressMediaError'                  => esc_html__( 'WordPress media scripts are unavailable.', 'easy-post-submission' ),
			'successMessagePattern'                => esc_html__( 'Post Submission Successful!', 'easy-post-submission' ),
			'errorMessagePattern'                  => esc_html__( 'Post Submission Failed', 'easy-post-submission' ),
			'loginMessagePattern'                  => esc_html__( 'Please log in to securely submit your content. If you do not have an account, sign up quickly to get started!', 'easy-post-submission' ),
			'emailAdminSubjectPattern'             => esc_html__( 'New Post Submitted', 'easy-post-submission' ),
			'emailAdminTitlePattern'               => esc_html__( 'Notification: A New Post Has Been Submitted', 'easy-post-submission' ),
			'emailAdminMessagePattern'             => html_entity_decode( esc_html__( 'Dear Admin, <br>We would like to inform you that a new post titled "{{post_title}}" has been successfully submitted. Please check and review the post in the system. <br>Best regards, The Support Team', 'easy-post-submission' ) ),
			'emailPostSubmitSubjectPattern'        => esc_html__( 'Your Post Has Been Successfully Submitted', 'easy-post-submission' ),
			'emailPostSubmitTitlePattern'          => esc_html__( 'Confirmation: Your Post Submission', 'easy-post-submission' ),
			'emailPostSubmitMessagePattern'        => html_entity_decode( esc_html__( 'Dear Author, <br>We would like to inform you that your post titled "{{post_title}}" has been successfully submitted. Our team will review your post and notify you once its published. Thank you for your contribution! <br>Best regards, The Support Team', 'easy-post-submission' ) ),
			'emailPostPublishSubjectPattern'       => esc_html__( 'Your Post Has Been Published', 'easy-post-submission' ),
			'emailPostPublishTitlePattern'         => esc_html__( 'Congratulations: Your Post Is Now Live', 'easy-post-submission' ),
			'emailPostPublishMessagePattern'       => html_entity_decode( esc_html__( 'Dear author, <br>We are excited to inform you that your post titled "{{post_title}}" has been successfully published on our platform. You can now view your post live here: {{post_link}} Thank you for your contribution, and we look forward to more great content from you! <br>Best regards, The Support Team', 'easy-post-submission' ) ),
			'emailPostTrashSubjectPattern'         => esc_html__( 'Your Post Has Been Deleted', 'easy-post-submission' ),
			'emailPostTrashTitlePattern'           => esc_html__( 'Notice: Your Post Has Been Removed', 'easy-post-submission' ),
			'emailPostTrashMessagePattern'         => html_entity_decode( esc_html__( 'Dear Author, <br>We regret to inform you that your post titled "{{post_title}}" has been removed from our platform. If you have any questions or concerns about this, please feel free to contact us. Thank you for your understanding. <br>Best regards, The Support Team', 'easy-post-submission' ) ),
			'postManager'                          => esc_html__( 'Global Settings', 'easy-post-submission' ),
			'editPostForm'                         => esc_html__( 'Submission Edit Post Form', 'easy-post-submission' ),
			'editPostUrl'                          => esc_html__( 'Post Submission Edit Page URL', 'easy-post-submission' ),
			'editPostUrlDesc'                      => esc_html__( 'Enter the URL of the page that displays the submission edit form ([easy_post_submission_edit]) when users click the Edit Post button in the post manager.', 'easy-post-submission' ),
			'postManagerPageUrl'                   => esc_html__( 'Post Manager Page URL', 'easy-post-submission' ),
			'postManagerPageUrlDesc'               => esc_html__( 'Enter the URL of the page that displays the post manager ([easy_post_submission_manager]). This URL will be used for login redirects to ensure users reach the correct post management page.', 'easy-post-submission' ),
			'allowEditPost'                        => esc_html__( 'Allow Edit Post', 'easy-post-submission' ),
			'allowEditPostDesc'                    => esc_html__( 'Allows displaying the edit post button on the post manager page.', 'easy-post-submission' ),
			'invalidPostManagerPageURL'            => esc_html__( 'The Post Manager Page URL is invalid.', 'easy-post-submission' ),
			'allowDeletePost'                      => esc_html__( 'Allow Delete Post', 'easy-post-submission' ),
			'allowDeletePostDesc'                  => esc_html__( 'Allows displaying the remove post button on the post manager page.', 'easy-post-submission' ),
			'formSubmissionDefault'                => esc_html__( 'Form Submission Default ID', 'easy-post-submission' ),
			'formSubmissionDefaultDesc'            => esc_html__( 'This is the ID of the default form submission shortcode (e.g., [easy_post_submission_form id=1]). It will be used when displaying the Edit Post form if the form submission that belonged to that post was deleted.', 'easy-post-submission' ),
			'updatePostManagerSuccessfulMessage'   => esc_html__( 'Post manager settings were saved successful!', 'easy-post-submission' ),
			'customRequiredLoginTitle'             => esc_html__( 'Notification Title', 'easy-post-submission' ),
			'customRequiredLoginTitleDesc'         => esc_html__( 'Enter your notification title for users who are not logged in.', 'easy-post-submission' ),
			'customRequiredLoginDescLabel'         => esc_html__( 'Notification Message', 'easy-post-submission' ),
			'customRequiredLoginDescLabelDesc'     => esc_html__( 'Enter your notification description for users who are not logged in.', 'easy-post-submission' ),
			'register'                             => esc_html__( 'Register', 'easy-post-submission' ),
			'requiredLoginTitlePattern'            => esc_html__( 'Login Required to Submit', 'easy-post-submission' ),
			'requiredLoginTitleDescPattern'        => esc_html__( 'You must be logged in to submit a new post. Please log in to continue.', 'easy-post-submission' ),
			'submissionFormLayoutType'             => esc_html__( 'Form Layout', 'easy-post-submission' ),
			'submissionFormLayoutTypeDesc'         => esc_html__( 'This option is used to display the submission form by the number of columns.', 'easy-post-submission' ),
			'parseRestoreDataFailed'               => esc_html__( 'Invalid import data', 'easy-post-submission' ),
			'invalidId'                            => esc_html__( 'Invalid Id', 'easy-post-submission' ),
			'validateFailedPostManager'            => esc_html__( 'Post manager data import is invalid.', 'easy-post-submission' ),
			'validateSuccessPostManager'           => esc_html__( 'Valid post manager data has been imported.', 'easy-post-submission' ),
			'rubySubmissionEdit'                   => esc_html__( 'To display the editing post to users, create a page and insert the shortcode below. Adjust the settings to your preference.', 'easy-post-submission' ),
			'customLoginAndRegister'               => esc_html__( 'Login and Registration Buttons', 'easy-post-submission' ),
			'loginActionChoice'                    => esc_html__( 'Login Action Choice', 'easy-post-submission' ),
			'loginActionChoiceDesc'                => esc_html__( 'Choose whether to show a notification or redirect to the login page when a visitor accesses this page without being logged in.', 'easy-post-submission' ),
			'userPostsRequiredLoginTitle'          => esc_html__( 'Notification Title', 'easy-post-submission' ),
			'userPostsRequiredLoginTitleDesc'      => esc_html__( 'Enter your notification title for users who are not logged in.', 'easy-post-submission' ),
			'userPostsRequiredLoginMessage'        => esc_html__( 'Notification Message', 'easy-post-submission' ),
			'userPostsRequiredLoginMessageDesc'    => esc_html__( 'Enter your notification description for users who are not logged in.', 'easy-post-submission' ),
			'editPostRequiredLoginTitle'           => esc_html__( 'Notification Title', 'easy-post-submission' ),
			'editPostRequiredLoginTitleDesc'       => esc_html__( 'Enter your notification title for users who are not logged in.', 'easy-post-submission' ),
			'editPostRequiredLoginMessage'         => esc_html__( 'Notification Message', 'easy-post-submission' ),
			'editPostRequiredLoginMessageDesc'     => esc_html__( 'Enter your notification description for users who are not logged in.', 'easy-post-submission' ),
			'customLoginButtonLabel'               => esc_html__( 'Login Button Label', 'easy-post-submission' ),
			'customLoginButtonLabelDesc'           => esc_html__( 'This label is used for the button that redirects users to the login page.', 'easy-post-submission' ),
			'loginLinkLabelPattern'                => esc_html__( 'Continue Login', 'easy-post-submission' ),
			'customLoginLink'                      => esc_html__( 'Custom Login Page URL', 'easy-post-submission' ),
			'customLoginLinkDesc'                  => esc_html__( 'Enter your custom login URL here. This link will redirect users to your specified login page.', 'easy-post-submission' ),
			'customRegisterButtonLabel'            => esc_html__( 'Registration Button Label', 'easy-post-submission' ),
			'customRegisterButtonLabelDesc'        => esc_html__( 'This label is used for the button that redirects users to the register page.', 'easy-post-submission' ),
			'customRegisterLink'                   => esc_html__( 'Custom Registration Page URL', 'easy-post-submission' ),
			'customRegisterLinkDesc'               => esc_html__( 'Enter your custom registration URL here. This link will redirect users to your specified registration page.', 'easy-post-submission' ),
			'userPostsRequiredLoginTitlePattern'   => esc_html__( 'Login Required to Access Posts', 'easy-post-submission' ),
			'userPostsRequiredLoginMessagePattern' => esc_html__( 'You need to be logged in to view all posts. Please log in to continue.', 'easy-post-submission' ),
			'editPostRequiredLoginTitlePattern'    => esc_html__( 'Login Required to Edit Post', 'easy-post-submission' ),
			'editPostRequiredLoginMessagePattern'  => esc_html__( 'You must be logged in to edit this post. Please log in to proceed.', 'easy-post-submission' ),
			'maxImagesTitle'                       => esc_html__( 'Maximum Number Of Images In Post', 'easy-post-submission' ),
			'maxImagesDesc'                        => esc_html__( 'The maximum allowed number of images in a post.', 'easy-post-submission' ),
			'maxImageSizeTitle'                    => esc_html__( 'Maximum Size Of Each Image', 'easy-post-submission' ),
			'maxImageSizeDesc'                     => esc_html__( 'The maximum allowed size for each image in a post is measured in KB.', 'easy-post-submission' ),
			'documents'                            => esc_html__( 'Documentation', 'easy-post-submission' ),
			'helpTab'                              => esc_html__( 'Helps', 'easy-post-submission' ),
			'invalidPostEditURL'                   => esc_html__( 'The Post Submission Edit Page URL is invalid.', 'easy-post-submission' ),
			'invalidCustomLoginLink'               => esc_html__( 'The Custom Login Page URL is invalid.', 'easy-post-submission' ),
			'invalidCustomRegisterLink'            => esc_html__( 'The Custom Registration Page URL is invalid.', 'easy-post-submission' ),
			'invalidAdminEmail'                    => esc_html__( 'The Admin Email Address is invalid.', 'easy-post-submission' ),
			'quickSetupWizard'                     => esc_html__( 'Quick Setup Wizard', 'easy-post-submission' ),
			'setupWizardDescription'               => esc_html__( 'To offer your users a welcoming experience, we need to create a submit form, submit, and profile pages.', 'easy-post-submission' ),
			'createForm'                           => esc_html__( 'Create Form', 'easy-post-submission' ),
			'createFormDescription'                => esc_html__( 'This option will create a new form.', 'easy-post-submission' ),
			'createSubmitPage'                     => esc_html__( 'Create Submit Page', 'easy-post-submission' ),
			'createSubmitPageDescription'          => esc_html__( 'This option will create a new submit page.', 'easy-post-submission' ),
			'createProfilePage'                    => esc_html__( 'Create Profile Page', 'easy-post-submission' ),
			'createProfilePageDescription'         => esc_html__( 'This option will create a new profile page.', 'easy-post-submission' ),
			'createEditPage'                       => esc_html__( 'Create Edit Submission Page', 'easy-post-submission' ),
			'createEditPageDescription'            => esc_html__( 'This option will create an edit submission page for the logged-in user.', 'easy-post-submission' ),
			'createLoginPage'                      => esc_html__( 'Create Login Page', 'easy-post-submission' ),
			'createLoginPageDescription'           => esc_html__( 'This option will create a login page for users.', 'easy-post-submission' ),
			'createRegisterPage'                   => esc_html__( 'Create Register Page', 'easy-post-submission' ),
			'createRegisterPageDescription'        => esc_html__( 'This option will create a registration page for new users.', 'easy-post-submission' ),
			'complete'                             => esc_html__( 'Complete', 'easy-post-submission' ),
			'loading'                              => esc_html__( 'Loading', 'easy-post-submission' ),
			'setupCompletedSuccessfully'           => esc_html__( 'Setup completed successfully.', 'easy-post-submission' ),
			'errorCompletingSetup'                 => esc_html__( 'Error completing setup.', 'easy-post-submission' ),

			// Useful themes
			'premiumTitle'                         => esc_html__( 'Premium News/Magazine Themes', 'easy-post-submission' ),
			'foxizThemeTitle'                      => esc_html__( 'Foxiz', 'easy-post-submission' ),
			'foxizTagline'                         => esc_html__( 'Newspaper News and Magazine WordPress Theme', 'easy-post-submission' ),
			'pixwellThemeTitle'                    => esc_html__( 'Pixwell', 'easy-post-submission' ),
			'pixwellTagline'                       => esc_html__( 'Magazine WordPress Theme', 'easy-post-submission' ),
			'learnMore'                            => esc_html__( 'Learn More', 'easy-post-submission' ),

			// Useful shortcodes
			'usefulShortcodes'                     => esc_html__( 'Useful shortcodes for setup', 'easy-post-submission' ),
			'displaySubmitPostFormFrontend'        => esc_html__( 'Display the submit post form on the frontend', 'easy-post-submission' ),
			'placeSubmitShortcode'                 => esc_html__( 'Place the shortcode on a page, block, or widget where you want to display the submit form. Change the ID to match your form shortcode.', 'easy-post-submission' ),
			'displayListPostSubmissions'           => esc_html__( 'Display the list of post submissions for logged-in users', 'easy-post-submission' ),
			'placeProfileShortcode'                => esc_html__( 'Place the shortcode on a page where you want to display the user profile posts.', 'easy-post-submission' ),
			'displayEditForm'                      => esc_html__( 'Display the edit post submission for logged-in users', 'easy-post-submission' ),
			'placeEditShortcode'                   => esc_html__( 'Place the shortcode on a page where the logged-in user can edit their submission.', 'easy-post-submission' ),
			'documentsInfo'                        => esc_html__( 'Full documentation', 'easy-post-submission' ),
		];
	}
}

if ( ! function_exists( 'easy_post_submission_description_strings' ) ) {
	/**
	 * Provides description strings for the frontend.
	 *
	 * This function returns an array of description strings used in the frontend interface of the plugin. These strings
	 * can be used for various messages and labels visible to users interacting with the submission forms and content.
	 *
	 * @return array An array containing description strings for the frontend.
	 */
	function easy_post_submission_description_strings() {

		return [
			'ok'                                   => esc_html__( 'OK', 'easy-post-submission' ),
			'delete'                               => esc_html__( 'Delete', 'easy-post-submission' ),
			'confirmDelete'                        => esc_html__( 'Confirm Delete', 'easy-post-submission' ),
			'submit'                               => esc_html__( 'Submit', 'easy-post-submission' ),
			'cancel'                               => esc_html__( 'Cancel', 'easy-post-submission' ),
			'post'                                 => esc_html__( 'Post Title', 'easy-post-submission' ),
			'categories'                           => esc_html__( 'Categories', 'easy-post-submission' ),
			'createdDate'                          => esc_html__( 'Created', 'easy-post-submission' ),
			'status'                               => esc_html__( 'Status', 'easy-post-submission' ),
			'views'                                => esc_html__( 'Views', 'easy-post-submission' ),
			'actions'                              => esc_html__( 'Actions', 'easy-post-submission' ),
			'noPostShowTitle'                      => esc_html__( 'It looks like there are no posts to display yet!', 'easy-post-submission' ),
			'noPostShowDesc'                       => esc_html__( 'We would love to see your contributions! Please submit your posts to showcase them here.', 'easy-post-submission' ),
			'needLogin'                            => esc_html__( 'Please Log In to Continue', 'easy-post-submission' ),
			'morePosts'                            => esc_html__( 'Load More Posts', 'easy-post-submission' ),
			'postListLabel'                        => esc_html__( 'Your Posts', 'easy-post-submission' ),
			'editPost'                             => esc_html__( 'Edit Post', 'easy-post-submission' ),
			'submitPost'                           => esc_html__( 'Submit a Post', 'easy-post-submission' ),
			/* translators: %s is the title or name of the post */
			'postDeleteSuccessfulMessage'          => esc_html__( '%s was deleted successfully.', 'easy-post-submission' ),
			/* translators: %s is the title or name of the post */
			'confirmDeleteMessage'                 => esc_html__( 'Are you sure you want to delete the post: %s ?', 'easy-post-submission' ),
			'yourName'                             => esc_html__( 'Your Name', 'easy-post-submission' ),
			'hindYourName'                         => esc_html__( 'Enter your full name as you would like it to appear.', 'easy-post-submission' ),
			'yourEmail'                            => esc_html__( 'Your Email', 'easy-post-submission' ),
			'hindYourEmail'                        => esc_html__( 'Your email address will not be publicly displayed. It is used solely for administrative purposes and to contact you about your post.', 'easy-post-submission' ),
			'challengeTitle'                       => esc_html__( 'Competition Challenge', 'easy-post-submission' ),
			'challengeLabel'                       => esc_html__( 'Please answer the question:', 'easy-post-submission' ),
			'invalidAnswer'                        => esc_html__( 'The answer provided is invalid. Please enter a valid response.', 'easy-post-submission' ),
			'addPostTitle'                         => esc_html__( 'Add Title', 'easy-post-submission' ),
			'hindPostTitle'                        => esc_html__( 'Short and sweet is the way to go! Try to keep your post title between 50 and 70 characters to make it more engaging.', 'easy-post-submission' ),
			'addPostExcerpt'                       => esc_html__( 'Add Excerpt', 'easy-post-submission' ),
			'hindPostExcerpt'                      => esc_html__( 'Aim for a length of about 20 to 55 words. A concise excerpt captures the essence of your post without giving everything away.', 'easy-post-submission' ),
			'addPostContent'                       => esc_html__( 'Add Post Content', 'easy-post-submission' ),
			'textAreaFormPlaceholder'              => esc_html__( 'Start writing your content here...', 'easy-post-submission' ),
			'hindPostContent'                      => esc_html__( 'Begin with a captivating introduction that grabs your readers attention and gives them a reason to keep reading.', 'easy-post-submission' ),
			'titlePostCategories'                  => esc_html__( 'Categories', 'easy-post-submission' ),
			'choosePostCategories'                 => esc_html__( 'Choose Categories', 'easy-post-submission' ),
			'hindPostCategories'                   => esc_html__( 'Choose categories that accurately reflect your post content.', 'easy-post-submission' ),
			'titlePostTags'                        => esc_html__( 'Post Tags', 'easy-post-submission' ),
			'addPostTags'                          => esc_html__( 'Add Tags', 'easy-post-submission' ),
			'choosePostTags'                       => esc_html__( 'Choose Tags', 'easy-post-submission' ),
			'hindPostTags'                         => esc_html__( 'Choose tags that are most relevant to your post content.', 'easy-post-submission' ),
			'titlePostFeatured'                    => esc_html__( 'Featured Image', 'easy-post-submission' ),
			'hindPostFeatured'                     => esc_html__( 'A relevant, high-quality image effectively conveys the essence of your content and captures the attention of your audience.', 'easy-post-submission' ),
			'chooseFeaturedImage'                  => esc_html__( 'Select an Image', 'easy-post-submission' ),
			'editFeaturedImage'                    => esc_html__( 'Edit Featured Image', 'easy-post-submission' ),
			'submitPostLabel'                      => esc_html__( 'Submit Post', 'easy-post-submission' ),
			'updatePostLabel'                      => esc_html__( 'Update Post', 'easy-post-submission' ),
			'challengeRequiredInput'               => esc_html__( 'An answer is required!', 'easy-post-submission' ),
			'verifyFailedRecaptchaMessage'         => esc_html__( 'reCAPTCHA was not verified', 'easy-post-submission' ),
			'maxAmountImages'                      => esc_html__( 'Maximum Images Upload', 'easy-post-submission' ),
			/* translators: %s is the maximum number of images allowed */
			'maxAmountImagesMessage'               => esc_html__( 'You have reached the maximum limit of %s images.', 'easy-post-submission' ),
			'updating'                             => esc_html__( 'Updating', 'easy-post-submission' ),
			'submitting'                           => esc_html__( 'Submitting', 'easy-post-submission' ),
			/* translators: %s is the name or title of the post */
			'updatePostSuccessMessage'             => esc_html__( '%s was updated successfully.', 'easy-post-submission' ),
			/* translators: %s is the name or title of the post */
			'submitPostSuccessMessage'             => esc_html__( '%s was added successfully.', 'easy-post-submission' ),
			'updatePostSuccessTitle'               => esc_html__( 'Post updated', 'easy-post-submission' ),
			'submitPostSuccessTitle'               => esc_html__( 'Post submitted', 'easy-post-submission' ),
			'updatePostFailedTitle'                => esc_html__( 'Update failed', 'easy-post-submission' ),
			'submitPostFailedTitle'                => esc_html__( 'Submission failed', 'easy-post-submission' ),
			'register'                             => esc_html__( 'Register', 'easy-post-submission' ),
			'login'                                => esc_html__( 'Login', 'easy-post-submission' ),
			'requiredLoginTitlePattern'            => esc_html__( 'Login required to submit', 'easy-post-submission' ),
			'requiredLoginDescPattern'             => esc_html__( 'To continue editing your post, please log in to your account.', 'easy-post-submission' ),
			'userPostsRequiredLoginTitlePattern'   => esc_html__( 'Login required to access posts', 'easy-post-submission' ),
			'userPostsRequiredLoginMessagePattern' => esc_html__( 'You need to be logged in to view all posts. Please log in to continue.', 'easy-post-submission' ),
			'editPostRequiredLoginTitlePattern'    => esc_html__( 'Login required to edit post', 'easy-post-submission' ),
			'editPostRequiredLoginMessagePattern'  => esc_html__( 'You must be logged in to edit this post. Please log in to proceed.', 'easy-post-submission' ),
			'titleRequiredRule'                    => esc_html__( 'Please enter a title.', 'easy-post-submission' ),
			'excerptRequiredRule'                  => esc_html__( 'Please provide an excerpt.', 'easy-post-submission' ),
			'userNameRequiredRule'                 => esc_html__( 'Please enter your username.', 'easy-post-submission' ),
			'userEmailRequiredRule'                => esc_html__( 'Please enter your email address.', 'easy-post-submission' ),
			'title'                                => esc_html__( 'Title', 'easy-post-submission' ),
			'excerpt'                              => esc_html__( 'Excerpt', 'easy-post-submission' ),
			'userName'                             => esc_html__( 'User name', 'easy-post-submission' ),
			'userEmail'                            => esc_html__( 'User email', 'easy-post-submission' ),
			'isMissing'                            => esc_html__( 'is missing. Please provide it.', 'easy-post-submission' ),
			'areMissing'                           => esc_html__( 'are missing. Please provide them.', 'easy-post-submission' ),
			'imageSizeLimitTitle'                  => esc_html__( 'Image size limit', 'easy-post-submission' ),
			/* translators: %s is the size of the image in KB */
			'imageSizeLimitMessage'                => esc_html__( 'The size of the image has exceeded the allowed limit, which is %s KB.', 'easy-post-submission' ),
			'invalidIndexToInsertImage'            => esc_html__( 'Invalid index to insert the image to editor', 'easy-post-submission' ),
			'noSelection'                          => esc_html__( 'No selection in quill editor', 'easy-post-submission' ),
			'error'                                => esc_html__( 'Error!', 'easy-post-submission' ),
			'errorMessage'                         => esc_html__( 'This submission form has been removed by the webmaster. Please check back later.', 'easy-post-submission' ),
			'unSaved'                              => esc_html__( 'Unsaved Changes', 'easy-post-submission' ),
			'unSavedMessage'                       => esc_html__( 'Are you sure you want to reload the page without saving your changes?', 'easy-post-submission' ),
		];
	}
}