/* global jQuery, wp, gfpdfGvGlobals */
jQuery(function () {
  let fileFrame
  window.gfpdfGvUploadFormfield = ''

  jQuery('.gv_upload_field_button').on('click', function (e) {
    e.preventDefault()

    window.gfpdfGvUploadFormfield = jQuery(this).prev()

    /* If the media frame already exists, reopen it. */
    if (fileFrame) {
      fileFrame.open()
      return
    }

    /* Create the media frame. */
    fileFrame = wp.media.frames.file_frame = wp.media({
      title: gfpdfGvGlobals.mediaLabel,
      button: {
        text: gfpdfGvGlobals.mediaLabel
      },
      multiple: false
    })

    /* When a file is selected, run a callback. */
    fileFrame.on('select', function () {
      const selection = fileFrame.state().get('selection')
      selection.each(function (attachment) {
        attachment = attachment.toJSON()
        window.gfpdfGvUploadFormfield.val(attachment.url).trigger('change')
      })
    })

    /* Finally, open the modal */
    fileFrame.open()
  })
})
