<?php

namespace GFPDF\Plugins\PdfForGravityView\GravityView\Fields;

/**
 * @package     PDF for GravityView
 * @copyright   Copyright (c) 2025, Blue Liquid Designs
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 */

/* Exit if accessed directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * @since 0.1
 */
class CodeEditor extends \GravityView_FieldType_textarea {
	/**
	 * Renders the HTML input for this field type
	 *
	 * @param $override_input
	 *
	 * @return void
	 *
	 * @since 0.1
	 */
	public function render_input( $override_input = null ) {
		if ( isset( $override_input ) ) {
			parent::render_input( $override_input );

			return;
		}

		$syntax   = $this->field['syntax'] ?? 'text/html';
		$settings = wp_enqueue_code_editor( [ 'type' => $syntax ] );

		// Return if the editor was not enqueued.
		if ( false !== $settings ) {
			$id = $this->get_field_id();
			wp_register_script( $id, '', [], GFPDF_PDF_FOR_GV_VERSION, true );
			wp_enqueue_script( $id );
			wp_add_inline_script(
				$id,
				sprintf(
					'
					jQuery(function() { 
						var instance = wp.codeEditor.initialize( "%1$s", %2$s );
						jQuery("#gravityview_settings .ui-tab").on("click", function() { 
							instance.codemirror.refresh();
						})
					});',
					$this->get_field_id(),
					wp_json_encode( $settings )
				)
			);
		}

		parent::render_input();

		if ( version_compare( GV_PLUGIN_VERSION, '2.19', '<' ) ) {
			echo '<span style="white-space: normal">' . wp_kses_post( $this->get_field_desc() ) . '</span>';
		}
	}
}
