<?php

namespace GFPDF\Plugins\PdfForGravityView\GravityView\Fields;

/**
 * @package     PDF for GravityView
 * @copyright   Copyright (c) 2025, Blue Liquid Designs
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 */

/* Exit if accessed directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * @since 0.1
 */
class ColorPicker extends \GravityView_FieldType_text {
	/**
	 * Renders the HTML input for this field type
	 *
	 * @param $override_input
	 *
	 * @return void
	 *
	 * @since 0.1
	 */
	public function render_input( $override_input = null ) {
		parent::render_input( $override_input );
		echo wp_kses_post( $this->get_field_desc() );

		?>
		<script>
		  jQuery(function () {
			jQuery('#<?php echo esc_attr( $this->get_field_id() ); ?>').wpColorPicker()
		  })
		</script>
		<?php
	}
}
