<?php

namespace GFPDF\Plugins\PdfForGravityView\GravityView\Fields;

/**
 * @package     PDF for GravityView
 * @copyright   Copyright (c) 2025, Blue Liquid Designs
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 */

/* Exit if accessed directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * @since 0.1
 */
class RichTextarea extends \GravityView_FieldType_textarea {
	/**
	 * Renders the HTML input for this field type
	 *
	 * @param $override_input
	 *
	 * @return void
	 *
	 * @since 0.1
	 */
	public function render_input( $override_input = null ) {
		if ( isset( $override_input ) ) {
			parent::render_input( $override_input );

			return;
		}

		$class = rgar( $this->field, 'class' );

		/* Handle the merge tag selector */
		$show_mt = $this->show_merge_tags();
		if ( ( $show_mt && $this->field['merge_tags'] !== false ) || $this->field['merge_tags'] === 'force' ) {
			$class .= 'merge-tag-support mt-wp_editor mt-manual_position mt-position-right';

			if ( empty( $this->field['show_all_fields'] ) ) {
				$class .= ' mt-hide_all_fields ';
			}
		}

		wp_editor(
			$this->value,
			$this->get_field_id(),
			[
				'textarea_name' => $this->name,
				'media_buttons' => true,
				'editor_class'  => $class,
				'editor_height' => $this->field['size'] ?? 150,
			]
		);

		echo '<span style="white-space: normal">' . wp_kses_post( $this->get_field_desc() ) . '</span>';
	}
}
