<?php

namespace GFPDF\Plugins\PdfForGravityView\GravityView\Fields;

/**
 * @package     PDF for GravityView
 * @copyright   Copyright (c) 2025, Blue Liquid Designs
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 */

/* Exit if accessed directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * @since 0.1
 */
class Upload extends \GravityView_FieldType_text {
	/**
	 * Renders the HTML input for this field type
	 *
	 * @param $override_input
	 *
	 * @return void
	 *
	 * @since 0.1
	 */
	public function render_input( $override_input = null ) {
		parent::render_input( $override_input );
		?>
		<button id="<?php echo esc_attr( $this->get_field_id() ); ?>_upload_button" class="gv_upload_field_button button" type="button">
			<?php echo esc_html__( 'Upload', 'gk-pdf-for-gravityview' ); ?>
		</button>
		<?php
		echo wp_kses_post( $this->get_field_desc() );
	}
}
