<?php

namespace GFPDF\Plugins\PdfForGravityView\GravityView;

use GV\Entry;
use GV\Request;
use GV\View;

/**
 * @package     PDF for GravityView
 * @copyright   Copyright (c) 2025, Blue Liquid Designs
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since       0.8.0
 */

/* Exit if accessed directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class MockSingleRequest extends Request {
	protected $view;
	protected $entry;

	public function __construct( View $view, Entry $entry ) {
		$this->view  = $view;
		$this->entry = $entry;
	}

	public function is_renderable() {
		return true;
	}

	public static function is_admin() {
		return false;
	}

	public static function is_frontend() {
		return true;
	}

	public static function is_add_oembed_preview() {
		return false;
	}

	public static function is_ajax() {
		return false;
	}

	public static function is_rest() {
		return true;
	}

	public function is_view( $return_view = true ) {
		return $this->view;
	}

	public function is_entry( $form_id = 0 ) {
		return $this->entry;
	}

	public function is_edit_entry( $form_id = 0 ) {
		return false;
	}

	public function is_search() {
		return false;
	}
}
