<?php

use GFPDF\Helper\Helper_Url_Signer;
use GV\GF_Form;

/**
 * @package     PDF for GravityView
 * @copyright   Copyright (c) 2025, Blue Liquid Designs
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 */

if ( ! isset( $gravityview ) || empty( $gravityview->template ) ) {
	gravityview()->log->error( '{file} template loaded without context', [ 'file' => __FILE__ ] );

	return;
}

/** @var GF_Form $gf_form */
$gf_form = isset( $gravityview->field->form_id ) ? GF_Form::by_id( $gravityview->field->form_id ) : $gravityview->view->form->form;
$form    = ! empty( $gf_form->form ) ? $gf_form->form : $gf_form;

/* Get GV entry object based on whether directory view or entry view ($entry will be empty) */
$entry = empty( $entry ) ? $gravityview->entry : gravityview()->request->is_entry( $form['id'] );

if ( $entry->is_multi() ) {
	$entry_id = implode( ',', array_column( $entry->entries, 'ID' ) );
	$entry    = $entry->as_entry();
} else {
	$entry    = $entry->as_entry();
	$entry_id = $entry['id'];
}

$field_settings = $gravityview->field->as_configuration();

$form_id = get_option( 'gfpdf_for_gv_pdf_email_form_id' );

/* Only override the form labels on the initial render. See \GFPDF\Plugins\PdfForGravityView\GravityView\Fields\PdfEmail::populate_form() for the rest */
add_filter(
	'gform_pre_render_' . $form_id,
	function ( $email_form ) use ( $field_settings, $form, $entry ) {
		$email_form['description']        = \GFCommon::replace_variables( $field_settings['pdf_email_instructions'] ?? '', $form, $entry, false, false );
		$email_form['fields'][0]['label'] = \GFCommon::replace_variables( $field_settings['pdf_email_email_label'] ?? '', $form, $entry );
		$email_form['button']['text']     = \GFCommon::replace_variables( $field_settings['pdf_email_submit_label'] ?? '', $form, $entry );

		return $email_form;
	}
);

$instructions = \GFCommon::replace_variables( $field_settings['pdf_email_instructions'] ?? '', $form, $entry, false, false );

gravity_form(
	$form_id,
	false,
	true,
	false,
	[
		'view_id'  => \GFCommon::openssl_encrypt( 'gv-view-' . $gravityview->view->ID ),
		'post_id'  => \GFCommon::openssl_encrypt( 'gv-view-' . $post->ID ),
		'nonce'    => wp_create_nonce( 'gv-pdf-email-nonce-' . $gravityview->view->ID ),
		'entry_id' => \GFCommon::openssl_encrypt( 'gv-view-' . $entry_id ),
	],
	true
);
