<?php

use GFPDF\Helper\Helper_Url_Signer;
use GV\GF_Form;

/**
 * @package     PDF for GravityView
 * @copyright   Copyright (c) 2025, Blue Liquid Designs
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 */

if ( ! isset( $gravityview ) || empty( $gravityview->template ) ) {
	gravityview()->log->error( '{file} template loaded without context', [ 'file' => __FILE__ ] );

	return;
}

/** @var GF_Form $gf_form */
$gf_form = isset( $gravityview->field->form_id ) ? GF_Form::by_id( $gravityview->field->form_id ) : $gravityview->view->form->form;
$form    = ! empty( $gf_form->form ) ? $gf_form->form : $gf_form;

/* Get GV entry object based on whether directory view or entry view ($entry will be empty) */
$entry = empty( $entry ) ? $gravityview->entry : gravityview()->request->is_entry( $form['id'] );

$field_settings = $gravityview->field->as_configuration();

$link_text = empty( $field_settings['pdf_link_text'] ) ? esc_html__( 'View PDF', 'gk-pdf-for-gravityview' ) : $field_settings['pdf_link_text'];
$download  = empty( $field_settings['pdf_link_action'] ) ? '0' : '1';

$output = apply_filters( 'gravityview_entry_link', GFCommon::replace_variables( $link_text, $form, $entry->as_entry() ), $gravityview );

$tag_atts = [
	'class' => 'gravitypdf-download-link',
];

if ( ! empty( $field_settings['custom_class'] ) ) {
	$tag_atts['class'] .= ' ' . $field_settings['custom_class'];
}

if ( ! empty( $field_settings['new_window'] ) ) {
	$tag_atts['target'] = '_blank';
}

add_filter( 'gravityview/entry_link/add_query_args', '__return_false' );
$base = $entry->get_permalink( $gravityview->view, $gravityview->request, $tag_atts );
remove_filter( 'gravityview/entry_link/add_query_args', '__return_false' );

/*
 * GV doesn't currently take into account permalinks that exclude the trailing slash
 * so we need to extract and remove any query args from $base (e.g. ?gvid=1 when multiple views embedded on the page),
 * potentially remove the trailing slash, and then add the original query arguments + PDF args to the URL
 */
$query_args = [];
$url_query  = wp_parse_url( $base, PHP_URL_QUERY );
parse_str( is_string( $url_query ) ? $url_query : '', $query_args );
$base = remove_query_arg( array_keys( $query_args ), $base );
$base = user_trailingslashit( $base );

$url = add_query_arg(
	array_merge(
		$query_args,
		[
			'gv-pdf'   => '1',
			'view'     => $gravityview->view->ID,
			'download' => $download,
		]
	),
	$base
);

$signer = new Helper_Url_Signer();

$valid_link_expiration_pattern = '/^([0-9]+) (minutes|hours|weeks|months|years|minute|hour|week|month|year)$/';
$expiration                    = '1 day';
if ( preg_match( $valid_link_expiration_pattern, $field_settings['pdf_link_expiration'] ?? '' ) ) {
	$expiration = $field_settings['pdf_link_expiration'];
}

$href = $signer->sign( $url, $expiration );

echo wp_kses_post( gravityview_get_link( $href, $output, $tag_atts ) );
