<?php

/**
 * @package     PDF for GravityView
 * @copyright   Copyright (c) 2025, Blue Liquid Designs
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 */

/* Exit if accessed directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $post;

$curr_form = gravityview_get_form_id( $post->ID );

// View template settings
$current_settings = gravityview_get_template_settings( $post->ID );
$settings         = \GV\View_Settings::defaults( true, 'pdf' );

?>

<table class="form-table striped">
	<?php
	foreach ( $settings as $key => $config ) {
		GravityView_Render_Settings::render_setting_row( $key, $current_settings );
	}
	?>
</table>
