<?php

namespace GFPDF\Plugins\PdfForGravityView\Pdf;

use GV\GF_Field;

/**
 * @package     PDF for GravityView
 * @copyright   Copyright (c) 2025, Blue Liquid Designs
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 */

/* Exit if accessed directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * @since 0.1
 */
class FieldFormat {

	/**
	 * @since 0.1
	 */
	public function init() {
		add_filter( 'gfpdf_gv_view_field_phone', [ $this, 'disable_clickable_phone_number' ] );
		add_filter( 'gravityview/fields/custom/content_before', [ $this, 'format_pricing_fields_merge_tag' ], 10, 2 );
	}

	/**
	 * Disable the clickable phone number in PDFs, as `tel:` is unsupported
	 *
	 * @param GF_Field $field
	 *
	 * @return GF_Field
	 *
	 * @since 0.1
	 */
	public function disable_clickable_phone_number( $field ) {

		$config = $field->as_configuration();

		$config['link_phone'] = '0';

		$field->update_configuration( $config );

		return $field;
	}

	/**
	 * Process {pricing_fields} merge tag for PDFs
	 *
	 * @param string $text
	 * @param \GV\Template_Context $gravityview
	 *
	 * @return string
	 *
	 * @since 1.1.0
	 */
	public function format_pricing_fields_merge_tag( $text, $gravityview ) {
		if ( ! Renderer::is_pdf_endpoint() ) {
			return $text;
		}

		if ( stripos( $text, '{pricing_fields}' ) === false ) {
			return $text;
		}

		$entry  = $gravityview->entry->as_entry();
		$output = (string) \GPDFAPI::product_table( $entry, true );

		return str_ireplace( '{pricing_fields}', $output, $text );
	}
}
