<?php

namespace GFPDF\Plugins\PdfForGravityView\Pdf;

use GFPDF\Plugins\PdfForGravityView\GravityView\Fields\Exclusions;

/**
 * @package     PDF for GravityView
 * @copyright   Copyright (c) 2025, Blue Liquid Designs
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 */

/* Exit if accessed directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * @since 0.1
 */
class FieldMiddleware {

	/**
	 * @since 0.1
	 */
	public function init() {
		add_filter( 'gfpdf_gv_field_middleware', [ $this, 'skip_gv_action_fields' ], 10, 2 );
		add_filter( 'gfpdf_gv_field_middleware', [ $this, 'skip_user_selected_fields' ], 20, 2 );
	}

	/**
	 * Remove any GV fields that do actions (edit entry, duplicate, delete, etc.)
	 *
	 * @param bool                 $action
	 * @param \GV\Field            $field
	 *
	 * @return bool
	 *
	 * @since 0.1
	 */
	public function skip_gv_action_fields( $action, $field ) {
		$fields_to_skip = apply_filters( 'gfpdf_gv_internal_fields_to_skip', Exclusions::INTERNAL_FIELDS, $field );

		if ( $action === false && ! empty( $field->type ) && in_array( $field->type, $fields_to_skip, true ) ) {
			return true;
		}

		return $action;
	}

	/**
	 * Remove any fields selected by the user in the UI
	 *
	 * @param bool                 $action
	 * @param \GV\Field            $field
	 *
	 * @return bool
	 *
	 * @since 0.1
	 */
	public function skip_user_selected_fields( $action, $field ) {
		if ( $action === false && $field->pdf_exclude === '1' ) {
			return true;
		}

		return $action;
	}
}
