<?php

use GFPDF\Statics\Kses;

/**
 * @package     PDF for GravityView
 * @copyright   Copyright (c) 2025, Blue Liquid Designs
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 */

/* Exit if accessed directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! isset( $gravityview ) || empty( $gravityview->template ) ) {
	gravityview()->log->error( '{file} template loaded without context', [ 'file' => __FILE__ ] );

	return;
}

$entry          = $gravityview->entry->as_entry();
$field_settings = $gravityview->field->as_configuration();

if ( ! class_exists( 'GravityView_Entry_Notes' ) ) {
	return;
}

$visibility_settings   = empty( $field_settings['notes'] ) ? [] : $field_settings['notes'];
$show_notes_logged_out = ( ! empty( $visibility_settings['view'] ) && ! empty( $visibility_settings['view_loggedout'] ) );

if ( ! $show_notes_logged_out && ! GVCommon::has_cap( [ 'gravityview_view_entry_notes' ] ) ) {
	return;
}

require_once GFCommon::get_base_path() . '/entry_detail.php';

$notes      = (array) GravityView_Entry_Notes::get_notes( $entry['id'] );
$strings    = GravityView_Field_Notes::strings();
$show_notes = $show_notes_logged_out || ( ! empty( $visibility_settings['view'] ) && GVCommon::has_cap( 'gravityview_view_entry_notes' ) );

if ( ! $show_notes ) {
	return;
}

$container_class = count( $notes ) > 0 ? 'gv-has-notes' : 'gv-no-notes';

$notes_markup = '';
if ( count( $notes ) === 0 ) {
	$notes_markup = $strings['caption'];
} else {
	foreach ( $notes as $note ) {
		$notes_markup .= GravityView_Field_Notes::display_note( $note, false, $gravityview );
	}
}

Kses::output(
	sprintf(
		'<div class="gv-notes %1$s">%2$s</div>',
		$container_class,
		$notes_markup
	)
);
