<?php

namespace GFPDF\Plugins\PdfForGravityView\Pdf;

use GV\View;

/**
 * @package     PDF for GravityView
 * @copyright   Copyright (c) 2025, Blue Liquid Designs
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 */

/* Exit if accessed directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * @since 0.1
 */
class Settings {

	/**
	 * Return the PDF settings for the current View
	 *
	 * @param View $view
	 *
	 * @return array
	 *
	 * @since 0.1
	 */
	public function get_pdf_settings( View $view ): array {
		$settings = $view->settings;

		return [
			'id'               => $view->ID,
			'label'            => 'GravityView PDF',
			'filename'         => $settings->get( 'gpdf_filename', '' ),

			'pdf_size'         => $settings->get( 'gpdf_size', '' ),
			'orientation'      => $settings->get( 'gpdf_orientation', '' ),
			'margin'           => preg_match( $this->get_margin_regex(), $settings->get( 'gpdf_page_margin', '' ) ) ? $settings->get( 'gpdf_page_margin' ) : '20mm',

			'font'             => $settings->get( 'gpdf_font', '' ),
			'font_colour'      => $settings->get( 'gpdf_font_color', '' ),
			'font_size'        => $settings->get( 'gpdf_font_size', '' ),

			'header'           => $settings->get( 'gpdf_header', '' ),
			'footer'           => $settings->get( 'gpdf_footer', '' ),

			'background_color' => $settings->get( 'gpdf_background_color', '' ),
			'background_image' => $settings->get( 'gpdf_background_image', '' ),

			'show_title'       => (bool) $settings->get( 'gpdf_show_title', false ),
			'additional_css'   => $settings->get( 'gpdf_css_editor', '' ),

			'format'           => 'standard',
			'security'         => 'no',
		];
	}

	/**
	 * @return string
	 *
	 * @since 0.1
	 */
	protected function get_margin_regex() {
		return '/^(([\.\d]+(px|em|%|cm|in|pc|pt|mm|ex))[ ]?){1,4}$/';
	}
}
