<?php

/*
 * Template Name: GravityView Single Entry DIY Layout
 * Version: 0.1
 * Description: A PDF template designed specifically for outputting the GravityView Single Entry DIY Layout. Note: because DIY layouts usually involve a bunch of custom CSS, and the PDF engine doesn't support modern CSS, the PDF likely won't match the website design automatically. Use the `gfpdf_gv_template_styles_diy` action to inject CSS specifically for the PDF.
 * Author: Gravity PDF
 * Author URI: https://gravitypdf.com
 * Group: GravityView
 * License: GPLv2
 * Required PDF Version: 6.0
 */

use GFPDF\Statics\Kses;

/* Prevent direct access to the template */
if ( ! class_exists( 'GFForms' ) ) {
	return;
}

/**
 * The GravityView PDF Template has access to the following:
 *
 * @var \GV\View           $view          The current GravityView object
 * @var \GV\Entry          $view_entry    The current GravityView entry object
 * @var \GV\Entry_Template $view_template The original template class used to output the Single Entry Layout in GravityView
 * @var array              $view_fields   A curated array of Single Entry Layout fields, grouped by position
 *
 * @var array              $form          The current Gravity Form array
 * @var array              $entry         The raw entry data
 * @var array              $form_data     The processed entry data stored in an array
 * @var array              $settings      The current PDF configuration
 * @var object             $config        The initialized template config class (if any)
 * @var object             $gfpdf         The main Gravity PDF object containing all the helper classes
 * @var array              $args          Contains an array of all variables - the ones being described right now - passed to the template
 */

?>

<style>
  @page {
	margin: <?php echo esc_attr( $settings['margin'] ); ?>;
  }

  /* Header / Footer */
  #header p,
  .footer p {
	margin: 0;
  }

  /* Basic Styles */
  h1,
  h2,
  h3,
  h4,
  h5,
  h6 {
	margin: 0.5rem 0;
	padding: 0;
  }

  ul,
  ol {
	margin: 0;
	padding: 0 0 0 5mm;
  }

  p {
	margin: 0 0 3.5mm;
	padding: 0
  }

  /*
   * Image alignment
   */
  .alignleft {
	float: left;
  }

  .alignright {
	float: right;
  }

  .aligncenter {
	text-align: center;
  }

  p.alignleft {
	text-align: left;
	float: none;
  }

  p.alignright {
	text-align: right;
	float: none;
  }

  /* Single View Layout Title */
  #form_title {
	margin: 0 0 3mm;
	padding: 0;
	font-size: 150%;
  }

  /* Section Break Field */
  .field-type-section .label {
	font-size: 125%;
	margin: 1.5mm 0 0.5mm;
	padding: 0;
  }

  /* List Field */
  .gfield_list th {
	text-align: left;
  }

  .gfield_list th,
  .gfield_list td {
	padding: .3em;
  }

  /* Notes Field */
  .entry-detail-note {
	margin-top: -1px; /* Fixes border overlap */
	padding: 1em .5em 0 1em;
	border: 1px solid #eee;
  }

  .gv-note-avatar {
	width: 42px;
	height: 42px;
	float: left;
	padding-right: 10px;
  }

  .gv-note-author {
	font-weight: bold;
	font-size: 1.1rem;
	line-height: 1.1;
	margin: 0.75mm 0;
	padding: 0;
  }

  .gv-note-added-on {
	font-weight: normal;
	font-size: .875rem;
  }

  .gv-note-content {
	clear: both;
	margin: 0;
	padding: 1em 0 0 0;
	line-height: 1.8em;
  }

  /*
   * Checkmark
   */
  .dashicons-yes {
	font-family: dejavusanscondensed;
	font-size: 120%;
  }

  /*
   * Likert
   */
  .gsurvey-likert-choice {
	text-align: center;
	padding: .3em;
  }

  /*
   * Rating
   */
  .gv-field-survey-star {
	width: 6mm;
  }

  /* Common Layout */
  .row-separator {
	clear: both;
	padding: 1.5mm 0;
  }

  .inner-container {

  }

  <?php
	/* Add Additional CSS, if present */
	echo esc_html( wp_filter_nohtml_kses( $settings['additional_css'] ?? '' ) );

	do_action( 'gfpdf_gv_template_styles', $view, $view_entry );
	do_action( 'gfpdf_gv_template_styles_' . $view->ID, $view, $view_entry );
	do_action( 'gfpdf_gv_template_styles_diy', $view, $view_entry );
	?>
</style>

<?php

/* Output the page title, if configured */
$single_title  = $view->settings->get( 'single_title', '' );
$single_title  = ! empty( $single_title ) ? $single_title : $view->get_post()->post_title;
$form['title'] = $single_title;

/** @var \GFPDF\View\View_PDF $pdf_view */
$pdf_view = \GPDFAPI::get_pdf_class();
$pdf_view->show_form_title( $settings['show_title'], $form );

/* Output the Single Entry DIY View */
foreach ( $view_fields['single_diy-diy'] ?? [] as $field ) {
	/** @var $field \GV\GF_Field */
	Kses::output( $view_template->the_field( $field ) );
}
