<?php

/*
 * Template Name: GravityView Single Entry Map Layout
 * Version: 0.1
 * Description: A PDF template designed specifically for outputting the GravityView Single Entry Map Layout.
 * Author: Gravity PDF
 * Author URI: https://gravitypdf.com
 * Group: GravityView
 * License: GPLv2
 * Required PDF Version: 6.0
 */

use GFPDF\Statics\Kses;

/* Prevent direct access to the template */
if ( ! class_exists( 'GFForms' ) ) {
	return;
}

/**
 * The GravityView PDF Template has access to the following:
 *
 * @var \GV\View           $view          The current GravityView object
 * @var \GV\Entry          $view_entry    The current GravityView entry object
 * @var \GV\Entry_Template $view_template The original template class used to output the Single Entry Layout in GravityView
 * @var array              $view_fields   A curated array of Single Entry Layout fields, grouped by position
 *
 * @var array              $form          The current Gravity Form array
 * @var array              $entry         The raw entry data
 * @var array              $form_data     The processed entry data stored in an array
 * @var array              $settings      The current PDF configuration
 * @var object             $config        The initialized template config class (if any)
 * @var object             $gfpdf         The main Gravity PDF object containing all the helper classes
 * @var array              $args          Contains an array of all variables - the ones being described right now - passed to the template
 */

$show_label = apply_filters( 'gfpdf_gv_show_label', true, $view, $view_entry, 'map' );
$show_label = apply_filters( 'gfpdf_gv_show_label_' . $view->ID, $show_label, $view, $view_entry, 'map' );
$show_label = apply_filters( 'gfpdf_gv_show_label_map', $show_label, $view, $view_entry, 'map' );

$default_markup = '<div id="{{ field_id }}" class="{{ class }}">' . ( $show_label ? '{{ label }} ' : '' ) . '{{ value }}</div>';

?>

<style>
  @page {
	margin: <?php echo esc_attr( $settings['margin'] ); ?>;
  }

  /* Header / Footer */
  #header p,
  .footer p {
	margin: 0;
  }

  /* Basic Styles */
  h1,
  h2,
  h3,
  h4,
  h5,
  h6 {
	margin: 0.5rem 0;
	padding: 0;
  }

  ul,
  ol {
	margin: 0;
	padding: 0 0 0 5mm;
  }

  p {
	margin: 0 0 3.5mm;
	padding: 0
  }

  /*
   * Image alignment
   */
  .alignleft {
	float: left;
  }

  .alignright {
	float: right;
  }

  .aligncenter {
	text-align: center;
  }

  p.alignleft {
	text-align: left;
	float: none;
  }

  p.alignright {
	text-align: right;
	float: none;
  }

  /* Single View Layout Title */
  #form_title {
	margin: 0 0 3mm;
	padding: 0;
	font-size: 150%;
  }

  /* List Field */
  .gfield_list th {
	text-align: left;
  }

  .gfield_list th,
  .gfield_list td {
	padding: .3em;
  }

  /* Notes Field */
  .entry-detail-note {
	margin-top: -1px; /* Fixes border overlap */
	padding: 1em .5em 0 1em;
	border: 1px solid #eee;
  }

  .gv-note-avatar {
	width: 42px;
	height: 42px;
	float: left;
	padding-right: 10px;
  }

  .gv-note-author {
	font-weight: bold;
	font-size: 1.1rem;
	line-height: 1.1;
	margin: 0.75mm 0;
	padding: 0;
  }

  .gv-note-added-on {
	font-weight: normal;
	font-size: .875rem;
  }

  .gv-note-content {
	clear: both;
	margin: 0;
	padding: 1em 0 0 0;
	line-height: 1.8em;
  }

  /*
   * Checkmark
   */
  .dashicons-yes {
	font-family: dejavusanscondensed;
	font-size: 120%;
  }

  /*
   * Likert
   */
  .gsurvey-likert-choice {
	text-align: center;
	padding: .3em;
  }

  /*
   * Rating
   */
  .gv-field-survey-star {
	width: 6mm;
  }

  /* Single Entry Map Layout */
  .gv-map-view {
	border: 1px solid #ddd;
	margin-bottom: 1em;
  }

  .gv-field-label {
	padding-right: .25em;
  }

  .gv-map-view-title {
	border-bottom: 1px solid #ddd;
	padding: .5em 1em;
  }

  .gv-map-view-title h3 {
	font-size: 140%;
	margin: 0 0 .5em 0;
	padding: 0;
  }

  .gv-map-view-subtitle h4 {
	font-size: 125%;
	margin: 0;
  }

  .gv-map-view-content {
	padding: .75em 1em;
  }

  .gv-map-view-content-image {
	float: left;
	width: 30%;
	padding: 0 1em 1em 0;
  }

  .gv-map-view-content p {
	margin: 0 0 1em 0;
	padding: 0;
  }

  .gv-map-view-footer {
	border-top: 1px solid #ddd;
	background-color: #eee;
	padding: 1em;
  }

  .gv-grid-col-1-2 {
	float: left;
	padding-right: 0.5%;
	width: 49.5%;
  }

  .gv-left {
	text-align: left;
  }

  .gv-right {
	text-align: right;
  }

  <?php
	/* Add Additional CSS, if present */
	echo esc_html( wp_filter_nohtml_kses( $settings['additional_css'] ?? '' ) );

	do_action( 'gfpdf_gv_template_styles', $view, $view_entry );
	do_action( 'gfpdf_gv_template_styles_' . $view->ID, $view, $view_entry );
	do_action( 'gfpdf_gv_template_styles_map', $view, $view_entry );
	?>
</style>

<?php

/* Output the page the_title, if configured */
$single_title  = $view->settings->get( 'single_title', '' );
$single_title  = ! empty( $single_title ) ? $single_title : $view->get_post()->post_title;
$form['title'] = $single_title;

/** @var \GFPDF\View\View_PDF $pdf_view */
$pdf_view = \GPDFAPI::get_pdf_class();
$pdf_view->show_form_title( $settings['show_title'], $form );

/* Get all the fields for this type type */
$entry_slug         = \GravityView_API::get_entry_slug( $view_entry->ID, $entry );
$hide_empty_setting = $view->settings->get( 'hide_empty_single', false );

$the_title          = $view_fields['single_map-title'] ?? [];
$subtitle           = $view_fields['single_map-subtitle'] ?? [];
$image              = $view_fields['single_map-image'] ?? [];
$description        = $view_fields['single_map-description'] ?? [];
$content_attributes = $view_fields['single_map-content_attributes'] ?? [];
$footer_left        = $view_fields['single_map-footer-left'] ?? [];
$footer_right       = $view_fields['single_map-footer-right'] ?? [];

/* Output the container */
if ( ! empty( $the_title ) || ! empty( $subtitle ) || ! empty( $image ) || ! empty( $description ) || ! empty( $content_attributes ) || ! empty( $footer_left ) || ! empty( $footer_right ) ):
	?>
	<div id="gv_map_<?php echo esc_attr( $entry_slug ); ?>" class="gv-map-view">
		<?php
		/* Output the Title and Subtitle sections */
		if ( ! empty( $the_title ) || ! empty( $subtitle ) ):
			?>
			<div class="gv-map-view-title">
				<?php
				foreach ( $the_title as $key => $field ):
					/** @var $field \GV\GF_Field */
					Kses::output(
						gravityview_field_output(
							$key === 0 ?
								[
									'form'       => $view->form,
									'entry'      => $view_entry->as_entry(),
									'field'      => $field->as_configuration(),
									'markup'     => '<h3 id="{{ field_id }}" class="{{ class }}">' . ( $show_label ? '{{ label }} ' : '' ) . '{{ value }}</h3>',
									'hide_empty' => $hide_empty_setting,
									'zone_id'    => 'single_map-title',
								] :
								[
									'form'       => $view->form,
									'entry'      => $view_entry->as_entry(),
									'field'      => $field->as_configuration(),
									'wpautop'    => true,
									'markup'     => $default_markup,
									'hide_empty' => $hide_empty_setting,
									'zone_id'    => 'single_map-title',
								]
						)
					);
				endforeach;
				?>

				<?php if ( ! empty( $subtitle ) ): ?>
					<div class="gv-map-view-subtitle">
						<?php
						foreach ( $subtitle as $key => $field ):
							/** @var $field \GV\GF_Field */
							Kses::output(
								gravityview_field_output(
									$key === 0 ?
										[
											'form'       => $view->form,
											'entry'      => $view_entry->as_entry(),
											'field'      => $field->as_configuration(),
											'markup'     => '<h4 id="{{ field_id }}" class="{{ class }}">' . ( $show_label ? '{{ label }} ' : '' ) . '{{ value }}</h4>',
											'hide_empty' => $hide_empty_setting,
											'zone_id'    => 'single_map-subtitle',
										] :
										[
											'form'       => $view->form,
											'entry'      => $view_entry->as_entry(),
											'field'      => $field->as_configuration(),
											'wpautop'    => true,
											'markup'     => $default_markup,
											'hide_empty' => $hide_empty_setting,
											'zone_id'    => 'single_map-subtitle',
										]
								)
							);
						endforeach;
						?>
					</div>
				<?php endif; ?>
			</div>
			<?php
		endif;

		/* Output the content area */
		if ( ! empty( $image ) || ! empty( $description ) || ! empty( $content_attributes ) ):
			?>
			<div class="gv-map-view-content">
				<?php if ( ! empty( $image ) ): ?>
					<div class="gv-map-view-content-image gv-grid-col-1-3">
						<?php
						foreach ( $image as $key => $field ):
							/** @var $field \GV\GF_Field */
							Kses::output(
								gravityview_field_output(
									[
										'form'       => $view->form,
										'entry'      => $view_entry->as_entry(),
										'field'      => $field->as_configuration(),
										'markup'     => $default_markup,
										'hide_empty' => $hide_empty_setting,
										'zone_id'    => 'single_map-image',
									]
								)
							);
						endforeach;
						?>
					</div>
				<?php endif; ?>

				<?php if ( ! empty( $description ) ): ?>
					<div class="gv-map-view-content-description">
						<?php
						foreach ( $description as $key => $field ):
							/** @var $field \GV\GF_Field */
							Kses::output(
								gravityview_field_output(
									[
										'form'         => $view->form,
										'entry'        => $view_entry->as_entry(),
										'field'        => $field->as_configuration(),
										'label_markup' => $show_label ? '<h4>{{ label }}</h4>' : '',
										'wpautop'      => true,
										'markup'       => $default_markup,
										'hide_empty'   => $hide_empty_setting,
										'zone_id'      => 'single_map-description',
									]
								)
							);
						endforeach;
						?>
					</div>
				<?php endif; ?>

				<?php if ( ! empty( $content_attributes ) ): ?>
					<div class="gv-map-view-content-description">
						<?php
						foreach ( $content_attributes as $key => $field ):
							/** @var $field \GV\GF_Field */
							Kses::output(
								gravityview_field_output(
									[
										'form'       => $view->form,
										'entry'      => $view_entry->as_entry(),
										'field'      => $field->as_configuration(),
										'markup'     => '<p id="{{ field_id }}" class="{{ class }}">' . ( $show_label ? '{{ label }} ' : '' ) . '{{ value }}</p>',
										'hide_empty' => $hide_empty_setting,
										'zone_id'    => 'single_map-content-attributes',
									]
								)
							);
						endforeach;
						?>
					</div>
				<?php endif; ?>
			</div>
			<?php
		endif;

		/* Output the footer area */
		if ( ! empty( $footer_left ) || ! empty( $footer_right ) ):
			?>
			<div class="gv-grid gv-map-view-footer">
				<div class="gv-grid-col-1-2 gv-left">
					<?php
					foreach ( $footer_left as $key => $field ):
						/** @var $field \GV\GF_Field */
						Kses::output(
							gravityview_field_output(
								[
									'form'       => $view->form,
									'entry'      => $view_entry->as_entry(),
									'field'      => $field->as_configuration(),
									'markup'     => $default_markup,
									'hide_empty' => $hide_empty_setting,
									'zone_id'    => 'single_map-footer-left',
								]
							)
						);
					endforeach;

					echo empty( $footer_left ) ? '&nbsp;' : '';
					?>
				</div>

				<div class="gv-grid-col-1-2 gv-right">
					<?php
					foreach ( $footer_right as $key => $field ):
						/** @var $field \GV\GF_Field */
						Kses::output(
							gravityview_field_output(
								[
									'form'       => $view->form,
									'entry'      => $view_entry->as_entry(),
									'field'      => $field->as_configuration(),
									'markup'     => $default_markup,
									'hide_empty' => $hide_empty_setting,
									'zone_id'    => 'single_map-footer-right',
								]
							)
						);
					endforeach;

					echo empty( $footer_right ) ? '&nbsp;' : '';
					?>
				</div>
			</div>
		<?php endif ?>
	</div>
<?php endif ?>
