<?php

namespace GFPDF\Plugins\PdfForGravityView\Pdf\ThirdParty;

use GFPDF\Plugins\PdfForGravityView\Pdf\Renderer;

/**
 * @package     PDF for GravityView
 * @copyright   Copyright (c) 2025, Blue Liquid Designs
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 */

/* Exit if accessed directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * @since 1.0.4
 */
class GravityWizNestedForms {

	public function init() {
		add_filter( 'gp_template_paths', [ $this, 'add_nested_forms_override_path' ], 10, 2 );
		add_action( 'gfpdf_gv_template_styles', [ $this, 'nested_form_pdf_styles' ] );
	}

	/**
	 * Register new template path for Gravity Wiz Nested Forms
	 *
	 * @param array        $paths
	 * @param \GP_Template $template
	 *
	 * @return array
	 *
	 * @since 1.0.4
	 */
	public function add_nested_forms_override_path( $paths, $template ) {
		if ( ! Renderer::is_pdf_endpoint() || ! $template->plugin instanceof \GP_Nested_Forms ) {
			return $paths;
		}

		$paths[0] = plugin_dir_path( GFPDF_PDF_FOR_GV_FILE ) . 'src/Pdf/Fields/';

		return $paths;
	}

	/**
	 * Add CSS for PDFs which styles the Nested Forms
	 *
	 * @return void
	 *
	 * @since 1.0.4
	 */
	public function nested_form_pdf_styles() {
		?>
		.gpnf-nested-entries-pdf-table th {
			text-align: left;
		}

		.gpnf-nested-entries-hr {
			color: #FFF;
		}
		<?php
	}
}
