<?php

namespace GFPDF\Plugins\PdfForGravityView;

/**
 * @package     PDF for GravityView
 * @copyright   Copyright (c) 2025, Blue Liquid Designs
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 */

/* Exit if accessed directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * @package GFPDF\Plugins\PdfForGravityView
 */
class BootstrapGravityKit extends Bootstrap {

	/**
	 * Unregister the plugin from Gravity PDF
	 *
	 * @param $classes
	 *
	 * @return void
	 *
	 * @since 0.9
	 */
	public function init( $classes = [] ) {
		parent::init( $classes );

		remove_action( 'init', [ $this, 'plugin_updater' ] );
		remove_action( 'admin_init', [ $this, 'maybe_schedule_license_check' ] );
		remove_action( 'gfpdf_' . $this->get_slug() . '_license_check', [ $this, 'schedule_license_check' ] );
		remove_action( 'after_plugin_row_' . plugin_basename( $this->get_main_plugin_file() ), [ $this, 'license_registration' ] );
		remove_filter( 'plugin_row_meta', [ $this, 'plugin_row_meta' ] );
	}

	/**
	 * Prevent registration with Gravity PDF
	 *
	 * @return void
	 *
	 * @since 0.9
	 */
	protected function register_addon() {}
}
