<?php

namespace GP_Email_Validator\Results;

use GP_Email_Validator\Validators\Basic_Validator;

/**
 * Basic validation result using stymiee/email-validator.
 *
 * @phpstan-type BasicMetadata array{
 *   has_mx_records: bool,
 *   is_disposable: bool,
 *   is_free_email: bool,
 *   is_invalid_format: bool,
 *   is_gmail_plus: bool
 * }
 *
 * @extends Validation_Result<BasicMetadata>
 */
class Basic_Validation_Result extends Validation_Result {
	/**
	 * @var Basic_Validator
	 */
	protected $validator;

	protected function normalize( array $response ) {
		$rejection_settings = $this->validator->get_rejection_settings();

		// Set basic fields
		$this->is_valid = $response['is_valid'] ?? false;
		$this->status   = $response['status'] ?? 'unknown';

		// Set metadata
		/** @var BasicMetadata $metadata */
		$metadata       = [
			'has_mx_records'    => $response['has_mx_records'] ?? false,
			'is_disposable'     => $response['is_disposable'] ?? false,
			'is_free_email'     => $response['is_free_email'] ?? false,
			'is_invalid_format' => $response['is_invalid_format'] ?? false,
			'is_gmail_plus'     => $response['is_gmail_plus'] ?? false,
		];
		$this->metadata = $metadata;

		// Handle Gmail plus addressing
		if ( isset( $response['sanitized_email'] ) ) {
			$this->sanitized_email = $response['sanitized_email'];
		}

		$messages = $this->validator->get_error_messages();
		$reason   = $response['reason'] ?? '';

		if ( isset( $messages[ $reason ] ) ) {
			$this->add_reason( $reason, $messages[ $reason ] );
		}

		// Add additional context as separate reasons based on rejection settings
		if ( ! $metadata['has_mx_records'] && $rejection_settings['mx_record'] ) {
			$this->add_reason(
				'no_mx_record',
				$messages['no_mx_record']
			);
		}

		if ( $metadata['is_disposable'] && $rejection_settings['disposable_email'] ) {
			$this->add_reason(
				'disposable_email',
				$messages['disposable_email']
			);
		}

		if ( $metadata['is_free_email'] && $rejection_settings['free_email'] ) {
			$this->add_reason(
				'free_email',
				$messages['free_email']
			);
		}

		if ( $metadata['is_invalid_format'] ) {
			$this->add_reason(
				'invalid_format',
				$messages['invalid_format']
			);
		}
	}
}
