<?php

namespace GP_Email_Validator\Results;

/**
 * Domain validation result for handling domain-based email rejections.
 *
 * This result type handles domain allow/block validation failures
 * while providing detailed error information.
 *
 * @phpstan-type DomainValidationMetadata array{
 *   result: string,
 *   reason: string,
 *   message: string
 * }
 */
class Domain_Validation_Result extends Validation_Result {
	protected function normalize( array $response ) {
		// Domain validation always results in a blocked email
		$this->is_valid = false;
		$this->status   = 'invalid';

		// Set metadata
		/** @var DomainValidationMetadata $metadata */
		$metadata       = [
			'result'  => $response['result'] ?? 'failed_domain_validation',
			'reason'  => $response['reason'] ?? 'domain_validation_failed',
			'message' => $response['message'] ?? __( 'Email domain is not allowed.', 'gp-email-validator' ),
		];
		$this->metadata = $metadata;

		// Add domain validation reason
		$this->add_reason(
			$metadata['reason'],
			$metadata['message']
		);
	}
}
