<?php

namespace GP_Email_Validator\Results;

use GP_Email_Validator\Validators\Validator;

/**
 * Error validation result for handling API/configuration errors.
 *
 * This result type allows form submission to proceed while still
 * showing error details in the entry view.
 *
 * @phpstan-type ErrorMetadata array{
 *   error: string
 * }
 */
class Error_Validation_Result extends Validation_Result {
	protected function normalize( array $response ) {
		// Always allow submission
		$this->is_valid = true;
		$this->status   = 'error';

		// Set metadata
		/** @var ErrorMetadata $metadata */
		$metadata       = [
			'error' => $response['error'] ?? __( 'Unknown error occurred.', 'gp-email-validator' ),
		];
		$this->metadata = $metadata;

		// Add error reason
		$this->add_reason(
			'api_error',
			$this->metadata['error']
		);
	}
}
