<?php

namespace GP_Email_Validator\Results;

use GP_Email_Validator\Validators\Kickbox_Validator;

/**
 * Kickbox validation result.
 *
 * @phpstan-type KickboxMetadata array{
 *   result: 'deliverable'|'undeliverable'|'risky'|'unknown',
 *   reason: string,
 *   role: bool,
 *   free: bool,
 *   disposable: bool,
 *   accept_all: bool,
 *   did_you_mean: string|null,
 *   sendex: float,
 *   email: string,
 *   user: string,
 *   domain: string,
 *   success: bool,
 *   message: string|null
 * }
 *
 * @extends Validation_Result<KickboxMetadata>
 */
class Kickbox_Validation_Result extends Validation_Result {
	/**
	 * @var Kickbox_Validator
	 */
	protected $validator;

	protected function normalize( array $response ) {
		$rejection_settings = $this->validator->get_rejection_settings();

		// Set basic fields
		$this->is_valid   = $response['success'] ?? false;
		$this->status     = $response['result'] ?? 'unknown';
		$this->suggestion = $this->validator->should_show_suggestions() ? ( $response['did_you_mean'] ?? null ) : null;

		// Set metadata
		/** @var KickboxMetadata $metadata */
		$metadata = [
			'result'       => $response['result'] ?? 'unknown',
			'reason'       => $response['reason'] ?? '',
			'role'         => $response['role'] ?? false,
			'free'         => $response['free'] ?? false,
			'disposable'   => $response['disposable'] ?? false,
			'accept_all'   => $response['accept_all'] ?? false,
			'did_you_mean' => $response['did_you_mean'] ?? null,
			'sendex'       => $response['sendex'] ?? 0.0,
			'email'        => $response['email'] ?? $this->email,
			'user'         => $response['user'] ?? '',
			'domain'       => $response['domain'] ?? '',
			'success'      => $response['success'] ?? false,
			'message'      => $response['message'] ?? null,
		];

		$this->metadata = $metadata;

		$messages = $this->validator->get_error_messages();

		if ( isset( $rejection_settings[ $metadata['result'] ] ) && $rejection_settings[ $metadata['result'] ] ) {
			$this->add_reason(
				$metadata['reason'],
				$messages[ $metadata['reason'] ]
			);
		}

		// If success is false, and there is a message, add it as a failure reason
		if ( ! $metadata['success'] && $metadata['message'] ) {
			$this->add_reason(
				'message',
				$metadata['message']
			);
		}
	}
}
