window.jQuery!(function ($) {
	// Extend GF tooltips to add a class to content if called from our tooltip buttons.
	// @ts-ignore
	if (typeof jQuery.fn.tooltip !== 'undefined') {
		// @ts-ignore
		const existingTooltipClass = jQuery('.gf_tooltip').tooltip(
			'option',
			'tooltipClass'
		);

		// @ts-ignore
		jQuery('.gf_tooltip').tooltip('option', 'tooltipClass', function () {
			const classes = [];

			if (typeof existingTooltipClass === 'string') {
				classes.push(existingTooltipClass.split(' '));
			}

			classes.push('gpev_tooltip_content');

			return classes.join(' ');
		});
	}

	// Set rules to defaults when switching to/from custom rules in Plugin Settings
	$('[name="_gform_setting_validator_rules"]').on('change', function () {
		const ruleDefaults = {
			mx_record: true,
			disposable_email: true,
			free_email: false,
			sanitize_gmail: false,
		};

		for (const [setting, defaultValue] of Object.entries(ruleDefaults)) {
			$(`#${setting}`).prop('checked', defaultValue);

			// Update hidden input.
			$(`[name="_gform_setting_${setting}"]`).val(
				defaultValue ? '1' : '0'
			);
		}
	});
});
