# Gravity Forms - OTP Verification (SMS/EMAIL)

![WordPress Plugin](https://img.shields.io/wordpress/plugin/v/gravity-otp-verification)
![Gravity Forms](https://img.shields.io/badge/Compatible%20with-Gravity%20Forms-blue)
![License](https://img.shields.io/badge/license-GPL--2.0-blue.svg)

A powerful plugin for Gravity Forms that adds OTP verification via SMS/Email to your forms for FREE.

>**Gravity Forms - OTP Verification** allows you to add **One-Time Password (OTP) verification** to Gravity Forms, ensuring that users enter a valid mobile number or email address before submitting a form. It helps prevent spam, fake submissions, and ensures real user authentication.

## Features
- 🔒 **Secure Mobile Verification** – Ensures users verify their phone numbers before submitting.
- ✅ **Seamless Gravity Forms Integration** – Works with all versions of Gravity Forms without conflicts.
- 🌎 **Supports Persian, Arabic & English Numbers** – Converts and validates all number formats.
- 📡 **Flexible SMS Gateway Support** – Connects to multiple SMS providers via built-in integrations or custom hooks.
- ⚙️ **Easy Setup** – Configure in just a few clicks with user-friendly settings.
## FAQ
### How does OTP Verification work?
Once a user enters their mobile number or email address, they receive an **OTP Code**. They must **enter the correct OTP** before submitting the form.
### Can I use my own SMS provider?
Yes! The plugin supports **multiple SMS gateways**, and you can **add your own** via hooks.
### Does this plugin support Persian & Arabic numbers?
Yes! The plugin **automatically converts** Persian and Arabic numerals to English before validation.
### Does it work with all Gravity Forms versions?
Yes! It is tested and compatible with **all recent Gravity Forms versions**.
### How can I contribute to this plugin?
You can contribute by submitting your changes to our **GitHub repository**:
➡️ [GitHub Repository](https://github.com/pigment-dev/gravity-otp-verification)
## Disclaimer and Warranty
This plugin is provided **"as is"** without any warranties, express or implied. While every effort has been made to ensure reliability and security, the developers are not responsible for any issues arising from its use. Always test in a **staging environment** before deploying to production.
## Contribution and Support
We welcome contributions to improve the plugin! If you have feature requests, bug reports, or suggestions, please create a GitHub issue or pull request.

For support, contact us at **[support (@) pigment (.) dev](mailto:support@pigment.dev)**.
## License
This plugin is licensed under **GPLv2 or later**. See [LICENSE](https://www.gnu.org/licenses/gpl-2.0.html) for details.
## Changelog

#### v3.0.1 | 2025-09-03 | 1404-06-12
- Updated Readme to added patchstack vdp link for reporting security bugs.

#### v3.0.0 | 2025-08-04 | 1404-05-13
- Added **WP-SMS** plugin as an OTP SMS gateway option.
- Added **Email OTP verification** alongside Mobile OTP verification.
- Added option to customize the email sender name and address for OTP emails.
- Introduced an email template (HTML) editor with a default template for OTP messages.
- Added **Persian translation** to WordPress plugin repository.
- Added **Persian translation** to WordPress plugin repository.
- Upgraded offloaded **Font Awesome** to version 7.

#### v2.7.0 | 2025-05-15 | 1404-02-25
- Added Persian WooCommerce SMS as Gateway
- Fix Log panel not loaded

#### v2.6.0 | 2025-04-30 | 1404-02-10
- Update WordPress version
- Fix GF-Panel not Loaded

#### v2.5.0 | 2025-04-02 | 1404-01-13
- General fixes and Enhancement

#### v2.4.0 | 2025-03-31 | 1404-01-11
- General fixes and Enhancement

#### v2.3.0 | 2025-03-20 | 1403-12-30
- Initial release of the plugin for w.org