document.addEventListener('DOMContentLoaded', function () {
	// Regex to find mentions in the format @[DisplayName](user:UserID)
	const MENTION_REGEX = /@\[([^\]]+)\]\(user:(\d+)\)/g;
	const noteContentElements = document.querySelectorAll('.note-content');

	noteContentElements.forEach(function (element) {
		const originalHTML = element.innerHTML;
		// Replace mentions with the HTML structure
		const newHTML = originalHTML.replace(
			MENTION_REGEX,
			function (match, displayName, userId) {
				// Sanitize display name by creating a temporary element
				const tempEl = document.createElement('div');
				tempEl.textContent = displayName;
				const escapedDisplayName = tempEl.innerHTML;

				return `<span class="gk-gravityboard-mention" data-user-id="${parseInt(userId, 10)}">@${escapedDisplayName}</span>`;
			}
		);

		if (originalHTML !== newHTML) {
			element.innerHTML = newHTML;
		}
	});
});
