<?php
/**
 * Plugin Name: GravityBoard
 * Plugin URI: https://www.gravitykit.com/products/gravityboard/
 * Description: A plugin to display Gravity Forms entries in a kanban board view.
 * Text Domain: gk-gravityboard
 * Domain Path: /languages
 * Version: 1.2.1
 * Requires at least: 6.2
 * Requires PHP: 7.4
 * Tested up to: 6.8.2
 * Author: GravityKit
 * Author URI: https://www.gravitykit.com
 * License: GPL-2.0+
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

namespace GravityKit\GravityBoard;

$preflight_check_path = plugin_dir_path( __FILE__ ) . 'vendor_prefixed/gravitykit/foundation/src/preflight_check.php';

if ( is_readable( $preflight_check_path ) ) {
	require_once $preflight_check_path;
} else {
	return;
}

if ( ! Foundation\should_load( __FILE__ ) ) {
	return;
}

if ( ! Foundation\meets_min_php_version_requirement( __FILE__, '7.4.0' ) ) {
	return;
}

define( 'GRAVITYBOARD_FILE', __FILE__ );
define( 'GRAVITYBOARD_PATH', plugin_dir_path( GRAVITYBOARD_FILE ) );
define( 'GRAVITYBOARD_VERSION', '1.2.1' );

require_once GRAVITYBOARD_PATH . 'vendor/autoload.php';
require_once GRAVITYBOARD_PATH . 'vendor_prefixed/autoload.php';

Foundation\Core::register( GRAVITYBOARD_FILE );

// Widgets need foundation to be initialized to calculate the secret.
add_action( 'gk/foundation/initialized', __NAMESPACE__ . '\register_addon' );

/**
 * Register the GravityBoard addon and initialize all components.
 */
function register_addon() {

	if ( ! class_exists( '\GFCommon' ) || version_compare( \GFCommon::$version, '2.6', '<' ) ) {
		add_error_notice();
		return;
	}

	Renderer::get_instance();
	Notifications::get_instance();
	Attachments\Attachments::get_instance();
	Attachments\Entry_Meta::get_instance();
	Checklists\Checklists::get_instance();
	Checklists\Entry_Meta::get_instance();
	Assignees\Assignees::get_instance();
	Assignees\MergeTags::get_instance();
	Blocks\GravityBoard\Block::get_instance();
	Notes\Notes::get_instance();
	BoardsOverview\Boards_Overview::get_instance();

	Integrations\GravityView::get_instance();

	Admin\Admin::get_instance();
	Admin\Board_View::init();

	/**
	 * Important: Always load the AJAX class last to allow other classes
	 * to register their own AJAX actions.
	 */
	Ajax::get_instance();
}

/**
 * Show an error notice if the plugin is not compatible with the current Gravity Forms version.
 *
 * @since 1.0.0
 *
 * @return void
 */
function add_error_notice() {
	add_action(
		'admin_notices',
		function () {
			$notice = wpautop(
				strtr(
					// Translators: Do not translate the placeholders [plugin], [requirement], and [version].
					esc_html__( '[plugin] requires [requirement] [version] or newer to be installed and activated.', 'gk-gravityboard' ),
					[
						'[plugin]'      => 'GravityBoard',
						'[requirement]' => '<a href="https://www.gravitykit.com/gravityforms" rel="noopener noreferrer">Gravity Forms</a>',
						'[version]'     => '2.6',
					]
				)
			);

			echo "<div class='error' style='padding: 1.25em 0 1.25em 1em;'>$notice</div>"; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
		}
	);
}
