const Edit = ( { attributes, setAttributes } ) => {
	const wp = window.wp;
	const config = window.gravityflowchecklists_config;
	const { __ } = wp.i18n;
	const registerBlockType = wp.blocks.registerBlockType;
	const { serverSideRender: ServerSideRender } = wp;
	const { InspectorControls } = wp.blockEditor;
	const { PanelBody, SelectControl, ToggleControl, TextControl } = wp.components;
	const checklists = config.checklists;

	const getChecklistOptions = () => {
		const options = [
			{
				label: __( 'Select a Checklist', 'gravityflowchecklists' ),
				value: '',
			},
		];

		for ( let i = 0; i < checklists.length; i++ ) {
			const checklistName = checklists[ i ];

			options.push( {
				label: checklistName,
				value: checklistName,
			} );
		}

		return options;
	};

	const renderSidebarControls = () => {

		const inspectorControlsAttributes = {
			key: 'inspector',
		};

		const formSettingsPanelAttributes = {
			title: __( 'Checklist Settings', 'gravityflowchecklists' ),
		};

		const checklistSelectorAttributes = {
			label:  __( 'Checklist', 'gravityflowchecklists' ),
			value: attributes.checklist,
			options: getChecklistOptions(),
			onChange: ( newChecklist ) => setAttributes( { checklist: newChecklist } ),
		};

		const themeInputAttributes = {
			label:  __( 'Theme', 'gravityflowchecklists' ),
			value: attributes.theme,
			onChange: ( newTheme ) => setAttributes( { theme: newTheme } ),
		};

		const singlePageToggleAttributes = {
			label:  __( 'Display on Single Page', 'gravityflowchecklists' ),
			checked: attributes.singlePage,
			onChange: () => setAttributes( { singlePage: ! attributes.singlePage } ),
		};

		return (
			<InspectorControls { ...inspectorControlsAttributes }>
				<PanelBody { ...formSettingsPanelAttributes }>
					<SelectControl { ...checklistSelectorAttributes }/>
					<TextControl { ...themeInputAttributes } />
					<ToggleControl { ...singlePageToggleAttributes } />
				</PanelBody>
			</InspectorControls>
		);
	}

	const passedAttrs = {
		checklist: attributes.checklist,
		theme: attributes.theme,
		singlePage: attributes.singlePage,
	};

	return (
		<div>
			{ renderSidebarControls() }
			<ServerSideRender
				block="gravityflow/checklists"
				attributes={ passedAttrs }
			/>
		</div>
	);
};

export default Edit;