/**
 * WordPress dependencies
 */
import { __ } from '@wordpress/i18n';

const variations = [
	{
		name: 'roundGrids',
		title: __('Round Grids', 'wpuf-pro'),
		icon: (window.wpufUserDirectory?.asset_url || '') + '/images/round-grids.png',
		attributes: {
			roles: 'all',
			directory_layout: 'roundGrids',
			max_item_per_page: 9,
			enable_frontend_sorting: true,
			available_sort_options: ['id', 'user_login', 'user_email', 'display_name', 'user_registered'],
			enable_search: true
		},
		innerBlocks: [
            [
                'wpuf-ud/directory-item',
                {},
                [
                    [
                        'core/group',
                        {
                            className: 'is-style-default',
                            style: {
                                border: {
                                    radius: '8px',
                                    color: '#d1d5db',
                                    width: '1px'
                                },
                                spacing: {
                                    margin: {
                                        top: '0',
                                        bottom: '0'
                                    },
                                    blockGap: '0',
                                    padding: {
                                        top: 'var:preset|spacing|30',
                                        bottom: 'var:preset|spacing|30',
                                        left: '0',
                                        right: '0'
                                    }
                                },
                            },
                            layout: {
                                type: 'flex',
                                orientation: 'vertical',
                                justifyContent: 'center'
                            }
                        },
                        [
                            [
                                'wpuf-ud/avatar',
                                {
                                    avatarSize: 'custom',
                                    fallbackType: 'gravatar',
                                    customSize: 128,
                                    style: {
                                        spacing: {
                                            padding: {
                                                bottom: '15px'
                                            },
                                            margin: {
                                                top: '3px'
                                            }
                                        }
                                    }
                                }
                            ],
                            [
                                'wpuf-ud/name',
                                {
                                    textAlign: 'center',
                                    style: {
                                        color: '#0F172A',
                                        fontWeight: 'bold',
                                        typography: {
                                            fontStyle: 'normal',
                                            fontWeight: '600',
                                            fontSize: '20px',
                                            lineHeight: '2'
                                        },
                                        spacing: {
                                            margin: {
                                                bottom: '2px'
                                            }
                                        }
                                    }
                                }
                            ],
                            [
                                'wpuf-ud/contact',
                                {
                                    showIcons: false,
                                    iconSize: 'small',
                                    showLabels: false,
                                    className: 'wpuf-user-contact-info wpuf-contact-layout-inline',
                                    style: {
                                        color: {
                                            text: '#64748B'
                                        },
                                        typography: {
                                            lineHeight: '1',
                                            textAlign: 'center',
                                            fontSize: '14px'
                                        },
                                        spacing: {
                                            margin: {
                                                bottom: '5px'
                                            }
                                        }
                                    }
                                }
                            ],
							// Insertion point for unmatched blocks
							['wpuf-ud/unmatched-blocks', {}],
                            [
                                'wpuf-ud/social',
                                {
                                    iconSize: 'medium',
                                    style: {
                                        spacing: {
                                            padding: {
                                                top: '5px',
                                                bottom: '5px'
                                            },
                                            margin: {
                                                top: '5px',
                                                bottom: '5px'
                                            }
                                        }
                                    }
                                }
                            ],
                            [
                                'wpuf-ud/profile-button',
                                {
                                    textColor: 'base',
                                    style: {
                                        border: {
                                            radius: '6px'
                                        },
                                        spacing: {
                                            padding: {
                                                top: '9px',
                                                right: '17px',
                                                bottom: '9px',
                                                left: '17px'
                                            },
                                            margin: {
                                                top: '14px',
                                                bottom: '8px'
                                            }
                                        },
                                        marginTop: '16px',
                                        typography: {
                                            fontStyle: 'normal',
                                            fontWeight: '400',
                                            fontSize: '14px',
                                        },
                                        color: {
                                            background: '#7c3aed'
                                        }
                                    }
                                }
                            ]
                        ]
                    ]
                ]
            ]
		],
		scope: ['block'],
	},
	{
		name: 'squareGrids',
		title: __('Square Grids', 'wpuf-pro'),
		icon: (window.wpufUserDirectory?.asset_url || '') + '/images/square-grid.png',
		attributes: {
			roles: 'all',
			directory_layout: 'squareGrids',
			hasSelectedLayout: true,
			selectedLayout: 'squareGrids',
			max_item_per_page: 50,
			orderby: 'id',
			available_sort_options: ['id', 'user_login', 'user_email', 'display_name', 'user_registered'],
			order: 'asc',
			enable_frontend_sorting: true
		},
		innerBlocks: [
			[
				'wpuf-ud/directory-item',
				{
					style: {
						spacing: {
							padding: {
								top: '0',
								bottom: '0',
								left: '0px',
								right: '0px'
							},
							margin: {
								right: '0',
								left: '0',
								top: '16px'
							}
						},
						border: {
							width: '0px',
							style: 'none',
							radius: '0px'
						}
					},
					layout: {
						type: 'constrained'
					}
				},
				[
					[
						'core/group',
						{
							layout: {
								type: 'flex',
								orientation: 'vertical',
								justifyContent: 'center'
							}
						},
						[
							[
								'wpuf-ud/avatar',
								{
									avatarSize: 'xlarge',
									avatarShape: 'rounded',
									fallbackType: 'gravatar',
									customSize: 240,
									style: {
										spacing: {
											padding: {
												top: '0',
												left: '0px',
												right: '0px',
												bottom: '0'
											},
											margin: {
												top: '0px',
												bottom: '0px',
												left: '0',
												right: '0'
											}
										},
										layout: {
											selfStretch: 'fit',
											flexSize: null
										}
									}
								}
							],
							[
								'wpuf-ud/name',
								{
									textAlign: 'center',
									style: {
										color: '#0F172A',
										fontWeight: 'bold',
										typography: {
											fontStyle: 'normal',
											fontWeight: '600',
											fontSize: '20px',
											lineHeight: '2'
										}
									}
								}
							],
							[
								'wpuf-ud/contact',
								{
									showIcons: false,
									iconSize: 'small',
									showLabels: false,
									className: 'wpuf-user-contact-info wpuf-contact-layout-inline',
									style: {
										color: {
											text: '#64748B'
										},
										typography: {
											textAlign: 'center',
											fontSize: '14px'
										},
										spacing: {
											margin: {
												bottom: '0px',
												top: '3px'
											}
										}
									}
								}
							],
							                            [
                                'wpuf-ud/social',
                                {
                                    iconSize: 'medium',
                                    style: {
                                        spacing: {
                                            padding: {
                                                top: '0'
                                            },
                                            margin: {
                                                top: 'var:preset|spacing|20',
                                                bottom: '0'
                                            }
                                        },
                                        typography: {
                                            lineHeight: '1'
                                        }
                                    }
                                }
                            ],
                            // Insertion point for unmatched blocks
                            ['wpuf-ud/unmatched-blocks', {}],
                            [
                                'wpuf-ud/profile-button',
                                {
                                    buttonText: 'Edit Profile',
                                    textColor: 'base',
                                    style: {
                                        color: {
                                            background: '#1f2937'
                                        },
                                        border: {
                                            radius: '6px'
                                        },
                                        spacing: {
                                            padding: {
                                                left: '17px',
                                                right: '17px',
                                                top: '9px',
                                                bottom: '9px'
                                            },
                                            margin: {
                                                top: '10px'
                                            }
                                        },
                                        marginTop: '16px',
                                        typography: {
                                            fontSize: '14px'
                                        }
                                    }
                                }
                            ]
						]
					]
				]
			]
		],
		scope: ['block'],
	},
	{
		name: 'sidecards',
		title: __('Sidecards', 'wpuf-pro'),
		icon: (window.wpufUserDirectory?.asset_url || '') + '/images/sidecards.png',
		attributes: {
			roles: 'all',
			directory_layout: 'sidecards',
			hasSelectedLayout: true,
			selectedLayout: 'sidecards',
			max_item_per_page: 50,
			order: 'asc',
			enable_frontend_sorting: true,
			available_sort_options: ['id', 'user_login', 'user_email', 'display_name', 'user_registered']
		},
		innerBlocks: [
			[
				'wpuf-ud/directory-item',
				{},
				[
					[
						'core/group',
						{
							style: {
								border: {
									radius: '8px',
									color: '#d1d5d8',
									width: '1px'
								},
								spacing: {
									padding: {
										top: '20px',
										bottom: '20px',
										left: '20px',
										right: '20px'
									},
									blockGap: '24px',
									margin: {
										top: '20px',
										bottom: '20px'
									}
								}
							},
							layout: {
								type: 'flex',
								flexWrap: 'nowrap',
								justifyContent: 'left',
								orientation: 'horizontal',
								verticalAlignment: 'top'
							}
						},
						[
							[
								'core/group',
								{
									style: {
										border: {
											radius: '0px'
										}
									},
									layout: {
										type: 'flex',
										flexWrap: 'nowrap',
										orientation: 'vertical',
										justifyContent: 'left'
									}
								},
								[
									[
										'wpuf-ud/avatar',
										{
											avatarSize: 'custom',
											avatarShape: 'rounded',
											fallbackType: 'gravatar',
											customSize: 128,
											style: {
												spacing: {
													margin: {
														left: '0'
													},
													padding: {
														left: '0'
													}
												}
											}
										}
									]
								]
							],
							[
								'core/group',
								{
									layout: {
										type: 'flex',
										orientation: 'vertical',
										justifyContent: 'left'
									}
								},
								[
									[
										'wpuf-ud/name',
										{
											style: {
												color: '#0F172A',
												fontWeight: 'bold',
												typography: {
													fontStyle: 'normal',
													fontWeight: '600',
													fontSize: '20px',
													lineHeight: '1.3'
												},
												spacing: {
													padding: {
														top: '0'
													},
													margin: {
														top: '0',
														bottom: '0'
													}
												},
												layout: {
													selfStretch: 'fit',
													flexSize: null
												}
											}
										}
									],
									[
										'wpuf-ud/contact',
										{
											showIcons: false,
											showLabels: false,
											className: 'wpuf-user-contact-info wpuf-contact-layout-list',
											style: {
												color: {
													text: '#64748B'
												},
												typography: {
													fontSize: '14px',
													lineHeight: '1'
												},
												spacing: {
													padding: {
														top: '0',
														left: '0'
													}
												}
											}
										}
									],
									// Insertion point for unmatched blocks
									['wpuf-ud/unmatched-blocks', {}],
									[
										'wpuf-ud/social',
										{
											iconSize: 'medium',
											fontSize: 'small',
											style: {
												typography: {
													lineHeight: '0',
													fontStyle: 'normal',
													fontWeight: '700'
												},
												spacing: {
													padding: {
														top: '0px'
													},
													margin: {
														top: '15px'
													}
												}
											}
										}
									],
									[
										'wpuf-ud/profile-button',
										{
											textColor: 'base',
											style: {
												border: {
													radius: '6px'
												},
												spacing: {
													padding: {
														right: '17px',
														left: '17px',
														top: '9px',
														bottom: '9px'
													},
													margin: {
														top: '0',
														bottom: '0',
														left: '0',
														right: '0'
													}
												},
												marginTop: '16px',
												color: {
													background: '#3b82f6'
												},
												typography: {
													fontSize: '14px'
												}
											}
										}
									]
								]
							]
						]
					]
				]
			]
		],
		scope: ['block'],
	},
	{
		name: 'wideSidecards',
		title: __('Wide Sidecards', 'wpuf-pro'),
		icon: (window.wpufUserDirectory?.asset_url || '') + '/images/wide-sidecards.png',
		attributes: {
			roles: 'all',
			directory_layout: 'wideSidecards',
			max_item_per_page: 50,
			orderby: 'id',
			available_sort_options: ['id', 'display_name', 'user_login', 'user_email', 'user_registered'],
			order: 'asc',
			enable_frontend_sorting: true,
			style: {
				spacing: {
					margin: {
						top: '0',
						bottom: '0',
						left: '0',
						right: '0'
					},
					padding: {
						right: '0',
						left: '0'
					}
				}
			},
			layout: {
				type: 'default'
			}
		},
		innerBlocks: [
			[
				'wpuf-ud/directory-item',
				{
					layout: {
						type: 'default'
					}
				},
				[
					[
						'core/group',
						{
							style: {
								border: {
									radius: '8px',
									color: '#d1d5d8',
									width: '1px'
								}
							},
							layout: {
								type: 'flex',
								flexWrap: 'nowrap',
								justifyContent: 'space-between'
							}
						},
						[
							[
								'core/group',
								{
									style: {
										dimensions: {
											minHeight: '0px'
										},
										spacing: {
											padding: {
												top: '0',
												bottom: '0',
												left: '0',
												right: '0'
											},
											margin: {
												top: '0',
												bottom: '0'
											}
										}
									},
									layout: {
										type: 'flex',
										flexWrap: 'nowrap',
										verticalAlignment: 'top'
									}
								},
								[
									[
										'core/group',
										{
											style: {
												spacing: {
													padding: {
														left: '0px'
													}
												}
											},
											layout: {
												type: 'flex',
												orientation: 'vertical'
											}
										},
										[
											[
												'wpuf-ud/avatar',
												{
													avatarSize: 'custom',
													avatarShape: 'rounded',
													fallbackType: 'gravatar',
													customSize: 128,
													style: {
														spacing: {
															padding: {
																top: '0',
																bottom: '0'
															},
															margin: {
																top: '15px',
																bottom: 'var:preset|spacing|20',
																left: '15px',
																right: 'var:preset|spacing|20'
															}
														}
													}
												}
											]
										]
									],
									[
										'core/group',
										{
											style: {
												spacing: {
													padding: {
														left: '0'
													},
													blockGap: '0'
												}
											},
											fontSize: 'small',
											layout: {
												type: 'flex',
												orientation: 'vertical',
												justifyContent: 'left'
											}
										},
										[
											[
												'wpuf-ud/name',
												{
													style: {
														color: '#0F172A',
														fontWeight: 'bold',
														typography: {
															fontStyle: 'normal',
															fontWeight: '600',
															lineHeight: '2',
															fontSize: '20px'
														},
														spacing: {
															padding: {
																top: '0'
															},
															margin: {
																top: '5px',
																bottom: '0'
															}
														},
														layout: {
															selfStretch: 'fit',
															flexSize: ''
														}
													}
												}
											],
											[
												'wpuf-ud/contact',
												{
													layoutStyle: 'inline',
													showIcons: false,
													showLabels: false,
													className: 'wpuf-user-contact-info wpuf-contact-layout-list',
													style: {
														color: {
															text: '#64748B'
														},
														spacing: {
															padding: {
																top: '0',
																left: '0'
															}
														},
														typography: {
															lineHeight: '1',
															fontSize: '14px'
														}
													}
												}
											],
											// Insertion point for unmatched blocks
											['wpuf-ud/unmatched-blocks', {}]
											[
												'wpuf-ud/social',
												{
													iconSize: 'medium',
													style: {
														typography: {
															fontSize: '24px'
														},
														spacing: {
															margin: {
																bottom: '0px',
																top: 'var:preset|spacing|40'
															}
														}
													}
												}
											]
										]
									]
								]
							],
							[
								'core/group',
								{
									style: {
										spacing: {
											margin: {
												bottom: '0'
											}
										}
									},
									fontSize: 'small',
									layout: {
										type: 'flex',
										flexWrap: 'nowrap',
										justifyContent: 'right'
									}
								},
								[
									[
										'wpuf-ud/profile-button',
										{
											buttonText: 'See Profile',
											textColor: 'base',
											fontSize: 'small',
											style: {
												color: {
													background: '#059669'
												},
												border: {
													radius: '6px'
												},
												spacing: {
													padding: {
														top: '9px',
														right: '17px',
														bottom: '9px',
														left: '17px'
													},
													margin: {
														top: '0',
														bottom: '0',
														left: '0',
														right: '20px'
													}
												},
												marginTop: '16px',
												typography: {
													fontStyle: 'normal',
													fontWeight: '500'
												}
											}
										}
									]
								]
							]
						]
					]
				]
			]
		],
		scope: ['block'],
	},
	{
		name: 'table',
		title: __('Table', 'wpuf-pro'),
		icon: (window.wpufUserDirectory?.asset_url || '') + '/images/directory-table.png',
		attributes: {
			roles: 'all',
			directory_layout: 'table',
			max_item_per_page: 10,
			profile_base: 'user',
			enable_frontend_sorting: true,
			enable_search: true,
			show_avatar: true,
			avatar_size: 'medium',
			avatar_shape: 'circle',
			avatar_fallback_type: 'initial',
			table_columns: ['username', 'email', 'display_name']
		},
		scope: ['block'],
	},
];

export default variations;
