import { __ } from '@wordpress/i18n';

import Edit from './edit';
import Save from './save';
import metadata from './block.json';

import './style.css';

const { name } = metadata;
export { metadata, name };

export const settings = {
    ...metadata,
    title: __('User Name', 'wpuf-pro'),
    description: metadata.description,
    icon: 
    <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg">
        <rect x="2" y="2" width="14" height="14" rx="3" fill="#059669"/>
        <path d="M9 6C10.1046 6 11 6.89543 11 8C11 9.10457 10.1046 10 9 10C7.89543 10 7 9.10457 7 8C7 6.89543 7.89543 6 9 6Z" fill="white"/>
        <path d="M6 12C6 10.8954 6.89543 10 8 10H10C11.1046 10 12 10.8954 12 12V13H6V12Z" fill="white"/>
    </svg>,
    category: metadata.category,
    edit: Edit,
    save: Save,
};
