/**
 * WordPress dependencies
 */
import { __ } from '@wordpress/i18n';
import { useBlockProps, InspectorControls } from '@wordpress/block-editor';
import { PanelBody, TextControl, SelectControl, ToggleControl } from '@wordpress/components';
import StandardInspectorControls, { StandardPanelRow, createInspectorControls } from '../../components/InspectorControls/StandardInspectorControls';
import StandardErrorBoundary, { StandardLoading, StandardEmptyState, StandardErrorMessage } from '../../components/ErrorHandling/StandardErrorBoundary';

/**
 * Block Edit Component
 * 
 * This is the editor view of the block.
 * It shows how the block will look in the editor.
 */
export default function Edit({ attributes, setAttributes, context }) {
    const { 
        // Add your block attributes here
        exampleAttribute = 'default value'
    } = attributes;

    // Get user data from context
    const userData = context?.['wpuf-ud/userObject'] || {
        id: 1,
        user_login: 'sampleuser',
        display_name: __('Sample User', 'wpuf-pro'),
        user_email: 'sample@example.com'
    };

    const blockProps = useBlockProps({
        className: 'wpuf-ud-block-template'
    });

    // Create organized inspector controls
    const inspectorControls = createInspectorControls({
        display: (
            <StandardPanelRow>
                <ToggleControl
                    label={__('Show Example', 'wpuf-pro')}
                    checked={exampleAttribute === 'show'}
                    onChange={(value) => setAttributes({ 
                        exampleAttribute: value ? 'show' : 'hide' 
                    })}
                    help={__('Toggle to show or hide example content', 'wpuf-pro')}
                    __nextHasNoMarginBottom={true}
                />
            </StandardPanelRow>
        ),
        content: (
            <StandardPanelRow>
                <TextControl
                    label={__('Example Text', 'wpuf-pro')}
                    value={exampleAttribute}
                    onChange={(value) => setAttributes({ exampleAttribute: value })}
                    placeholder={__('Enter example text', 'wpuf-pro')}
                    __next40pxDefaultSize={true}
                    __nextHasNoMarginBottom={true}
                />
            </StandardPanelRow>
        ),
        advanced: (
            <StandardPanelRow>
                <SelectControl
                    label={__('Example Style', 'wpuf-pro')}
                    value={exampleAttribute}
                    options={[
                        { label: __('Default', 'wpuf-pro'), value: 'default' },
                        { label: __('Bold', 'wpuf-pro'), value: 'bold' },
                        { label: __('Italic', 'wpuf-pro'), value: 'italic' }
                    ]}
                    onChange={(value) => setAttributes({ exampleAttribute: value })}
                    __next40pxDefaultSize={true}
                    __nextHasNoMarginBottom={true}
                />
            </StandardPanelRow>
        )
    });

    return (
        <StandardErrorBoundary>
            <StandardInspectorControls>
                {inspectorControls}
            </StandardInspectorControls>

            <div {...blockProps}>
                <div className="wpuf-ud-block-template-content">
                    <h3>{__('Block Template', 'wpuf-pro')}</h3>
                    <p>
                        {__('This is a template block. Replace this content with your actual block implementation.', 'wpuf-pro')}
                    </p>
                    <p>
                        <strong>{__('User Data:', 'wpuf-pro')}</strong> {userData.display_name}
                    </p>
                    <p>
                        <strong>{__('Attribute Value:', 'wpuf-pro')}</strong> {exampleAttribute}
                    </p>
                    
                    {/* Example of error handling usage */}
                    {!userData && (
                        <StandardEmptyState 
                            title={__('No User Data', 'wpuf-pro')}
                            message={__('No user data is available for this block.', 'wpuf-pro')}
                        />
                    )}
                </div>
            </div>
        </StandardErrorBoundary>
    );
}
